/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.progressbar.internal;

import com.liferay.faces.alloy.component.progressbar.ProgressBar;
import com.liferay.faces.alloy.component.progressbar.internal.ProgressBarAjaxBehavior;
import com.liferay.faces.alloy.component.progressbar.internal.ProgressBarRendererBase;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.context.FacesRequestContext;
import com.liferay.faces.util.render.BufferedScriptResponseWriter;
import com.liferay.faces.util.render.JavaScriptFragment;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="com.liferay.faces.alloy.component.progressbar", rendererType="com.liferay.faces.alloy.component.progressbar.ProgressBarRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy", name="alloy.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class ProgressBarRenderer
extends ProgressBarRendererBase {
    private static final String COMPLETE = "complete";
    private static final String CONTENT_BOX_SUFFIX = "_contentBox";
    private static final String HIDDEN_SUFFIX = "_hidden";
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String TOKEN = "{0}";
    private static final String VALUE_CHANGE = "valueChange";
    private static final String VERTICAL = "vertical";

    @Override
    public void encodeJavaScript(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (this.isAjaxPolling(facesContext, uiComponent)) {
            ProgressBar progressBar = (ProgressBar)uiComponent;
            String clientVarName = this.getClientVarName(facesContext, progressBar);
            String clientKey = progressBar.getClientKey();
            if (clientKey == null) {
                clientKey = clientVarName;
            }
            BufferedScriptResponseWriter bufferedScriptResponseWriter = new BufferedScriptResponseWriter();
            String clientId = progressBar.getClientId(facesContext);
            String hiddenClientId = clientId.concat(HIDDEN_SUFFIX);
            JavaScriptFragment liferayComponent = new JavaScriptFragment("Liferay.component('" + clientKey + "')");
            Integer value = progressBar.getValue();
            this.encodeFunctionCall((ResponseWriter)bufferedScriptResponseWriter, "LFAI.setProgressBarServerValue", new Object[]{hiddenClientId, liferayComponent, value});
            FacesRequestContext facesRequestContext = FacesRequestContext.getCurrentInstance();
            facesRequestContext.addScript(bufferedScriptResponseWriter.toString());
        } else {
            super.encodeJavaScript(facesContext, uiComponent);
        }
    }

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        ProgressBar progressBar = (ProgressBar)uiComponent;
        String clientVarName = this.getClientVarName(facesContext, progressBar);
        String clientKey = progressBar.getClientKey();
        if (clientKey == null) {
            clientKey = clientVarName;
        }
        Map clientBehaviorMap = progressBar.getClientBehaviors();
        List pollEventClientBehaviors = (List)clientBehaviorMap.get("poll");
        String javaScriptText = "Liferay.component('".concat(clientKey).concat("')");
        if (pollEventClientBehaviors != null && !pollEventClientBehaviors.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("function(pollingFunction){");
            buf.append("var event = null;");
            String clientId = progressBar.getClientId(facesContext);
            ClientBehaviorContext clientBehaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)progressBar, (String)"poll", (String)clientId, null);
            int size = pollEventClientBehaviors.size();
            JavaScriptFragment liferayComponent = new JavaScriptFragment(javaScriptText);
            for (int i = 0; i < size; ++i) {
                Object pollEventClientBehavior = (ClientBehavior)pollEventClientBehaviors.get(i);
                if (i == 0) {
                    AjaxBehavior firstPollEventAjaxBehavior = (AjaxBehavior)pollEventClientBehavior;
                    String stopPollingFunction = "function(){".concat(liferayComponent.toString()).concat(".stopPolling();}");
                    pollEventClientBehavior = new ProgressBarAjaxBehavior(firstPollEventAjaxBehavior, "pollingFunction", stopPollingFunction);
                }
                buf.append(pollEventClientBehavior.getScript(clientBehaviorContext));
                buf.append(";");
            }
            buf.append("}");
            JavaScriptFragment anonymousFunction = new JavaScriptFragment(buf.toString());
            Integer pollingDelay = progressBar.getPollingDelay();
            this.encodeFunctionCall(responseWriter, "LFAI.initProgressBarServerMode", new Object[]{liferayComponent, clientId, pollingDelay, anonymousFunction});
        } else {
            JavaScriptFragment liferayComponent = new JavaScriptFragment(javaScriptText);
            this.encodeFunctionCall(responseWriter, "LFAI.initProgressBarClientMode", new Object[]{liferayComponent});
        }
    }

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (!this.isAjaxPolling(facesContext, uiComponent)) {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.startElement("div", uiComponent);
            String clientId = uiComponent.getClientId(facesContext);
            responseWriter.writeAttribute("id", (Object)clientId, "id");
            Styleable styleable = (Styleable)uiComponent;
            RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)styleable, (String[])new String[0]);
            if (this.isServerPollingEnabled(uiComponent)) {
                String hiddenClientId = clientId.concat(HIDDEN_SUFFIX);
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("id", (Object)hiddenClientId, null);
                responseWriter.writeAttribute("name", (Object)hiddenClientId, null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("value", (Object)"", null);
                responseWriter.endElement("input");
            }
            String contentBoxClientId = clientId.concat(CONTENT_BOX_SUFFIX);
            responseWriter.startElement("div", null);
            responseWriter.writeAttribute("id", (Object)contentBoxClientId, null);
            responseWriter.endElement("div");
        }
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (!this.isAjaxPolling(facesContext, uiComponent)) {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.endElement("div");
        }
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, ProgressBar progressBar, boolean first) throws IOException {
        String label;
        this.encodeWidgetRender(responseWriter, first);
        first = false;
        String clientId = progressBar.getClientId(facesContext);
        String contentBoxClientId = clientId.concat(CONTENT_BOX_SUFFIX);
        this.encodeClientId(responseWriter, "contentBox", contentBoxClientId, first);
        this.encodeNonEscapedObject(responseWriter, "on", "", first);
        responseWriter.write("{");
        boolean onFirst = true;
        String oncomplete = progressBar.getOncomplete();
        Map clientBehaviorMap = progressBar.getClientBehaviors();
        List clientBehaviorsForComplete = (List)clientBehaviorMap.get("progressComplete");
        if (oncomplete != null || clientBehaviorsForComplete != null && !clientBehaviorsForComplete.isEmpty()) {
            StringBuilder onCompleteBuilder = new StringBuilder();
            onCompleteBuilder.append("function(event){");
            if (oncomplete != null) {
                onCompleteBuilder.append(oncomplete);
            }
            if (clientBehaviorsForComplete != null && !clientBehaviorsForComplete.isEmpty()) {
                ClientBehaviorContext clientBehaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)progressBar, (String)"progressComplete", (String)clientId, null);
                for (ClientBehavior clientBehaviorForComplete : clientBehaviorsForComplete) {
                    onCompleteBuilder.append(clientBehaviorForComplete.getScript(clientBehaviorContext));
                    onCompleteBuilder.append(";");
                }
            }
            onCompleteBuilder.append("}");
            this.encodeNonEscapedObject(responseWriter, COMPLETE, onCompleteBuilder.toString(), onFirst);
            onFirst = false;
        }
        if ((label = progressBar.getLabel()) != null && label.contains(TOKEN)) {
            String escapedLabel = RendererUtil.escapeJavaScript((String)label);
            this.encodeNonEscapedObject(responseWriter, VALUE_CHANGE, "function(event){this.set('label','".concat(escapedLabel).concat("'.replace(LFAI.TOKEN_REGEX, event.newVal));}"), onFirst);
            onFirst = false;
        }
        responseWriter.write("}");
    }

    @Override
    protected void encodeLabel(ResponseWriter responseWriter, ProgressBar progressBar, String label, boolean first) throws IOException {
        Integer value = progressBar.getValue();
        label = label.replace(TOKEN, value.toString());
        super.encodeLabel(responseWriter, progressBar, label, first);
    }

    @Override
    protected void encodeOrientation(ResponseWriter responseWriter, ProgressBar progressBar, String layout, boolean first) throws IOException {
        if (PAGE_DIRECTION.equals(layout)) {
            super.encodeOrientation(responseWriter, progressBar, VERTICAL, first);
        }
    }

    private boolean isAjaxPolling(FacesContext facesContext, UIComponent uiComponent) {
        boolean polling = false;
        if (this.isServerPollingEnabled(uiComponent) && facesContext.getPartialViewContext().isAjaxRequest()) {
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestParameterMap = externalContext.getRequestParameterMap();
            String hiddenClientId = uiComponent.getClientId(facesContext) + HIDDEN_SUFFIX;
            String pollingString = (String)requestParameterMap.get(hiddenClientId);
            polling = Boolean.parseBoolean(pollingString);
        }
        return polling;
    }

    private boolean isServerPollingEnabled(UIComponent uiComponent) {
        ProgressBar progressBar = (ProgressBar)uiComponent;
        Map clientBehaviorMap = progressBar.getClientBehaviors();
        List clientBehaviorsForPolling = (List)clientBehaviorMap.get("poll");
        return clientBehaviorsForPolling != null && !clientBehaviorsForPolling.isEmpty();
    }
}

