/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.paginator.internal;

import com.liferay.faces.alloy.component.commandlink.CommandLink;
import com.liferay.faces.alloy.component.outputtext.OutputText;
import com.liferay.faces.alloy.component.paginator.Paginator;
import com.liferay.faces.alloy.component.paginator.internal.PaginatorRendererBase;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.i18n.I18n;
import com.liferay.faces.util.i18n.I18nFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="com.liferay.faces.alloy.component.paginator", rendererType="com.liferay.faces.alloy.component.paginator.PaginatorRenderer")
@ListenerFor(systemEventClass=PostAddToViewEvent.class, sourceClass=Paginator.class)
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css")})
public class PaginatorRenderer
extends PaginatorRendererBase
implements ComponentSystemEventListener {
    private static final Logger logger = LoggerFactory.getLogger(PaginatorRenderer.class);

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        boolean activatedPaginationControl = false;
        RendererUtil.decodeClientBehaviors((FacesContext)facesContext, (UIComponent)uiComponent);
        Paginator paginator = (Paginator)uiComponent;
        UIData uiData = paginator.getUIData();
        if (uiData != null) {
            String paginatorActionParamName;
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestParameterMap = externalContext.getRequestParameterMap();
            String paginatorAction = (String)requestParameterMap.get(paginatorActionParamName = uiComponent.getClientId().concat("_paginatorAction"));
            if (paginatorAction != null) {
                if ("firstPage".equals(paginatorAction)) {
                    uiData.setFirst(0);
                    activatedPaginationControl = true;
                } else if ("previousPage".equals(paginatorAction)) {
                    int rows = uiData.getRows();
                    int first = uiData.getFirst();
                    if ((first -= rows) >= 0) {
                        uiData.setFirst(first);
                    }
                    activatedPaginationControl = true;
                } else if ("nextPage".equals(paginatorAction)) {
                    int rows = uiData.getRows();
                    int rowCount = uiData.getRowCount();
                    int first = uiData.getFirst();
                    if ((first += rows) < rowCount) {
                        uiData.setFirst(first);
                    }
                    activatedPaginationControl = true;
                } else if ("lastPage".equals(paginatorAction)) {
                    uiData.setFirst(uiData.getRowCount() / uiData.getRows() * uiData.getRows());
                    activatedPaginationControl = true;
                } else {
                    try {
                        int pageNumber = Integer.parseInt(paginatorAction);
                        int pageIndex = pageNumber - 1;
                        int first = pageIndex * uiData.getRows();
                        if (first > uiData.getRowCount()) {
                            first = 0;
                        }
                        uiData.setFirst(first);
                        activatedPaginationControl = true;
                    }
                    catch (NumberFormatException e) {
                        logger.error("Invalid parameter value paginatorAction=[{0}]", new Object[]{paginatorAction});
                    }
                }
            }
            if (activatedPaginationControl) {
                facesContext.renderResponse();
            }
        } else {
            logger.error("The alloy:paginator must have it's for attribute set or it must be inside of an f:facet of an alloy:dataTable or alloy:dataList");
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Paginator paginator = (Paginator)uiComponent;
        String clientId = paginator.getClientId(facesContext);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", uiComponent);
        responseWriter.writeAttribute("id", (Object)clientId, null);
        RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)((Styleable)uiComponent), (String[])new String[0]);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot.getLocale();
        UIData uiData = paginator.getUIData();
        int first = uiData.getFirst();
        int rows = uiData.getRows();
        int curPage = first / rows + 1;
        int rowCount = uiData.getRowCount();
        int pageCount = (int)Math.ceil((double)rowCount / (double)rows);
        String summaryPosition = paginator.getSummaryPosition();
        if ("top".equals(summaryPosition)) {
            this.encodeSummary(facesContext, responseWriter, paginator, summaryPosition, locale, first, curPage, rows, rowCount, pageCount);
        }
        boolean showPageNumberControls = paginator.isShowPageNumberControls();
        boolean showFirstPageControl = paginator.isShowFirstPageControl();
        boolean showLastPageControl = paginator.isShowLastPageControl();
        boolean showNextPageControl = paginator.isShowNextPageControl();
        boolean showPreviousPageControl = paginator.isShowPreviousPageControl();
        if (showPageNumberControls || showFirstPageControl || showLastPageControl || showNextPageControl || showPreviousPageControl) {
            responseWriter.startElement("div", uiComponent);
            responseWriter.startElement("ul", uiComponent);
            responseWriter.writeAttribute("class", (Object)"pagination", null);
            if ("left".equals(summaryPosition)) {
                this.encodeSummary(facesContext, responseWriter, paginator, summaryPosition, locale, first, curPage, rows, rowCount, pageCount);
            }
            if (showFirstPageControl) {
                this.encodeFirstPageListItem(facesContext, responseWriter, paginator, clientId, first);
            }
            if (showPreviousPageControl) {
                this.encodePrevPageListItem(facesContext, responseWriter, paginator, clientId, first);
            }
            if (showPageNumberControls) {
                int firstPage = paginator.getFirstPage();
                int lastPage = firstPage + paginator.getMaxPageNumberControls() - 1;
                while (curPage < firstPage) {
                    --firstPage;
                    --lastPage;
                }
                while (curPage > lastPage) {
                    ++firstPage;
                    ++lastPage;
                }
                paginator.setFirstPage(firstPage);
                if (lastPage > pageCount) {
                    lastPage = pageCount;
                }
                for (int i = firstPage; i <= lastPage; ++i) {
                    this.encodePageNumberListItem(facesContext, responseWriter, paginator, clientId, i, curPage, first, rows, rowCount);
                }
            }
            if (showNextPageControl) {
                this.encodeNextPageListItem(facesContext, responseWriter, paginator, uiData, clientId);
            }
            if (showLastPageControl) {
                this.encodeLastPageListItem(facesContext, responseWriter, paginator, uiData, clientId);
            }
            if ("right".equals(summaryPosition)) {
                this.encodeSummary(facesContext, responseWriter, paginator, summaryPosition, locale, first, curPage, rows, rowCount, pageCount);
            }
            responseWriter.endElement("ul");
            responseWriter.endElement("div");
        }
        if ("bottom".equals(summaryPosition)) {
            this.encodeSummary(facesContext, responseWriter, paginator, summaryPosition, locale, first, curPage, rows, rowCount, pageCount);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
    }

    public void processEvent(ComponentSystemEvent componentSystemEvent) throws AbortProcessingException {
        Paginator paginator = (Paginator)componentSystemEvent.getComponent();
        if (paginator.isAjax()) {
            RendererUtil.addDefaultAjaxBehavior((ClientBehaviorHolder)paginator, (String)paginator.getExecute(), (String)paginator.getProcess(), (String)"@this", (String)paginator.getRender(), (String)paginator.getUpdate(), (String)"@this @for");
        }
    }

    protected void encodeFirstPageListItem(FacesContext facesContext, ResponseWriter responseWriter, Paginator paginator, String clientId, int first) throws IOException {
        boolean enabled = first > 0;
        String firstPageLabel = paginator.getFirstPageLabel();
        this.encodeUnorderedListItem(facesContext, responseWriter, paginator, clientId, "firstPage", firstPageLabel, enabled, false);
    }

    protected void encodeLastPageListItem(FacesContext facesContext, ResponseWriter responseWriter, Paginator paginator, UIData uiData, String clientId) throws IOException {
        boolean enabled = uiData.getFirst() + uiData.getRows() < uiData.getRowCount();
        String lastPageLabel = paginator.getLastPageLabel();
        this.encodeUnorderedListItem(facesContext, responseWriter, paginator, clientId, "lastPage", lastPageLabel, enabled, false);
    }

    protected void encodeNextPageListItem(FacesContext facesContext, ResponseWriter responseWriter, Paginator paginator, UIData uiData, String clientId) throws IOException {
        boolean enabled = uiData.getFirst() + uiData.getRows() < uiData.getRowCount();
        String nextPageLabel = paginator.getNextPageLabel();
        this.encodeUnorderedListItem(facesContext, responseWriter, paginator, clientId, "nextPage", nextPageLabel, enabled, false);
    }

    protected void encodePageNumberListItem(FacesContext facesContext, ResponseWriter responseWriter, Paginator paginator, String clientId, int pageNumber, int curPageNumber, int first, int rows, int rowCount) throws IOException {
        String paginatorAction;
        boolean current = pageNumber == curPageNumber;
        boolean enabled = !current;
        String pageNumberLabel = paginatorAction = Integer.toString(pageNumber);
        if (pageNumber < 10) {
            pageNumberLabel = "&nbsp;".concat(pageNumberLabel).concat("&nbsp;");
        }
        this.encodeUnorderedListItem(facesContext, responseWriter, paginator, clientId, paginatorAction, pageNumberLabel, enabled, current);
    }

    protected void encodePrevPageListItem(FacesContext facesContext, ResponseWriter responseWriter, Paginator paginator, String clientId, int first) throws IOException {
        boolean enabled = first > 0;
        String previousPageLabel = paginator.getPreviousPageLabel();
        this.encodeUnorderedListItem(facesContext, responseWriter, paginator, clientId, "previousPage", previousPageLabel, enabled, false);
    }

    protected void encodeSummary(FacesContext facesContext, ResponseWriter responseWriter, Paginator paginator, String summaryPostion, Locale locale, int first, int curPageNumber, int rows, int rowCount, int pageCount) throws IOException {
        boolean encodePaginationDiv;
        boolean bl = encodePaginationDiv = "top".equals(summaryPostion) || "bottom".equals(summaryPostion);
        if (encodePaginationDiv) {
            responseWriter.startElement("div", (UIComponent)paginator);
            responseWriter.startElement("ul", (UIComponent)paginator);
            responseWriter.writeAttribute("class", (Object)"pagination", null);
        }
        int paginatorFirst = first + 1;
        int paginatorLast = Math.min(first + rows, rowCount);
        ExternalContext externalContext = facesContext.getExternalContext();
        I18n i18n = I18nFactory.getI18nInstance((ExternalContext)externalContext);
        String message = i18n.getMessage(facesContext, locale, "results-x-x-of-x-page-x-of-x", new Object[]{paginatorFirst, paginatorLast, rowCount, curPageNumber, pageCount});
        responseWriter.startElement("li", (UIComponent)paginator);
        responseWriter.startElement("span", (UIComponent)paginator);
        responseWriter.writeAttribute("class", (Object)"alloy-paginator-summary disabled", null);
        responseWriter.writeText((Object)message, (UIComponent)paginator, null);
        responseWriter.endElement("span");
        responseWriter.endElement("li");
        if (encodePaginationDiv) {
            responseWriter.endElement("ul");
            responseWriter.endElement("div");
        }
    }

    protected void encodeUnorderedListItem(FacesContext facesContext, ResponseWriter responseWriter, Paginator paginator, String clientId, String paginatorAction, String text, boolean enabled, boolean current) throws IOException {
        responseWriter.startElement("li", (UIComponent)paginator);
        if (enabled) {
            String clientBehaviorScript = this.getClientBehaviorScript(facesContext, paginator, clientId, paginatorAction);
            if (clientBehaviorScript != null) {
                responseWriter.startElement("a", (UIComponent)paginator);
                responseWriter.writeAttribute("href", (Object)"javascript:void(0);", null);
                responseWriter.writeAttribute("onclick", (Object)clientBehaviorScript, null);
                responseWriter.write(text);
                responseWriter.endElement("a");
            } else {
                Application application = facesContext.getApplication();
                CommandLink commandLink = (CommandLink)application.createComponent(facesContext, "com.liferay.faces.alloy.component.commandlink.CommandLink", "com.liferay.faces.alloy.component.commandlink.CommandLinkRenderer");
                commandLink.setAjax(paginator.isAjax());
                OutputText outputText = (OutputText)application.createComponent(facesContext, "com.liferay.faces.alloy.component.outputtext.OutputText", "com.liferay.faces.alloy.component.outputtext.OutputTextRenderer");
                List paginatorChildren = paginator.getChildren();
                paginatorChildren.add(commandLink);
                UIParameter uiParameter = new UIParameter();
                String paginatorActionParamName = clientId.concat("_paginatorAction");
                uiParameter.setName(paginatorActionParamName);
                uiParameter.setValue((Object)paginatorAction);
                List commandLinkChildren = commandLink.getChildren();
                commandLinkChildren.add(uiParameter);
                commandLinkChildren.add(outputText);
                outputText.setEscape(false);
                outputText.setValue(text);
                commandLink.encodeAll(facesContext);
                commandLinkChildren.remove((Object)outputText);
                commandLinkChildren.remove(uiParameter);
                paginatorChildren.remove((Object)commandLink);
            }
        } else {
            if (current) {
                responseWriter.writeAttribute("class", (Object)"active", null);
            } else {
                responseWriter.writeAttribute("class", (Object)"disabled", null);
            }
            responseWriter.startElement("span", (UIComponent)paginator);
            responseWriter.write(text);
            responseWriter.endElement("span");
        }
        responseWriter.endElement("li");
    }

    protected String getClientBehaviorScript(FacesContext facesContext, Paginator paginator, String clientId, String paginatorAction) {
        String clientBehaviorScript = null;
        Map clientBehaviorMap = paginator.getClientBehaviors();
        String defaultEventName = paginator.getDefaultEventName();
        String paginatorActionParamName = clientId.concat("_paginatorAction");
        List clientBehaviorsForEvent = (List)clientBehaviorMap.get(defaultEventName);
        if (clientBehaviorsForEvent != null) {
            for (ClientBehavior clientBehavior : clientBehaviorsForEvent) {
                ArrayList<ClientBehaviorContext.Parameter> parameters = new ArrayList<ClientBehaviorContext.Parameter>();
                parameters.add(new ClientBehaviorContext.Parameter(paginatorActionParamName, (Object)paginatorAction));
                ClientBehaviorContext clientBehaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)paginator, (String)defaultEventName, (String)clientId, parameters);
                clientBehaviorScript = clientBehavior.getScript(clientBehaviorContext);
            }
        }
        return clientBehaviorScript;
    }
}

