/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.media.internal;

import com.liferay.faces.alloy.component.media.Media;
import com.liferay.faces.alloy.component.media.internal.MediaRendererCompat;
import com.liferay.faces.alloy.component.resource.Resource;
import com.liferay.faces.util.application.FacesResource;
import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.client.BrowserSnifferFactory;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.faces.application.Application;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public abstract class MediaRenderer
extends MediaRendererCompat {
    private static final Logger logger = LoggerFactory.getLogger(MediaRenderer.class);
    private static final String HEIGHT = "height";
    protected static final String WIDTH = "width";
    private static final String RES_NOT_FOUND_ERROR_MSG = "Resource handler=[{0}] was unable to create a resource for resourceName=[{1}] libraryName=[{2}]";
    private static final String RES_NOT_FOUND = "RES_NOT_FOUND";
    private static final String[] MEDIA_DOM_EVENTS = new String[]{"onabort", "onblur", "oncanplay", "oncanplaythrough", "ondurationchange", "onemptied", "onended", "onerror", "onfocus", "onloadeddata", "onloadedmetadata", "onloadstart", "onpause", "onplay", "onplaying", "onprogress", "onratechange", "onseeked", "onseeking", "onstalled", "onsuspend", "ontimeupdate", "onvolumechange", "onwaiting"};

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String preload;
        boolean muted;
        boolean loop;
        boolean controls;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        responseWriter.writeAttribute("id", (Object)clientId, "id");
        responseWriter.writeAttribute("name", (Object)clientId, null);
        Media media = (Media)uiComponent;
        RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)media, (String[])new String[0]);
        responseWriter.startElement(this.getMediaType(), (UIComponent)media);
        boolean autoplay = media.isAutoplay();
        if (autoplay) {
            responseWriter.writeAttribute("autoplay", (Object)"true", "autoplay");
        }
        if (controls = media.isControls()) {
            responseWriter.writeAttribute("controls", (Object)"true", "controls");
        }
        if (loop = media.isLoop()) {
            responseWriter.writeAttribute("loop", (Object)"true", "loop");
        }
        if (muted = media.isMuted()) {
            responseWriter.writeAttribute("muted", (Object)"true", "muted");
        }
        if ((preload = media.getPreload()) != null) {
            responseWriter.writeAttribute("preload", (Object)preload, "preload");
        }
        this.encodeMediaSize(responseWriter, media);
        this.encodePassThroughAttributes(responseWriter, uiComponent, KEYBOARD_DOM_EVENTS);
        this.encodePassThroughAttributes(responseWriter, uiComponent, MOUSE_DOM_EVENTS);
        this.encodePassThroughAttributes(responseWriter, uiComponent, MEDIA_DOM_EVENTS);
        this.encodeJSF22PassthroughAttributes(facesContext, media, responseWriter);
        this.encodeCustomMediaAttributes(facesContext, responseWriter, media);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Media media = (Media)uiComponent;
        String name = media.getName();
        Object value = media.getValue();
        Application application = facesContext.getApplication();
        ResourceHandler resourceHandler = application.getResourceHandler();
        String firstMediaResourceURL = null;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (name != null) {
            String library = media.getLibrary();
            if (name.length() > 0 && library != null && library.length() > 0) {
                javax.faces.application.Resource mediaResource = resourceHandler.createResource(name, library);
                String contentType = media.getContentType();
                if (mediaResource != null) {
                    String mediaRequestPath = mediaResource.getRequestPath();
                    ExternalContext externalContext = facesContext.getExternalContext();
                    firstMediaResourceURL = externalContext.encodeResourceURL(mediaRequestPath);
                    if (contentType == null) {
                        contentType = mediaResource.getContentType();
                    }
                } else {
                    firstMediaResourceURL = RES_NOT_FOUND;
                    logger.error(RES_NOT_FOUND_ERROR_MSG, new Object[]{resourceHandler, name, library});
                }
                this.encodeMediaSource(responseWriter, firstMediaResourceURL, contentType);
            }
        } else if (value != null) {
            if (value instanceof Collection || value instanceof FacesResource[]) {
                List<FacesResource> facesResources;
                if (value instanceof Collection) {
                    facesResources = (List<FacesResource>)value;
                } else {
                    FacesResource[] resourcesAsArray = (FacesResource[])value;
                    facesResources = Arrays.asList(resourcesAsArray);
                }
                for (FacesResource facesResource : facesResources) {
                    String mediaResourceURL;
                    String facesResourceName = facesResource.getName();
                    String facesResourceLibrary = facesResource.getLibrary();
                    javax.faces.application.Resource mediaResource = resourceHandler.createResource(facesResourceName, facesResourceLibrary);
                    String contentType = facesResource.getContentType();
                    if (mediaResource != null) {
                        String mediaRequestPath = mediaResource.getRequestPath();
                        ExternalContext externalContext = facesContext.getExternalContext();
                        mediaResourceURL = externalContext.encodeResourceURL(mediaRequestPath);
                        if (contentType == null) {
                            contentType = mediaResource.getContentType();
                        }
                    } else {
                        mediaResourceURL = RES_NOT_FOUND;
                        logger.error(RES_NOT_FOUND_ERROR_MSG, new Object[]{resourceHandler, facesResourceName, facesResourceLibrary});
                    }
                    if (firstMediaResourceURL == null) {
                        firstMediaResourceURL = mediaResourceURL;
                    }
                    this.encodeMediaSource(responseWriter, mediaResourceURL, contentType);
                }
            } else {
                String contentType = media.getContentType();
                if (value instanceof FacesResource) {
                    FacesResource facesResource = (FacesResource)value;
                    String facesResourceName = facesResource.getName();
                    String facesResourceLibrary = facesResource.getLibrary();
                    javax.faces.application.Resource mediaResource = resourceHandler.createResource(facesResourceName, facesResourceLibrary);
                    if (contentType == null) {
                        contentType = facesResource.getContentType();
                    }
                    if (mediaResource != null) {
                        String mediaRequestPath = mediaResource.getRequestPath();
                        ExternalContext externalContext = facesContext.getExternalContext();
                        firstMediaResourceURL = externalContext.encodeResourceURL(mediaRequestPath);
                        if (contentType == null) {
                            contentType = mediaResource.getContentType();
                        }
                    } else {
                        firstMediaResourceURL = RES_NOT_FOUND;
                        logger.error(RES_NOT_FOUND_ERROR_MSG, new Object[]{resourceHandler, facesResourceName, facesResourceLibrary});
                    }
                } else {
                    String valueAsString = value.toString();
                    firstMediaResourceURL = this.getEncodedResourceURL(facesContext, resourceHandler, application, valueAsString);
                }
                this.encodeMediaSource(responseWriter, firstMediaResourceURL, contentType);
            }
        }
        List children = uiComponent.getChildren();
        for (UIComponent child : children) {
            if (child instanceof Resource) {
                String mediaResourceURL;
                String resourceLibrary;
                Resource resource = (Resource)child;
                String contentType = resource.getContentType();
                String resourceName = resource.getName();
                javax.faces.application.Resource mediaResource = resourceHandler.createResource(resourceName, resourceLibrary = resource.getLibrary());
                if (mediaResource != null) {
                    String mediaRequestPath = mediaResource.getRequestPath();
                    ExternalContext externalContext = facesContext.getExternalContext();
                    mediaResourceURL = externalContext.encodeResourceURL(mediaRequestPath);
                    if (contentType == null) {
                        contentType = mediaResource.getContentType();
                    }
                } else {
                    mediaResourceURL = RES_NOT_FOUND;
                    logger.error(RES_NOT_FOUND_ERROR_MSG, new Object[]{resourceHandler, resourceName, resourceLibrary});
                }
                this.encodeMediaSource(responseWriter, mediaResourceURL, contentType);
                if (firstMediaResourceURL != null) continue;
                firstMediaResourceURL = mediaResourceURL;
                continue;
            }
            child.encodeAll(facesContext);
        }
        if (firstMediaResourceURL == null) {
            logger.warn("No {0} has been specified for <alloy:{0} id=[{1}] />.", new Object[]{this.getMediaType(), media.getClientId()});
        } else if (media.isDegrade()) {
            this.encodeFlashPlayer(facesContext, responseWriter, media, firstMediaResourceURL);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement(this.getMediaType());
        responseWriter.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected abstract void encodeCustomMediaAttributes(FacesContext var1, ResponseWriter var2, Media var3) throws IOException;

    protected abstract void encodeFlashPlayerChildren(FacesContext var1, ResponseWriter var2, Media var3, String var4, ResourceHandler var5, Application var6, boolean var7) throws IOException;

    protected abstract String getDefaultFlashPlayerName();

    protected abstract String getMediaType();

    protected void encodeFlashPlayer(FacesContext facesContext, ResponseWriter responseWriter, Media media, String mediaResourceURL) throws IOException {
        String flashPlayerURL;
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        boolean browserIE = browserSniffer.isIe();
        responseWriter.startElement("object", null);
        this.encodeMediaSize(responseWriter, media);
        Application application = facesContext.getApplication();
        ResourceHandler resourceHandler = application.getResourceHandler();
        Object flashPlayer = media.getFlashPlayer();
        if (flashPlayer != null) {
            flashPlayerURL = this.getEncodedResourceURL(facesContext, resourceHandler, application, flashPlayer);
        } else {
            javax.faces.application.Resource defaultFlashPlayerResource = resourceHandler.createResource(this.getDefaultFlashPlayerName(), "liferay-faces-alloy");
            String defaultFlashPlayerRequestPath = defaultFlashPlayerResource.getRequestPath();
            ExternalContext externalContext = facesContext.getExternalContext();
            flashPlayerURL = externalContext.encodeResourceURL(defaultFlashPlayerRequestPath);
        }
        if (browserIE) {
            responseWriter.writeAttribute("classid", (Object)"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000", null);
            String flashPlayerVersion = media.getFlashPlayerVersion();
            String codebaseURL = "http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=".concat(flashPlayerVersion);
            responseWriter.writeAttribute("codebase", (Object)codebaseURL, null);
            responseWriter.startElement("param", null);
            responseWriter.writeAttribute("name", (Object)"movie", null);
            responseWriter.writeAttribute("value", (Object)flashPlayerURL, null);
            responseWriter.endElement("param");
        } else {
            responseWriter.writeAttribute("data", (Object)flashPlayerURL, null);
            responseWriter.writeAttribute("type", (Object)"application/x-shockwave-flash", null);
        }
        this.encodeFlashPlayerChildren(facesContext, responseWriter, media, mediaResourceURL, resourceHandler, application, flashPlayer == null);
        responseWriter.endElement("object");
    }

    protected void encodeMediaSize(ResponseWriter responseWriter, Media media) throws IOException {
        StringBuilder styleStringBuilder = new StringBuilder();
        String height = this.getHeight(media);
        if (height == null) {
            styleStringBuilder.append("height:100%;");
        }
        responseWriter.writeAttribute(HEIGHT, (Object)height, HEIGHT);
        String width = this.getWidth(media);
        if (width == null) {
            styleStringBuilder.append("width:100%;");
        }
        responseWriter.writeAttribute(WIDTH, (Object)width, WIDTH);
        if (styleStringBuilder.length() > 0) {
            responseWriter.writeAttribute("style", (Object)styleStringBuilder, null);
        }
    }

    protected void encodeMediaSource(ResponseWriter responseWriter, String mediaResourceURL, String contentType) throws IOException {
        responseWriter.startElement("source", null);
        responseWriter.writeAttribute("src", (Object)mediaResourceURL, null);
        if (contentType != null) {
            responseWriter.writeAttribute("type", (Object)contentType, null);
        } else {
            logger.warn("The contentType of ResourceURL=[{0}] was not specified.", new Object[]{mediaResourceURL});
        }
        responseWriter.endElement("source");
    }

    protected String getEncodedResourceURL(FacesContext facesContext, ResourceHandler resourceHandler, Application application, Object value) {
        String encodedResourceURL;
        if (value instanceof FacesResource) {
            String library;
            FacesResource facesResource = (FacesResource)value;
            String name = facesResource.getName();
            javax.faces.application.Resource resource = resourceHandler.createResource(name, library = facesResource.getLibrary());
            if (resource != null) {
                String mediaRequestPath = resource.getRequestPath();
                ExternalContext externalContext = facesContext.getExternalContext();
                encodedResourceURL = externalContext.encodeResourceURL(mediaRequestPath);
            } else {
                encodedResourceURL = RES_NOT_FOUND;
                logger.error(RES_NOT_FOUND_ERROR_MSG, new Object[]{resourceHandler, name, library});
            }
        } else {
            String posterString = value.toString();
            encodedResourceURL = this.getEncodedResourceURL(facesContext, resourceHandler, application, posterString);
        }
        return encodedResourceURL;
    }

    protected String getHeight(Media media) {
        return null;
    }

    protected String getWidth(Media media) {
        return null;
    }

    private String getEncodedResourceURL(FacesContext facesContext, ResourceHandler resourceHandler, Application application, String resourceURL) {
        String encodedResourceURL = resourceURL;
        if (!this.isEncodedResourceURL(facesContext, resourceHandler, encodedResourceURL)) {
            ViewHandler viewHandler = application.getViewHandler();
            resourceURL = viewHandler.getResourceURL(facesContext, resourceURL);
            ExternalContext externalContext = facesContext.getExternalContext();
            encodedResourceURL = externalContext.encodeResourceURL(resourceURL);
        }
        return encodedResourceURL;
    }
}

