/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputtime;

import com.liferay.faces.alloy.component.inputtime.InputTimeBase;
import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.client.BrowserSnifferFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.faces.FacesException;
import javax.faces.component.FacesComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

@FacesComponent(value="com.liferay.faces.alloy.component.inputtime.InputTime")
public class InputTime
extends InputTimeBase {
    public static final String DEFAULT_HTML5_TIME_PATTERN = "HH:mm";
    private static final String MIN_MAX_TIME_PATTERN = "HH:mm:ss";

    @Override
    public String getPattern() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        String timePattern = browserSniffer.isMobile() && this.isNativeWhenMobile() ? DEFAULT_HTML5_TIME_PATTERN : super.getPattern();
        return timePattern;
    }

    protected void validateValue(FacesContext facesContext, Object newValue) {
        super.validateValue(facesContext, newValue);
        if (this.isValid() && newValue != null) {
            String timeZoneAsString = this.getTimeZone();
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneAsString);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(MIN_MAX_TIME_PATTERN);
            simpleDateFormat.setTimeZone(timeZone);
            String minTimeString = this.getMinTime();
            String maxTimeString = this.getMaxTime();
            try {
                Date minTime = simpleDateFormat.parse(minTimeString);
                Date maxTime = simpleDateFormat.parse(maxTimeString);
                super.validateValue(facesContext, newValue, minTime, maxTime, timeZone);
            }
            catch (ParseException e) {
                FacesException facesException = new FacesException((Throwable)e);
                throw facesException;
            }
        }
    }
}

