/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.field;

import com.liferay.faces.alloy.component.field.FieldBase;
import com.liferay.faces.alloy.component.selectbooleancheckbox.SelectBooleanCheckbox;
import com.liferay.faces.util.component.ComponentUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIMessage;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;

@FacesComponent(value="com.liferay.faces.alloy.component.field.Field")
public class Field
extends FieldBase {
    private static final String FORM_GROUP = "form-group";
    private static final String HAS_ERROR = "has-error";
    private static final String HAS_WARNING = "has-warning";
    private static final String HAS_SUCCESS = "has-success";

    @Override
    public String getStyleClass() {
        String controlGroupCssClass = FORM_GROUP;
        boolean editableValueHoldersExist = false;
        boolean editableValueHoldersValid = false;
        FacesMessage.Severity severity = null;
        List<EditableValueHolder> editableValueHolders = this.getEditableValueHoldersRecurse((UIComponent)this);
        if (editableValueHolders != null) {
            editableValueHoldersExist = true;
            for (EditableValueHolder editableValueHolder : editableValueHolders) {
                if (editableValueHolder.isValid()) {
                    if (editableValueHolder.isRequired()) {
                        UIInput uiInput;
                        if (editableValueHolder.isLocalValueSet()) {
                            editableValueHoldersValid = true;
                            continue;
                        }
                        if (!(editableValueHolder instanceof UIInput) || UIInput.isEmpty((Object)(uiInput = (UIInput)editableValueHolder).getValue())) continue;
                        editableValueHoldersValid = true;
                        continue;
                    }
                    editableValueHoldersValid = true;
                    continue;
                }
                editableValueHoldersValid = false;
                severity = FacesMessage.SEVERITY_FATAL;
                break;
            }
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (severity == null) {
            severity = this.getHighestMessageSeverityRecurse(facesContext, (UIComponent)this, null);
        }
        if (severity == null) {
            PartialViewContext partialViewContext = facesContext.getPartialViewContext();
            if (editableValueHoldersExist && editableValueHoldersValid && partialViewContext.isAjaxRequest()) {
                controlGroupCssClass = controlGroupCssClass + " " + HAS_SUCCESS;
            }
        } else if (severity == FacesMessage.SEVERITY_FATAL || severity == FacesMessage.SEVERITY_ERROR) {
            controlGroupCssClass = controlGroupCssClass + " " + HAS_ERROR;
        } else if (severity == FacesMessage.SEVERITY_WARN) {
            controlGroupCssClass = controlGroupCssClass + " " + HAS_WARNING;
        } else if (severity == FacesMessage.SEVERITY_INFO) {
            // empty if block
        }
        if (this.hasSelectBooleanCheckboxChild()) {
            controlGroupCssClass = controlGroupCssClass + " checkbox";
        }
        String styleClass = (String)this.getStateHelper().eval((Serializable)HtmlPanelGroup.PropertyKeys.styleClass, null);
        return ComponentUtil.concatCssClasses((String[])new String[]{styleClass, "alloy-field", controlGroupCssClass});
    }

    private List<EditableValueHolder> getEditableValueHoldersRecurse(UIComponent uiComponent) {
        List<Object> editableValueHolders = null;
        if (uiComponent instanceof EditableValueHolder) {
            editableValueHolders = new ArrayList<EditableValueHolder>();
            editableValueHolders.add((EditableValueHolder)uiComponent);
        } else if (uiComponent instanceof UIMessage) {
            UIComponent forComponent;
            UIMessage uiMessage = (UIMessage)uiComponent;
            String forId = uiMessage.getFor();
            if (forId != null && (forComponent = uiComponent.findComponent(forId)) != null && forComponent instanceof EditableValueHolder) {
                editableValueHolders = new ArrayList();
                editableValueHolders.add((EditableValueHolder)((Object)((EditableValueHolder)forComponent)));
            }
        } else {
            List children = uiComponent.getChildren();
            for (UIComponent child : children) {
                List<EditableValueHolder> childEditableValueHolders = this.getEditableValueHoldersRecurse(child);
                if (childEditableValueHolders == null) continue;
                if (editableValueHolders == null) {
                    editableValueHolders = childEditableValueHolders;
                    continue;
                }
                editableValueHolders.addAll(childEditableValueHolders);
            }
        }
        return editableValueHolders;
    }

    private FacesMessage.Severity getHighestMessageSeverityRecurse(FacesContext facesContext, UIComponent uiComponent, FacesMessage.Severity severity) {
        List children = uiComponent.getChildren();
        if (children != null) {
            for (UIComponent child : children) {
                Iterator messages = facesContext.getMessages(child.getClientId());
                while (messages.hasNext()) {
                    FacesMessage facesMessage = (FacesMessage)messages.next();
                    FacesMessage.Severity currentSeverity = facesMessage.getSeverity();
                    if (currentSeverity == FacesMessage.SEVERITY_ERROR || currentSeverity == FacesMessage.SEVERITY_FATAL) {
                        severity = FacesMessage.SEVERITY_FATAL;
                        break;
                    }
                    if (severity != null && severity.getOrdinal() >= currentSeverity.getOrdinal()) continue;
                    severity = currentSeverity;
                }
                if (severity != null && severity == FacesMessage.SEVERITY_FATAL) break;
                severity = this.getHighestMessageSeverityRecurse(facesContext, child, severity);
            }
        }
        return severity;
    }

    private boolean hasSelectBooleanCheckboxChild() {
        boolean hasSelectBooleanCheckboxChild = this.hasSelectBooleanCheckboxChild((UIComponent)this);
        if (!hasSelectBooleanCheckboxChild) {
            Map facets = this.getFacets();
            Set entrySet = facets.entrySet();
            for (Map.Entry facetEntry : entrySet) {
                UIComponent uiComponent = (UIComponent)facetEntry.getValue();
                if (uiComponent instanceof SelectBooleanCheckbox) {
                    hasSelectBooleanCheckboxChild = true;
                    break;
                }
                if (uiComponent.getChildCount() <= 0) continue;
                hasSelectBooleanCheckboxChild = this.hasSelectBooleanCheckboxChild(uiComponent);
                break;
            }
        }
        return hasSelectBooleanCheckboxChild;
    }

    private boolean hasSelectBooleanCheckboxChild(UIComponent uiComponent) {
        boolean hasSelectBooleanCheckboxChild = false;
        List children = uiComponent.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof SelectBooleanCheckbox)) continue;
            hasSelectBooleanCheckboxChild = true;
            break;
        }
        return hasSelectBooleanCheckboxChild;
    }
}

