/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.datatable.internal;

import com.liferay.faces.alloy.component.column.Column;
import com.liferay.faces.alloy.component.commandlink.CommandLink;
import com.liferay.faces.alloy.component.datatable.DataTable;
import com.liferay.faces.alloy.component.datatable.internal.ColumnSortTimeComparator;
import com.liferay.faces.alloy.component.datatable.internal.DataTableInfo;
import com.liferay.faces.alloy.component.datatable.internal.DataTableRendererBase;
import com.liferay.faces.alloy.component.datatable.internal.ItemCycler;
import com.liferay.faces.alloy.component.outputtext.OutputText;
import com.liferay.faces.alloy.render.internal.EscapedClientId;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.SortCriterion;
import com.liferay.faces.util.model.Sortable;
import com.liferay.faces.util.render.JavaScriptFragment;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.html.HtmlColumn;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Data", rendererType="com.liferay.faces.alloy.component.datatable.DataTableRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy", name="alloy.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class DataTableRenderer
extends DataTableRendererBase {
    private static final Logger logger = LoggerFactory.getLogger(DataTableRenderer.class);

    public void decodeClientState(FacesContext facesContext, UIComponent uiComponent) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        DataTable dataTable = (DataTable)uiComponent;
        String dataTableClientId = dataTable.getClientId(facesContext);
        this.decodeSortCriteria(facesContext, requestParameterMap, dataTable, dataTableClientId);
        this.decodeRowSelection(requestParameterMap, dataTable, dataTableClientId);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataTable dataTable = (DataTable)uiComponent;
        DataTableInfo dataTableInfo = new DataTableInfo(dataTable);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        int totalRenderedColumns = dataTableInfo.getTotalRenderedColumns();
        if (totalRenderedColumns == 0) {
            responseWriter.startElement("tbody", (UIComponent)dataTable);
            responseWriter.endElement("tbody");
        } else {
            int rows = dataTable.getRows();
            int rowIndex = dataTable.getFirst() - 1;
            int totalRowsEncoded = 0;
            int[] bodyRows = dataTable.toIntArray(dataTable.getBodyrows());
            boolean wroteTBody = false;
            if (bodyRows == null) {
                responseWriter.startElement("tbody", (UIComponent)dataTable);
                wroteTBody = true;
            }
            if (rows >= 0) {
                ItemCycler rowClasses = new ItemCycler(dataTable.getRowClasses());
                ItemCycler columnClasses = new ItemCycler(dataTable.getColumnClasses());
                while (totalRowsEncoded < rows || rows == 0) {
                    dataTable.setRowIndex(++rowIndex);
                    columnClasses.reset();
                    if (!dataTable.isRowAvailable()) break;
                    if (bodyRows != null) {
                        for (int bodyRow : bodyRows) {
                            if (bodyRow != rowIndex) continue;
                            if (wroteTBody) {
                                responseWriter.endElement("tbody");
                            }
                            responseWriter.startElement("tbody", (UIComponent)dataTable);
                            wroteTBody = true;
                            break;
                        }
                    }
                    this.encodeRow(facesContext, responseWriter, dataTable, rowIndex, rowClasses, columnClasses);
                    ++totalRowsEncoded;
                }
            }
            if (totalRowsEncoded == 0) {
                String selectionMode = dataTable.getSelectionMode();
                if ("checkbox".equals(selectionMode)) {
                    ++totalRenderedColumns;
                }
                this.encodeEmptyTableRow(responseWriter, dataTable, totalRenderedColumns);
            }
            responseWriter.endElement("tbody");
        }
    }

    public void encodeClientState(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uiComponent) throws IOException {
        DataTable dataTable = (DataTable)uiComponent;
        dataTable.setRowIndex(-1);
        String hiddenFieldName = dataTable.getClientId(facesContext).concat("_selectedRowIndexes");
        responseWriter.startElement("input", (UIComponent)dataTable);
        responseWriter.writeAttribute("id", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("name", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("value", (Object)dataTable.getSelectedRowIndexes(), null);
        responseWriter.endElement("input");
    }

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataTable dataTable = (DataTable)uiComponent;
        String selectionMode = dataTable.getSelectionMode();
        if ("checkbox".equals(selectionMode) || "radio".equals(selectionMode)) {
            String dataTableClientId = dataTable.getClientId(facesContext);
            EscapedClientId escapedDataTableClientId = new EscapedClientId(dataTableClientId);
            String hiddenFieldClientId = dataTableClientId.concat("_selectedRowIndexes");
            EscapedClientId escapedHiddenFieldClientId = new EscapedClientId(hiddenFieldClientId);
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            JavaScriptFragment rowSelectClientBehaviorScript = this.getRowEventClientBehaviorScript(facesContext, dataTable, dataTableClientId, "rowSelect", "rowIndex");
            JavaScriptFragment rowSelectRangeClientBehaviorScript = this.getRowEventClientBehaviorScript(facesContext, dataTable, dataTableClientId, "rowSelectRange", "rowIndexRange");
            JavaScriptFragment rowDeselectClientBehaviorScript = this.getRowEventClientBehaviorScript(facesContext, dataTable, dataTableClientId, "rowDeselect", "rowIndex");
            JavaScriptFragment rowDeselectRangeClientBehaviorScript = this.getRowEventClientBehaviorScript(facesContext, dataTable, dataTableClientId, "rowDeselectRange", "rowIndexRange");
            if ("checkbox".equals(selectionMode)) {
                String selectAllCheckboxClientId = dataTableClientId.concat("_selectAll");
                EscapedClientId escapedSelectAllCheckboxClientId = new EscapedClientId(selectAllCheckboxClientId);
                this.encodeFunctionCall(responseWriter, "LFAI.initDataTableSelectAllCheckbox", new Object[]{Character.valueOf('A'), escapedDataTableClientId, escapedSelectAllCheckboxClientId, rowSelectRangeClientBehaviorScript, rowDeselectRangeClientBehaviorScript});
                this.encodeFunctionCall(responseWriter, "LFAI.initDataTableCheckboxSelection", new Object[]{Character.valueOf('A'), escapedDataTableClientId, escapedHiddenFieldClientId, rowSelectClientBehaviorScript, rowDeselectClientBehaviorScript});
            } else if ("radio".equals(selectionMode)) {
                this.encodeFunctionCall(responseWriter, "LFAI.initDataTableRadioSelection", new Object[]{Character.valueOf('A'), escapedDataTableClientId, escapedHiddenFieldClientId, rowSelectClientBehaviorScript, rowDeselectClientBehaviorScript});
            }
        }
    }

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataTable dataTable = (DataTable)uiComponent;
        Map dataTableAttributes = dataTable.getAttributes();
        Integer oldRows = (Integer)dataTableAttributes.remove("oldRows");
        if (oldRows != null && oldRows.intValue() != dataTable.getRows()) {
            dataTable.setFirst(0);
        }
        DataTableInfo dataTableInfo = new DataTableInfo(dataTable);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("table", (UIComponent)dataTable);
        responseWriter.writeAttribute("id", (Object)dataTable.getClientId(facesContext), "id");
        RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)dataTable, (String[])new String[0]);
        this.encodeCaptionFacet(facesContext, responseWriter, dataTable);
        this.encodeColGroupsFacet(facesContext, dataTable);
        this.encodeHeader(facesContext, responseWriter, dataTable, dataTableInfo);
        this.encodeFooter(facesContext, responseWriter, dataTable, dataTableInfo);
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("table");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void decodeRowSelection(Map<String, String> requestParameterMap, DataTable dataTable, String dataTableClientId) {
        String hiddenFieldName = dataTableClientId + "_selectedRowIndexes";
        String selectedRowIndexes = requestParameterMap.get(hiddenFieldName);
        if (selectedRowIndexes != null) {
            dataTable.setSelectedRowIndexes(selectedRowIndexes);
        }
    }

    protected void decodeSortCriteria(FacesContext facesContext, Map<String, String> requestParameterMap, DataTable dataTable, String dataTableClientId) {
        String sortColumnClientIdParamName;
        String sortColumnClientId;
        Object dataTableValue = dataTable.getValue();
        if (dataTableValue != null && dataTableValue instanceof Sortable && (sortColumnClientId = requestParameterMap.get(sortColumnClientIdParamName = dataTableClientId.concat("_sortColumnClientId"))) != null) {
            String alloyColumnSortOrder;
            ArrayList<Column> alloySortColumns = new ArrayList<Column>();
            String eventMetaKeyParamName = dataTableClientId.concat("_eventMetaKey");
            boolean eventMetaKey = BooleanHelper.toBoolean((String)requestParameterMap.get(eventMetaKeyParamName));
            boolean multiColumnSort = dataTable.isMultiColumnSort();
            List children = dataTable.getChildren();
            for (Object child : children) {
                if (!(child instanceof Column)) continue;
                Column alloyColumn = (Column)((Object)child);
                String alloyColumndId = alloyColumn.getClientId(facesContext);
                alloyColumnSortOrder = alloyColumn.getSortOrder();
                Map alloyColumnAttributes = alloyColumn.getAttributes();
                if (alloyColumndId.equals(sortColumnClientId)) {
                    SortCriterion.Order sortCriterionOrder = "ASCENDING".equals(alloyColumnSortOrder) ? SortCriterion.Order.DESCENDING : SortCriterion.Order.ASCENDING;
                    alloyColumn.setSortOrder(sortCriterionOrder.toString());
                    alloyColumnAttributes.put("sortTime", System.currentTimeMillis());
                    alloySortColumns.add(alloyColumn);
                    continue;
                }
                if (multiColumnSort && eventMetaKey) {
                    if (alloyColumnSortOrder == null) continue;
                    alloySortColumns.add(alloyColumn);
                    continue;
                }
                alloyColumn.setSortOrder(null);
                alloyColumnAttributes.remove("sortTime");
            }
            Collections.sort(alloySortColumns, new ColumnSortTimeComparator());
            ArrayList<SortCriterion> sortCriteria = new ArrayList<SortCriterion>();
            for (Column alloyColumn : alloySortColumns) {
                String alloyColumnFieldName = this.getAlloyColumnFieldName(alloyColumn);
                alloyColumnSortOrder = alloyColumn.getSortOrder();
                SortCriterion.Order sortCriterionOrder = "ASCENDING".equals(alloyColumnSortOrder) ? SortCriterion.Order.ASCENDING : SortCriterion.Order.DESCENDING;
                SortCriterion sortCriterion = new SortCriterion(alloyColumnFieldName, sortCriterionOrder);
                sortCriteria.add(sortCriterion);
            }
            if (logger.isDebugEnabled()) {
                for (SortCriterion sortCriterion : sortCriteria) {
                    logger.debug("sortCriterion columnId=[{0}], order=[{1}]", new Object[]{sortCriterion.getColumnId(), sortCriterion.getOrder()});
                }
            }
            Sortable sortable = (Sortable)dataTableValue;
            sortable.setSortCriteria(sortCriteria);
        }
    }

    protected void encodeCaptionFacet(FacesContext facesContext, ResponseWriter responseWriter, DataTable dataTable) throws IOException {
        UIComponent captionFacet = dataTable.getFacet("caption");
        if (captionFacet != null) {
            String captionStyle;
            responseWriter.startElement("caption", null);
            String captionClass = dataTable.getCaptionClass();
            if (captionClass != null) {
                responseWriter.writeAttribute("class", (Object)captionClass, "captionClass");
            }
            if ((captionStyle = dataTable.getCaptionStyle()) != null) {
                responseWriter.writeAttribute("style", (Object)captionStyle, "captionStyle");
            }
            this.encodeRecurse(facesContext, captionFacet);
            responseWriter.endElement("caption");
        }
    }

    protected void encodeColGroupsFacet(FacesContext facesContext, DataTable dataTable) throws IOException {
        UIComponent colGroupsFacet = dataTable.getFacet("colGroups");
        if (colGroupsFacet != null) {
            this.encodeRecurse(facesContext, colGroupsFacet);
        }
    }

    protected void encodeEmptyTableRow(ResponseWriter responseWriter, DataTable dataTable, int totalColumns) throws IOException {
        responseWriter.startElement("tr", (UIComponent)dataTable);
        for (int i = 0; i < totalColumns; ++i) {
            responseWriter.startElement("td", (UIComponent)dataTable);
            responseWriter.endElement("td");
        }
        responseWriter.endElement("tr");
    }

    protected void encodeFooter(FacesContext facesContext, ResponseWriter responseWriter, DataTable dataTable, DataTableInfo dataTableInfo) throws IOException {
        int totalRenderedColumns;
        UIComponent footerFacet = dataTable.getFacet("footer");
        if (footerFacet != null || dataTableInfo.isFooterFacetPresentInColumn()) {
            responseWriter.startElement("tfoot", null);
        }
        String footerClass = dataTable.getFooterClass();
        if (dataTableInfo.isFooterFacetPresentInColumn()) {
            responseWriter.startElement("tr", null);
            List children = dataTable.getChildren();
            for (UIComponent child : children) {
                HtmlColumn htmlColumn;
                if (!(child instanceof HtmlColumn) || !(htmlColumn = (HtmlColumn)child).isRendered()) continue;
                responseWriter.startElement("td", null);
                String columnFooterClass = htmlColumn.getFooterClass();
                if (columnFooterClass != null) {
                    responseWriter.writeAttribute("class", (Object)columnFooterClass, "columnFooterClass");
                } else if (footerClass != null) {
                    responseWriter.writeAttribute("class", (Object)footerClass, "footerClass");
                }
                UIComponent columnFooterFacet = htmlColumn.getFacet("footer");
                if (columnFooterFacet != null) {
                    this.encodeRecurse(facesContext, columnFooterFacet);
                }
                responseWriter.endElement("td");
            }
            responseWriter.endElement("tr");
        }
        int colspan = totalRenderedColumns = dataTableInfo.getTotalRenderedColumns();
        String selectionMode = dataTable.getSelectionMode();
        if ("checkbox".equals(selectionMode) || "radio".equals(selectionMode)) {
            ++colspan;
        }
        if (footerFacet != null) {
            responseWriter.startElement("tr", null);
            responseWriter.startElement("td", null);
            if (footerClass == null) {
                responseWriter.writeAttribute("class", (Object)"facet", "footerClass");
            } else {
                responseWriter.writeAttribute("class", (Object)footerClass.concat(" facet"), "footerClass");
            }
            if (totalRenderedColumns > 1) {
                responseWriter.writeAttribute("colspan", (Object)colspan, null);
            }
            this.encodeRecurse(facesContext, footerFacet);
            responseWriter.endElement("td");
            responseWriter.endElement("tr");
        }
        if (footerFacet != null || dataTableInfo.isFooterFacetPresentInColumn()) {
            responseWriter.endElement("tfoot");
        }
    }

    protected void encodeHeader(FacesContext facesContext, ResponseWriter responseWriter, DataTable dataTable, DataTableInfo dataTableInfo) throws IOException {
        int totalRenderedColumns;
        UIComponent headerFacet = dataTable.getFacet("header");
        if (headerFacet != null || dataTableInfo.isHeaderFacetOrTextPresentInColumn()) {
            responseWriter.startElement("thead", null);
            responseWriter.writeAttribute("class", (Object)"table-columns", null);
        }
        int colspan = totalRenderedColumns = dataTableInfo.getTotalRenderedColumns();
        String selectionMode = dataTable.getSelectionMode();
        if ("checkbox".equals(selectionMode) || "radio".equals(selectionMode)) {
            ++colspan;
        }
        String headerClass = dataTable.getHeaderClass();
        if (headerFacet != null) {
            responseWriter.startElement("tr", null);
            responseWriter.startElement("th", null);
            if (headerClass == null) {
                responseWriter.writeAttribute("class", (Object)"facet", "headerClass");
            } else {
                responseWriter.writeAttribute("class", (Object)headerClass.concat(" facet"), "headerClass");
            }
            if (totalRenderedColumns > 1) {
                responseWriter.writeAttribute("colspan", (Object)colspan, null);
            }
            responseWriter.writeAttribute("scope", (Object)"colgroup", null);
            this.encodeRecurse(facesContext, headerFacet);
            responseWriter.endElement("th");
            responseWriter.endElement("tr");
        }
        if (dataTableInfo.isHeaderFacetOrTextPresentInColumn()) {
            responseWriter.startElement("tr", null);
            List children = dataTable.getChildren();
            if ("checkbox".equals(selectionMode) || "radio".equals(selectionMode)) {
                responseWriter.startElement("th", null);
                if ("checkbox".equals(selectionMode)) {
                    responseWriter.startElement("input", null);
                    String checkboxClientId = dataTable.getClientId(facesContext).concat("_selectAll");
                    responseWriter.writeAttribute("id", (Object)checkboxClientId, null);
                    responseWriter.writeAttribute("type", (Object)"checkbox", null);
                    responseWriter.endElement("input");
                }
                responseWriter.endElement("th");
            }
            for (UIComponent child : children) {
                UIColumn uiColumn;
                if (!(child instanceof UIColumn) || !(uiColumn = (UIColumn)child).isRendered()) continue;
                responseWriter.startElement("th", null);
                if (child instanceof HtmlColumn) {
                    UIComponent columnHeaderFacet;
                    String headerText;
                    HtmlColumn htmlColumn = (HtmlColumn)child;
                    String columnHeaderClass = htmlColumn.getHeaderClass();
                    String sortClass = null;
                    Column alloyColumn = null;
                    if (child instanceof Column) {
                        alloyColumn = (Column)htmlColumn;
                        String sortOrder = alloyColumn.getSortOrder();
                        if ("ASCENDING".equals(sortOrder)) {
                            sortClass = " table-sortable-column table-sorted";
                        } else if ("DESCENDING".equals(sortOrder)) {
                            sortClass = " table-sortable-column table-sorted table-sorted-desc";
                        }
                    }
                    if (columnHeaderClass != null) {
                        if (sortClass != null) {
                            columnHeaderClass = columnHeaderClass.concat(sortClass);
                        }
                        responseWriter.writeAttribute("class", (Object)columnHeaderClass, "columnHeaderClass");
                    } else if (headerClass != null) {
                        if (sortClass != null) {
                            headerClass = headerClass.concat(sortClass);
                        }
                        responseWriter.writeAttribute("class", (Object)headerClass, "headerClass");
                    } else if (sortClass != null) {
                        responseWriter.writeAttribute("class", sortClass, null);
                    }
                    responseWriter.writeAttribute("scope", (Object)"col", null);
                    if (alloyColumn != null && (headerText = alloyColumn.getHeaderText()) != null) {
                        this.encodeHeaderText(facesContext, responseWriter, dataTable, alloyColumn, headerText);
                    }
                    if ((columnHeaderFacet = htmlColumn.getFacet("header")) != null) {
                        this.encodeRecurse(facesContext, columnHeaderFacet);
                    }
                }
                responseWriter.endElement("th");
            }
            responseWriter.endElement("tr");
        }
        if (headerFacet != null || dataTableInfo.isHeaderFacetOrTextPresentInColumn()) {
            responseWriter.endElement("thead");
        }
    }

    protected void encodeHeaderText(FacesContext facesContext, ResponseWriter responseWriter, DataTable dataTable, Column column, String headerText) throws IOException {
        ValueExpression sortByValueExpression = column.getValueExpression("sortBy");
        if (sortByValueExpression == null) {
            responseWriter.writeText((Object)headerText, (UIComponent)column, null);
        } else {
            responseWriter.startElement("div", (UIComponent)dataTable);
            responseWriter.writeAttribute("class", (Object)"table-sort-liner", null);
            String dataTableClientId = dataTable.getClientId(facesContext);
            String clientBehaviorScript = this.getColumnClientBehaviorScript(facesContext, dataTable, column, dataTableClientId);
            if (clientBehaviorScript != null) {
                responseWriter.writeAttribute("onclick", (Object)clientBehaviorScript, null);
                responseWriter.startElement("a", null);
                responseWriter.writeText((Object)headerText, null);
                responseWriter.startElement("span", (UIComponent)dataTable);
                responseWriter.writeAttribute("class", (Object)"table-sort-indicator", null);
                responseWriter.endElement("span");
                responseWriter.endElement("a");
            } else {
                Application application = facesContext.getApplication();
                CommandLink commandLink = (CommandLink)application.createComponent(facesContext, "com.liferay.faces.alloy.component.commandlink.CommandLink", "com.liferay.faces.alloy.component.commandlink.CommandLinkRenderer");
                commandLink.setAjax(column.isAjax());
                OutputText outputText1 = (OutputText)application.createComponent(facesContext, "com.liferay.faces.alloy.component.outputtext.OutputText", "com.liferay.faces.alloy.component.outputtext.OutputTextRenderer");
                outputText1.setValue(headerText);
                OutputText outputText2 = (OutputText)application.createComponent(facesContext, "com.liferay.faces.alloy.component.outputtext.OutputText", "com.liferay.faces.alloy.component.outputtext.OutputTextRenderer");
                outputText2.setStyleClass("table-sort-indicator");
                List paginatorChildren = column.getChildren();
                paginatorChildren.add(commandLink);
                UIParameter uiParameter = new UIParameter();
                String sortColumnClientIdParamName = dataTableClientId.concat("_sortColumnClientId");
                uiParameter.setName(sortColumnClientIdParamName);
                uiParameter.setValue((Object)column.getClientId(facesContext));
                List commandLinkChildren = commandLink.getChildren();
                commandLinkChildren.add(uiParameter);
                commandLinkChildren.add(outputText1);
                commandLinkChildren.add(outputText2);
                outputText2.setEscape(false);
                commandLink.encodeAll(facesContext);
                commandLinkChildren.remove((Object)outputText2);
                commandLinkChildren.remove((Object)outputText1);
                commandLinkChildren.remove(uiParameter);
                paginatorChildren.remove((Object)commandLink);
            }
            responseWriter.endElement("div");
        }
    }

    protected void encodeRecurse(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (uiComponent.isRendered()) {
            uiComponent.encodeBegin(facesContext);
            if (uiComponent.getRendersChildren()) {
                uiComponent.encodeChildren(facesContext);
            } else {
                List children = uiComponent.getChildren();
                for (UIComponent child : children) {
                    this.encodeRecurse(facesContext, child);
                }
            }
            uiComponent.encodeEnd(facesContext);
        }
    }

    protected void encodeRow(FacesContext facesContext, ResponseWriter responseWriter, DataTable dataTable, int rowIndex, ItemCycler rowClasses, ItemCycler columnClasses) throws IOException {
        String selectionMode;
        responseWriter.startElement("tr", (UIComponent)dataTable);
        String rowClass = rowClasses.getNextItem();
        if (rowClass != null) {
            responseWriter.writeAttribute("class", (Object)rowClass, "rowClasses");
        }
        if ("checkbox".equals(selectionMode = dataTable.getSelectionMode()) || "radio".equals(selectionMode)) {
            String rowIndexAsString;
            HashSet<Object> selectedRowIndexSet = new HashSet();
            String selectedRowIndexes = dataTable.getSelectedRowIndexes();
            if (selectedRowIndexes != null) {
                String[] selectedRowIndexArray = selectedRowIndexes.split(",");
                selectedRowIndexSet = new HashSet<String>(Arrays.asList(selectedRowIndexArray));
            }
            if (selectedRowIndexSet.contains(rowIndexAsString = Integer.toString(rowIndex))) {
                responseWriter.writeAttribute("class", (Object)"info", null);
            }
            responseWriter.startElement("td", null);
            responseWriter.startElement("input", null);
            String checkboxClientId = dataTable.getClientId(facesContext);
            responseWriter.writeAttribute("id", (Object)checkboxClientId, null);
            responseWriter.writeAttribute("type", (Object)selectionMode, null);
            if (selectedRowIndexSet.contains(rowIndexAsString)) {
                responseWriter.writeAttribute("checked", (Object)"checked", null);
            }
            responseWriter.endElement("input");
            responseWriter.endElement("td");
        }
        List children = dataTable.getChildren();
        for (UIComponent child : children) {
            HtmlColumn htmlColumn;
            if (!(child instanceof HtmlColumn) || !(htmlColumn = (HtmlColumn)child).isRendered()) continue;
            if (htmlColumn.isRowHeader()) {
                responseWriter.startElement("th", (UIComponent)htmlColumn);
                responseWriter.writeAttribute("scope", (Object)"row", null);
            } else {
                responseWriter.startElement("td", (UIComponent)htmlColumn);
            }
            String columnClass = columnClasses.getNextItem();
            if (columnClass != null) {
                responseWriter.writeAttribute("class", (Object)columnClass, "columnClasses");
            }
            List htmlColumnChildren = htmlColumn.getChildren();
            for (UIComponent htmlColumnChild : htmlColumnChildren) {
                this.encodeRecurse(facesContext, htmlColumnChild);
            }
            if (htmlColumn.isRowHeader()) {
                responseWriter.endElement("th");
                continue;
            }
            responseWriter.endElement("td");
        }
        responseWriter.endElement("tr");
    }

    protected String getAlloyColumnFieldName(Column column) {
        String expressionString;
        ValueExpression sortByValueExpression;
        String columnFieldName = column.getId();
        if ((columnFieldName == null || columnFieldName.startsWith("j_id")) && (sortByValueExpression = column.getValueExpression("sortBy")) != null && (expressionString = sortByValueExpression.getExpressionString()) != null) {
            expressionString = expressionString.substring(2, expressionString.length() - 1);
            columnFieldName = expressionString.substring(expressionString.lastIndexOf(".") + 1);
        }
        return columnFieldName;
    }

    protected String getColumnClientBehaviorScript(FacesContext facesContext, DataTable dataTable, Column column, String clientId) {
        String defaultEventName;
        String clientBehaviorScript = null;
        Map clientBehaviorMap = column.getClientBehaviors();
        List clientBehaviorsForEvent = (List)clientBehaviorMap.get(defaultEventName = column.getDefaultEventName());
        if (clientBehaviorsForEvent != null) {
            for (ClientBehavior clientBehavior : clientBehaviorsForEvent) {
                ArrayList<ClientBehaviorContext.Parameter> parameters = new ArrayList<ClientBehaviorContext.Parameter>();
                String sortColumnClientIdParamName = clientId.concat("_sortColumnClientId");
                String sortColumnClientId = column.getClientId(facesContext);
                parameters.add(new ClientBehaviorContext.Parameter(sortColumnClientIdParamName, (Object)sortColumnClientId));
                String eventMetaKeyParamName = clientId.concat("_eventMetaKey");
                parameters.add(new ClientBehaviorContext.Parameter(eventMetaKeyParamName, (Object)"event.metaKey"));
                ClientBehaviorContext clientBehaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)dataTable, (String)defaultEventName, (String)clientId, parameters);
                clientBehaviorScript = clientBehavior.getScript(clientBehaviorContext);
            }
        }
        if (clientBehaviorScript != null) {
            clientBehaviorScript = clientBehaviorScript.replaceFirst("'event.metaKey'", "event.metaKey");
        }
        return clientBehaviorScript;
    }

    protected JavaScriptFragment getRowEventClientBehaviorScript(FacesContext facesContext, DataTable dataTable, String dataTableClientId, String eventName, String parameterName) {
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append("function(");
        scriptBuilder.append(parameterName);
        scriptBuilder.append(", event){");
        Map clientBehaviorMap = dataTable.getClientBehaviors();
        List clientBehaviorsForEvent = (List)clientBehaviorMap.get(eventName);
        if (clientBehaviorsForEvent != null) {
            for (ClientBehavior clientBehavior : clientBehaviorsForEvent) {
                ArrayList<ClientBehaviorContext.Parameter> parameters = new ArrayList<ClientBehaviorContext.Parameter>();
                String eventMetaKeyParamName = dataTableClientId.concat("_").concat(parameterName);
                parameters.add(new ClientBehaviorContext.Parameter(eventMetaKeyParamName, (Object)parameterName));
                ClientBehaviorContext clientBehaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)dataTable, (String)eventName, (String)dataTableClientId, parameters);
                String script = clientBehavior.getScript(clientBehaviorContext);
                if (script != null) {
                    String quotedParamName = "'".concat(parameterName).concat("'");
                    script = script.replaceFirst(quotedParamName, parameterName);
                }
                scriptBuilder.append(script);
            }
        }
        scriptBuilder.append("}");
        return new JavaScriptFragment(scriptBuilder.toString());
    }
}

