/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.column.internal;

import com.liferay.faces.alloy.component.column.Column;
import com.liferay.faces.alloy.component.column.internal.ColumnRendererBase;
import com.liferay.faces.alloy.component.datatable.DataTable;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Column", rendererType="com.liferay.faces.alloy.component.column.ColumnRenderer")
@ListenerFor(systemEventClass=PostAddToViewEvent.class, sourceClass=Column.class)
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css")})
public class ColumnRenderer
extends ColumnRendererBase
implements ComponentSystemEventListener {
    protected static Integer getColumnUnitSize(Integer width) {
        return (int)Math.round(12.0 * ((double)width.intValue() / 100.0));
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        UIComponent parent = uiComponent.getParent();
        if (!(parent instanceof HtmlDataTable) && !(parent instanceof HtmlPanelGrid)) {
            responseWriter.startElement("div", uiComponent);
            String clientId = uiComponent.getClientId(facesContext);
            responseWriter.writeAttribute("id", (Object)clientId, null);
            Column column = (Column)uiComponent;
            StringBuilder classNames = new StringBuilder();
            String size = column.getSize();
            size = this.getColumnCSSClassSize(size);
            Integer span = column.getSpan();
            if (span != null && (span < 1 || span > 12)) {
                throw new IOException("span number must be between 1 and 12");
            }
            Integer width = column.getWidth();
            if (width != null) {
                if (width < 1 || width > 100) {
                    throw new IOException("width must be between 1 and 100");
                }
                span = ColumnRenderer.getColumnUnitSize(width);
            }
            classNames.append("col-");
            classNames.append(size);
            classNames.append("-");
            classNames.append(span);
            Integer offset = column.getOffset();
            if (offset != null && (offset < 1 || offset > 12)) {
                throw new IOException("offset must be between 1 and 12");
            }
            Integer offsetWidth = column.getOffsetWidth();
            if (offsetWidth != null) {
                if (offsetWidth < 1 || offsetWidth > 100) {
                    throw new IOException("offsetWidth must be between 1 and 100");
                }
                offset = ColumnRenderer.getColumnUnitSize(offsetWidth);
            }
            if (offset != null) {
                classNames.append(" ");
                classNames.append("col-");
                classNames.append(size);
                classNames.append("-offset-");
                classNames.append(offset);
            }
            RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)column, (String[])new String[]{classNames.toString()});
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        UIComponent parent = uiComponent.getParent();
        if (!(parent instanceof HtmlDataTable) && !(parent instanceof HtmlPanelGrid)) {
            responseWriter.endElement("div");
        }
    }

    public void processEvent(ComponentSystemEvent componentSystemEvent) throws AbortProcessingException {
        Column column = (Column)componentSystemEvent.getComponent();
        UIComponent parent = column.getParent();
        if (parent instanceof DataTable && column.isAjax()) {
            RendererUtil.addDefaultAjaxBehavior((ClientBehaviorHolder)column, (String)column.getExecute(), (String)column.getProcess(), (String)"@parent", (String)column.getRender(), (String)column.getUpdate(), (String)"@parent");
        }
    }

    private String getColumnCSSClassSize(String size) throws IOException {
        if ("extra-small".equals(size) || "xs".equals(size)) {
            size = "xs";
        } else if ("small".equals(size) || "sm".equals(size)) {
            size = "sm";
        } else if ("medium".equals(size) || "md".equals(size)) {
            size = "md";
        } else if ("large".equals(size) || "lg".equals(size)) {
            size = "lg";
        } else {
            throw new IOException(size + " is not a valid value for size.");
        }
        return size;
    }
}

