/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.accordion.internal;

import com.liferay.faces.alloy.component.accordion.Accordion;
import com.liferay.faces.alloy.component.accordion.internal.AccordionRendererBase;
import com.liferay.faces.alloy.component.tab.Tab;
import com.liferay.faces.alloy.component.tab.internal.DataEncoderTabImpl;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.JavaScriptFragment;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Data", rendererType="com.liferay.faces.alloy.component.accordion.AccordionRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy", name="alloy.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class AccordionRenderer
extends AccordionRendererBase {
    private static final String ANIMATED = "animated";
    private static final String CONTAINER = "container";
    private static final String CONTENT_COLLAPSED_CLASSES = "content toggler-content toggler-content-collapsed";
    private static final String CONTENT_EXPANDED_CLASSES = "content toggler-content toggler-content-expanded";
    private static final String DOT_CONTENT = ".content";
    private static final String DOT_HEADER = ".header";
    private static final String HEADER_COLLAPSED_CLASSES = "header toggler-header toggler-header-collapsed";
    private static final String HEADER_EXPANDED_CLASSES = "header toggler-header toggler-header-expanded";
    private static final String EXPANDED = "expanded";
    private static final Logger logger = LoggerFactory.getLogger(AccordionRenderer.class);

    private static int getIntegerOrDefault(Integer i, int defaultValue) {
        if (i != null) {
            return i;
        }
        return defaultValue;
    }

    public void decodeClientState(FacesContext facesContext, UIComponent uiComponent) {
        Accordion accordion = (Accordion)uiComponent;
        String hiddenFieldName = accordion.getClientId(facesContext) + "selectedIndex";
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String selectedIndex = (String)requestParameterMap.get(hiddenFieldName);
        if (selectedIndex != null) {
            accordion.setSelectedIndex(IntegerHelper.toInteger((String)selectedIndex, (int)-1));
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Accordion accordion = (Accordion)uiComponent;
        Integer selectedIndex = accordion.getSelectedIndex();
        DataEncoderTabMarkupImpl dataEncoder = new DataEncoderTabMarkupImpl(selectedIndex);
        dataEncoder.encodeColumns(facesContext, accordion);
        accordion.setRowIndex(-1);
    }

    public void encodeClientState(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uiComponent) throws IOException {
        Accordion accordion = (Accordion)uiComponent;
        responseWriter.startElement("input", (UIComponent)accordion);
        String accordionClientId = accordion.getClientId(facesContext);
        String hiddenFieldName = accordionClientId + "selectedIndex";
        responseWriter.writeAttribute("id", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("name", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("value", (Object)accordion.getSelectedIndex(), null);
        responseWriter.endElement("input");
        responseWriter.startElement("input", (UIComponent)accordion);
        hiddenFieldName = accordionClientId + "collapsedTabIndex";
        responseWriter.writeAttribute("id", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("name", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.endElement("input");
    }

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Accordion accordion = (Accordion)uiComponent;
        String clientVarName = this.getClientVarName(facesContext, accordion);
        String clientKey = accordion.getClientKey();
        if (clientKey == null) {
            clientKey = clientVarName;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        this.encodeLiferayComponentVar(responseWriter, clientVarName, clientKey);
        Integer selectedIndex = accordion.getSelectedIndex();
        if (selectedIndex != null && selectedIndex > -1) {
            DataEncoderTabJavaScriptImpl dataEncoder = new DataEncoderTabJavaScriptImpl(selectedIndex, clientVarName);
            dataEncoder.encodeColumns(facesContext, accordion);
        }
        boolean multiple = accordion.isMultiple();
        String clientId = accordion.getClientId(facesContext);
        StringBuilder tabExpandedClientBehaviors = new StringBuilder();
        tabExpandedClientBehaviors.append("[");
        StringBuilder tabCollapsedClientBehaviors = new StringBuilder();
        tabCollapsedClientBehaviors.append("[");
        boolean firstTabExpandedClientBehavior = true;
        boolean firstTabCollapsedClientBehavior = true;
        Map clientBehaviorMap = accordion.getClientBehaviors();
        Collection<String> eventNames = accordion.getEventNames();
        for (String eventName : eventNames) {
            List clientBehaviorsForEvent = (List)clientBehaviorMap.get(eventName);
            if (clientBehaviorsForEvent == null) continue;
            for (ClientBehavior clientBehavior : clientBehaviorsForEvent) {
                ClientBehaviorContext clientBehaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)accordion, (String)eventName, (String)clientId, null);
                if ("tabExpand".equals(eventName)) {
                    if (!firstTabExpandedClientBehavior) {
                        tabExpandedClientBehaviors.append(",");
                    }
                    tabExpandedClientBehaviors.append("function(event){");
                    tabExpandedClientBehaviors.append(clientBehavior.getScript(clientBehaviorContext));
                    tabExpandedClientBehaviors.append("}");
                    firstTabExpandedClientBehavior = false;
                    continue;
                }
                if (!"tabCollapse".equals(eventName)) continue;
                if (!firstTabCollapsedClientBehavior) {
                    tabCollapsedClientBehaviors.append(",");
                }
                tabCollapsedClientBehaviors.append("function(event){");
                tabCollapsedClientBehaviors.append(clientBehavior.getScript(clientBehaviorContext));
                tabCollapsedClientBehaviors.append("}");
                firstTabCollapsedClientBehavior = false;
            }
        }
        tabExpandedClientBehaviors.append("]");
        tabCollapsedClientBehaviors.append("]");
        this.encodeFunctionCall(responseWriter, "LFAI.initAccordion", new Object[]{multiple, new JavaScriptFragment(clientVarName), clientId + "selectedIndex", clientId, new JavaScriptFragment(tabExpandedClientBehaviors.toString()), clientId + "collapsedTabIndex", new JavaScriptFragment(tabCollapsedClientBehaviors.toString())});
    }

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", uiComponent);
        responseWriter.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), "id");
        RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)((Styleable)uiComponent), (String[])new String[0]);
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, Accordion accordion, boolean first) throws IOException {
        this.encodeWidgetRender(responseWriter, first);
        first = false;
        this.encodeClientId(responseWriter, CONTAINER, accordion.getClientId(facesContext), first);
        this.encodeBoolean(responseWriter, ANIMATED, true, first);
        this.encodeBoolean(responseWriter, "closeAllOnExpand", true, first);
        this.encodeString(responseWriter, "content", DOT_CONTENT, first);
        this.encodeString(responseWriter, "header", DOT_HEADER, first);
        this.encodeBoolean(responseWriter, EXPANDED, false, first);
    }

    private static class DataEncoderTabMarkupImpl
    extends DataEncoderTabImpl {
        private final int selectedIndex;

        public DataEncoderTabMarkupImpl(Integer selectedIndex) {
            this.selectedIndex = AccordionRenderer.getIntegerOrDefault(selectedIndex, -1);
        }

        @Override
        protected void encodeColumn(FacesContext facesContext, UIData uiData, UIColumn currentUIColumn, int serverSideIndex) throws IOException {
            if (currentUIColumn instanceof Tab && currentUIColumn.isRendered()) {
                String tabContentClass;
                String tabHeaderClass;
                boolean selected;
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                Tab tab = (Tab)currentUIColumn;
                responseWriter.startElement("div", (UIComponent)tab);
                String headerClass = AccordionRenderer.HEADER_COLLAPSED_CLASSES;
                boolean bl = selected = serverSideIndex == this.selectedIndex;
                if (selected) {
                    headerClass = AccordionRenderer.HEADER_EXPANDED_CLASSES;
                }
                if ((tabHeaderClass = tab.getHeaderClass()) != null) {
                    headerClass = headerClass + " " + tabHeaderClass;
                }
                headerClass = headerClass + " serverSideIndex" + serverSideIndex;
                responseWriter.writeAttribute("class", (Object)headerClass, "styleClass");
                UIComponent headerFacet = tab.getFacet("header");
                if (headerFacet != null) {
                    headerFacet.encodeAll(facesContext);
                } else {
                    String headerText = tab.getHeaderText();
                    if (headerText != null) {
                        responseWriter.write(headerText);
                    }
                }
                responseWriter.endElement("div");
                responseWriter.startElement("div", (UIComponent)tab);
                String contentClass = AccordionRenderer.CONTENT_COLLAPSED_CLASSES;
                if (selected) {
                    contentClass = AccordionRenderer.CONTENT_EXPANDED_CLASSES;
                }
                if ((tabContentClass = tab.getContentClass()) != null) {
                    contentClass = contentClass + " " + tabContentClass;
                }
                responseWriter.writeAttribute("class", (Object)contentClass, "styleClass");
                tab.encodeAll(facesContext);
                responseWriter.endElement("div");
            }
        }
    }

    private static class DataEncoderTabJavaScriptImpl
    extends DataEncoderTabImpl {
        private final String clientVarName;
        private final int selectedIndex;
        int clientSideTabIndex = 0;

        public DataEncoderTabJavaScriptImpl(Integer selectedIndex, String clientVarName) {
            this.selectedIndex = AccordionRenderer.getIntegerOrDefault(selectedIndex, -1);
            this.clientVarName = clientVarName;
        }

        @Override
        protected void encodeColumn(FacesContext facesContext, UIData uiData, UIColumn currentUIColumn, int currentIndex) throws IOException {
            if (currentUIColumn instanceof Tab && currentUIColumn.isRendered()) {
                Tab childTab = (Tab)currentUIColumn;
                if (!childTab.isDisabled() && currentIndex == this.selectedIndex) {
                    ResponseWriter responseWriter = facesContext.getResponseWriter();
                    responseWriter.write(this.clientVarName);
                    responseWriter.write(".items[");
                    responseWriter.write(Integer.toString(this.clientSideTabIndex));
                    responseWriter.write("].expand();");
                }
                ++this.clientSideTabIndex;
            }
        }
    }
}

