/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.alloy.render.internal;

import java.io.Serializable;

import com.liferay.faces.util.client.ScriptsEncoder;
import com.liferay.faces.util.client.ScriptsEncoderFactory;


/**
 * @author  Kyle Stiemann
 */
public class ScriptsEncoderFactoryAlloyImpl extends ScriptsEncoderFactory implements Serializable {

	// serialVersionUID
	private static final long serialVersionUID = 2186017689814362487L;

	// Private Final Data Members
	private final ScriptsEncoder scriptsEncoder;
	private final ScriptsEncoderFactory wrappedScriptsEncoderFactory;

	public ScriptsEncoderFactoryAlloyImpl(ScriptsEncoderFactory scriptEncoderFactory) {

		ScriptsEncoder scriptsEncoder = scriptEncoderFactory.getScriptsEncoder();
		this.scriptsEncoder = new ScriptsEncoderAlloyImpl(scriptsEncoder);
		this.wrappedScriptsEncoderFactory = scriptEncoderFactory;
	}

	@Override
	public ScriptsEncoder getScriptsEncoder() {
		return scriptsEncoder;
	}

	@Override
	public ScriptsEncoderFactory getWrapped() {
		return wrappedScriptsEncoderFactory;
	}
}
