/**
 * Copyright (c) 2000-2019 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
package com.liferay.faces.alloy.component.outputscriptstylesheet.internal;

import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.render.Renderer;

import com.liferay.faces.util.render.DelegatingRendererBase;


/**
 * @author  Kyle Stiemann
 */
public abstract class OutputScriptStylesheetRendererBase extends DelegatingRendererBase
	implements ComponentSystemEventListener {

	@Override
	public void processEvent(ComponentSystemEvent componentSystemEvent) throws AbortProcessingException {

		FacesContext facesContext = FacesContext.getCurrentInstance();
		Renderer delegateRenderer = getDelegateRenderer(facesContext);

		if (delegateRenderer instanceof ComponentSystemEventListener) {
			ComponentSystemEventListener delegateComponentSystemEventListener = (ComponentSystemEventListener)
				delegateRenderer;
			delegateComponentSystemEventListener.processEvent(componentSystemEvent);
		}
	}
}
