/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.taghandler;

import com.liferay.faces.util.cache.Cache;
import com.liferay.faces.util.jsp.JspTagConfig;
import com.liferay.faces.util.lang.ThreadSafeAccessor;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

public class LoadConstants
extends TagHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoadConstants.class);
    private final String classType;
    private final ConstantCacheAccessor constantCacheAccessor;
    private final String var;

    public LoadConstants() throws Exception {
        super((TagConfig)new JspTagConfig());
        this.classType = null;
        this.constantCacheAccessor = null;
        this.var = null;
    }

    public LoadConstants(TagConfig config) throws Exception {
        super(config);
        TagAttribute typeAttr = this.getAttribute(PropertyKeys.classType.toString());
        if (typeAttr == null) {
            throw new NullPointerException("classType is required.");
        }
        this.classType = typeAttr.getValue();
        TagAttribute varAttr = this.getAttribute(PropertyKeys.var.toString());
        if (varAttr == null) {
            throw new NullPointerException("var is required.");
        }
        this.var = varAttr.getValue();
        TagAttribute cacheableAttr = this.getAttribute(PropertyKeys.cacheable.toString());
        this.constantCacheAccessor = cacheableAttr == null || Boolean.parseBoolean(cacheableAttr.getValue()) ? new ConstantCacheAccessor() : null;
    }

    public void apply(FaceletContext faceletContext, UIComponent parentUIComponent) throws IOException {
        Cache constantCache = null;
        if (this.constantCacheAccessor != null) {
            constantCache = (Cache)this.constantCacheAccessor.get(faceletContext);
        }
        if (constantCache != null && constantCache.containsKey((Object)this.classType)) {
            faceletContext.setAttribute(this.var, constantCache.getValue((Object)this.classType));
        } else {
            Map<String, Object> constantMap = new HashMap();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            try {
                Field[] fields;
                Class<?> clazz = Class.forName(this.classType, true, classLoader);
                for (Field field : fields = clazz.getFields()) {
                    int modifiers = field.getModifiers();
                    if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
                    String fieldName = field.getName();
                    if (!Modifier.isFinal(modifiers)) {
                        logger.warn("Loading non-final field: {0}. alloy:loadConstants is designed to load \"public static final\" fields. The behavior of alloy:loadConstants is undefined when loading non-final fields.", new Object[]{fieldName});
                    }
                    constantMap.put(fieldName, field.get(null));
                }
                constantMap = Collections.unmodifiableMap(constantMap);
                if (constantCache != null) {
                    constantMap = (Map)constantCache.putValueIfAbsent((Object)this.classType, constantMap);
                }
                faceletContext.setAttribute(this.var, constantMap);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Referenced class cannot be found.", e);
            }
            catch (IllegalAccessException e) {
                logger.error((Throwable)e);
            }
        }
    }

    private static final class ConstantCacheAccessor
    extends ThreadSafeAccessor<Cache<String, Map<String, Object>>, FaceletContext> {
        private ConstantCacheAccessor() {
        }

        protected Cache<String, Map<String, Object>> computeValue(FaceletContext faceletContext) {
            FacesContext facesContext = faceletContext.getFacesContext();
            ExternalContext externalContext = facesContext.getExternalContext();
            Map applicationMap = externalContext.getApplicationMap();
            Cache constantCache = (Cache)applicationMap.get(LoadConstants.class.getName());
            return constantCache;
        }
    }

    protected static enum PropertyKeys {
        cacheable,
        classType,
        var;

    }
}

