/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.tagdecorator.internal;

import com.liferay.faces.alloy.config.internal.AlloyWebConfigParam;
import com.liferay.faces.alloy.tagdecorator.internal.TagAttributesAlloyImpl;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagDecorator;

public class TagDecoratorAlloyImpl
implements TagDecorator {
    private static final String ELEMENT_NAME = "elementName";

    public Tag decorate(Tag tag) {
        Tag decoratedTag = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        boolean alloyTagDecoratorEnabled = AlloyWebConfigParam.AlloyTagDecoratorEnabled.getBooleanValue(externalContext);
        if (alloyTagDecoratorEnabled) {
            TagAttribute elementNameAttribute;
            String elementName = tag.getLocalName();
            TagAttributes attributes = tag.getAttributes();
            if ("element".equals(elementName) && attributes != null && (elementNameAttribute = attributes.get("http://xmlns.jcp.org/jsf/passthrough", ELEMENT_NAME)) != null) {
                elementName = elementNameAttribute.getValue();
                attributes = new TagAttributesAlloyImpl(attributes);
            }
            String namespace = tag.getNamespace();
            if ("video".equals(elementName) && !"http://liferay.com/faces/alloy".equals(namespace)) {
                decoratedTag = new Tag(tag.getLocation(), "http://liferay.com/faces/alloy", "video", "alloy:video", attributes);
            } else if ("audio".equals(elementName) && !"http://liferay.com/faces/alloy".equals(namespace)) {
                decoratedTag = new Tag(tag.getLocation(), "http://liferay.com/faces/alloy", "audio", "alloy:audio", attributes);
            }
        }
        return decoratedTag;
    }
}

