/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.render.internal;

import com.liferay.faces.alloy.render.internal.AlloyRendererUtil;
import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.client.BrowserSnifferFactory;
import com.liferay.faces.util.client.Script;
import com.liferay.faces.util.client.ScriptsEncoder;
import com.liferay.faces.util.client.ScriptsEncoderWrapper;
import com.liferay.faces.util.factory.FactoryExtensionFinder;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ScriptsEncoderAlloyImpl
extends ScriptsEncoderWrapper
implements Serializable {
    private static final long serialVersionUID = 9063135909273616418L;
    private final ScriptsEncoder wrappedScriptsEncoder;

    public ScriptsEncoderAlloyImpl(ScriptsEncoder wrappedScriptsEncoder) {
        this.wrappedScriptsEncoder = wrappedScriptsEncoder;
    }

    private static boolean allowLiferayToHandleScripts(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        ProductFactory productFactory = (ProductFactory)FactoryExtensionFinder.getFactory((ExternalContext)externalContext, ProductFactory.class);
        Product LIFERAY_PORTAL = productFactory.getProductInfo(Product.Name.LIFERAY_PORTAL);
        Product LIFERAY_FACES_BRIDGE = productFactory.getProductInfo(Product.Name.LIFERAY_FACES_BRIDGE);
        return LIFERAY_PORTAL.isDetected() && LIFERAY_FACES_BRIDGE.isDetected();
    }

    public void encodeBodyScripts(FacesContext facesContext, List<Script> scripts) throws IOException {
        if (ScriptsEncoderAlloyImpl.allowLiferayToHandleScripts(facesContext)) {
            super.encodeBodyScripts(facesContext, scripts);
        } else {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.startElement("script", null);
            responseWriter.writeAttribute("type", (Object)"text/javascript", null);
            this.encodeScripts(facesContext, responseWriter, scripts);
            responseWriter.endElement("script");
        }
    }

    public void encodeEvalScripts(FacesContext facesContext, List<Script> scripts) throws IOException {
        if (ScriptsEncoderAlloyImpl.allowLiferayToHandleScripts(facesContext)) {
            super.encodeEvalScripts(facesContext, scripts);
        } else {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            this.encodeScripts(facesContext, responseWriter, scripts);
        }
    }

    public ScriptsEncoder getWrapped() {
        return this.wrappedScriptsEncoder;
    }

    private void encodeScripts(FacesContext facesContext, ResponseWriter responseWriter, List<Script> scripts) throws IOException {
        TreeSet<String> sortedModules = new TreeSet<String>();
        ArrayList<Script> alloyScripts = new ArrayList<Script>();
        ArrayList<Script> basicScripts = new ArrayList<Script>();
        for (Script script : scripts) {
            Script.ModulesType modulesType = script.getModulesType();
            if (Script.ModulesType.ALLOY.equals((Object)modulesType)) {
                String[] modules = script.getModules();
                if (modules != null) {
                    for (String module : modules) {
                        sortedModules.add(module.trim());
                    }
                }
                alloyScripts.add(script);
                continue;
            }
            basicScripts.add(script);
        }
        for (Script script : basicScripts) {
            responseWriter.write(script.getSourceCode());
        }
        if (!alloyScripts.isEmpty()) {
            BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
            String alloyBeginScript = AlloyRendererUtil.getAlloyBeginScript(sortedModules, null, browserSniffer);
            responseWriter.write(alloyBeginScript);
            for (Script alloyScript : alloyScripts) {
                responseWriter.write("(function(){");
                responseWriter.write(alloyScript.getSourceCode());
                responseWriter.write("})();");
            }
            responseWriter.write("});");
        }
    }
}

