/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.outputscript.internal;

import com.liferay.faces.alloy.component.outputscript.OutputScript;
import com.liferay.faces.alloy.component.outputscript.internal.OutputScriptRendererBase;
import com.liferay.faces.alloy.component.outputscript.internal.OutputScriptResponseWriter;
import com.liferay.faces.alloy.render.internal.AlloyRendererUtil;
import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.client.BrowserSnifferFactory;
import com.liferay.faces.util.client.Script;
import com.liferay.faces.util.client.ScriptFactory;
import com.liferay.faces.util.context.FacesRequestContext;
import com.liferay.faces.util.render.BufferedScriptResponseWriter;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Output", rendererType="com.liferay.faces.alloy.component.outputscript.OutputScriptRenderer")
@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class OutputScriptRenderer
extends OutputScriptRendererBase {
    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        OutputScript outputScript = (OutputScript)uiComponent;
        String name = outputScript.getName();
        if (name != null && name.length() > 0) {
            super.encodeChildren(facesContext, uiComponent);
        } else {
            String use = outputScript.getUse();
            String target = outputScript.getTarget();
            if ("body".equals(target) && !facesContext.getPartialViewContext().isAjaxRequest()) {
                Script script;
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                BufferedScriptResponseWriter bufferedScriptResponseWriter = new BufferedScriptResponseWriter();
                facesContext.setResponseWriter((ResponseWriter)bufferedScriptResponseWriter);
                super.encodeChildren(facesContext, uiComponent);
                facesContext.setResponseWriter(responseWriter);
                String bufferedScriptString = bufferedScriptResponseWriter.toString();
                ExternalContext externalContext = facesContext.getExternalContext();
                if (use != null && use.length() > 0) {
                    String[] modules = use.split(",");
                    script = ScriptFactory.getScriptInstance((ExternalContext)externalContext, (String)bufferedScriptString, (String[])modules, (Script.ModulesType)Script.ModulesType.ALLOY);
                } else {
                    script = ScriptFactory.getScriptInstance((ExternalContext)externalContext, (String)bufferedScriptString);
                }
                FacesRequestContext facesRequestContext = FacesRequestContext.getCurrentInstance();
                facesRequestContext.addScript(script);
            } else if (use != null && use.length() > 0) {
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                String[] modules = use.split(",");
                BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
                String alloyBeginScript = AlloyRendererUtil.getAlloyBeginScript(modules, null, browserSniffer);
                OutputScriptResponseWriter outputScriptResponseWriter = new OutputScriptResponseWriter(responseWriter, alloyBeginScript);
                super.encodeChildren(facesContext, uiComponent, (ResponseWriter)outputScriptResponseWriter);
            } else {
                super.encodeChildren(facesContext, uiComponent);
            }
        }
    }
}

