/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputtime.internal;

import com.liferay.faces.alloy.component.inputdatetime.internal.InputDateTimeResponseWriter;
import com.liferay.faces.alloy.component.inputtime.InputTime;
import com.liferay.faces.alloy.component.inputtime.internal.InputTimeRendererBase;
import com.liferay.faces.alloy.component.inputtime.internal.InputTimeResponseWriter;
import com.liferay.faces.alloy.render.internal.EscapedClientId;
import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.client.BrowserSnifferFactory;
import com.liferay.faces.util.helper.StringHelper;
import com.liferay.faces.util.render.JavaScriptFragment;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Input", rendererType="com.liferay.faces.alloy.component.inputtime.InputTimeRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy", name="alloy.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class InputTimeRenderer
extends InputTimeRendererBase {
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("([0-1][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]");
    private static final String TOKEN_REGEX = "\\{0\\}";

    protected static String getMaskFromTimePattern(String timePattern) {
        String mask = timePattern;
        mask = mask.replaceAll("%", "%%");
        mask = mask.replaceAll("\n", "%n");
        mask = mask.replaceAll("\t", "%t");
        mask = mask.replaceAll("HH", TOKEN_REGEX);
        mask = mask.replaceAll("H", "%k");
        mask = mask.replaceAll(TOKEN_REGEX, "%H");
        mask = mask.replaceAll("hh", "%I");
        mask = mask.replaceAll("h", "%l");
        mask = mask.replaceAll("mm", "%M");
        mask = mask.replaceAll("m", "%M");
        mask = mask.replaceAll("ss", "%S");
        mask = mask.replaceAll("s", "%S");
        mask = mask.replaceAll("aaa", "%p");
        mask = mask.replaceAll("aa", "%p");
        mask = mask.replaceAll("a", "%p");
        mask = mask.replaceAll("Z", TOKEN_REGEX);
        mask = mask.replaceAll("zzzz", "%Z");
        mask = mask.replaceAll("zzz", "%Z");
        mask = mask.replaceAll("zz", "%Z");
        mask = mask.replaceAll("z", "%Z");
        mask = mask.replaceAll(TOKEN_REGEX, "%z");
        return mask;
    }

    private static long getMillisFromTimeStamp(String timeStamp) throws ParseException {
        if (!TIMESTAMP_PATTERN.matcher(timeStamp).matches()) {
            Matcher matcher;
            int errorOffset;
            for (errorOffset = timeStamp.length() - 1; errorOffset > 0 && ((matcher = TIMESTAMP_PATTERN.matcher(timeStamp.substring(0, errorOffset))).matches() || !matcher.hitEnd()); --errorOffset) {
            }
            throw new ParseException("TimeStamp must be of the form \"HH:mm:ss\".", errorOffset);
        }
        String[] timeStampArray = timeStamp.split(":");
        int hours = Integer.parseInt(timeStampArray[0]);
        int minutes = Integer.parseInt(timeStampArray[1]);
        int seconds = Integer.parseInt(timeStampArray[2]);
        return ((hours * 60 + minutes) * 60 + seconds) * 1000;
    }

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        InputTime inputTime = (InputTime)uiComponent;
        String clientVarName = this.getClientVarName(facesContext, inputTime);
        String clientKey = inputTime.getClientKey();
        if (clientKey == null) {
            clientKey = clientVarName;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        if (this.isNative(browserSniffer, inputTime)) {
            JavaScriptFragment liferayComponent = new JavaScriptFragment("Liferay.component('" + clientKey + "')");
            String clientId = uiComponent.getClientId(facesContext);
            String inputClientId = clientId.concat("_input");
            int defaultHTML5PatternLength = "HH:mm".length();
            String maxTime = inputTime.getMaxTime().substring(0, defaultHTML5PatternLength);
            String minTime = inputTime.getMinTime().substring(0, defaultHTML5PatternLength);
            this.encodeFunctionCall(responseWriter, "LFAI.initDateTimePickerMobile", new Object[]{liferayComponent, inputClientId, maxTime, minTime});
        } else {
            long maxTime;
            long minTime;
            this.encodeLiferayComponentVar(responseWriter, clientVarName, clientKey);
            responseWriter.write(clientVarName);
            responseWriter.write("._setValues=LFAI.timePickerSetValues;");
            responseWriter.write(clientVarName);
            responseWriter.write(".set('values',[");
            String minTimeStamp = inputTime.getMinTime();
            String maxTimeStamp = inputTime.getMaxTime();
            try {
                minTime = InputTimeRenderer.getMillisFromTimeStamp(minTimeStamp);
                maxTime = InputTimeRenderer.getMillisFromTimeStamp(maxTimeStamp);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
            if (minTime > maxTime) {
                throw new IOException("minTime must not be later than maxTime.");
            }
            String timePattern = inputTime.getPattern();
            Object objectLocale = inputTime.getLocale();
            Locale locale = inputTime.getObjectAsLocale(objectLocale);
            TimeZone timeZone = TimeZone.getTimeZone("Greenwich");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(timePattern, locale);
            simpleDateFormat.setTimeZone(timeZone);
            Integer millisecondStep = inputTime.getStep() * 1000;
            boolean firstTimeStamp = true;
            if (millisecondStep < 1) {
                throw new IOException("step cannot be less than 1.");
            }
            for (long milliseconds = minTime; milliseconds <= maxTime; milliseconds += (long)millisecondStep.intValue()) {
                if (!firstTimeStamp) {
                    responseWriter.write(",");
                } else {
                    firstTimeStamp = false;
                }
                Date time = new Date(milliseconds);
                String dateString = simpleDateFormat.format(time);
                String escapedDateString = RendererUtil.escapeJavaScript((String)dateString);
                responseWriter.write("'");
                responseWriter.write(escapedDateString);
                responseWriter.write("'");
            }
            responseWriter.write("]);");
        }
    }

    @Override
    public String getAlloyClassName(FacesContext facesContext, UIComponent uiComponent) {
        InputTime inputTime;
        String alloyClassName = super.getAlloyClassName(facesContext, uiComponent);
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        if (this.isNative(browserSniffer, inputTime = (InputTime)uiComponent)) {
            alloyClassName = alloyClassName.concat("Native");
        }
        return alloyClassName;
    }

    @Override
    public String getButtonIconName() {
        return "time";
    }

    @Override
    public String[] getModules(FacesContext facesContext, UIComponent uiComponent) {
        String highlighterType;
        String[] modules = this.getModules(MODULES[0], facesContext, uiComponent);
        InputTime inputTime = (InputTime)uiComponent;
        String filterType = inputTime.getFilterType();
        if (filterType != null && filterType.length() > 0) {
            modules = StringHelper.append((String[])modules, (String[])new String[]{"autocomplete-filters"});
        }
        if ((highlighterType = inputTime.getHighlighterType()) != null && highlighterType.length() > 0) {
            modules = StringHelper.append((String[])modules, (String[])new String[]{"autocomplete-highlighters"});
        }
        return modules;
    }

    protected void encodeAutocomplete(FacesContext facesContext, ResponseWriter responseWriter, InputTime inputTime, boolean first) throws IOException {
        boolean valueChangeClientBehaviorsNotEmpty;
        Boolean scrollIntoView;
        Integer queryDelay;
        Integer maxResults;
        String highlighterType;
        String height;
        String filterType;
        this.encodeNonEscapedObject(responseWriter, "autocomplete", "", first);
        responseWriter.write("{");
        boolean autoCompleteFirst = true;
        boolean activateFirstItem = inputTime.isActivateFirstItem();
        this.encodeBoolean(responseWriter, "activateFirstItem", activateFirstItem, autoCompleteFirst);
        autoCompleteFirst = false;
        Boolean circular = inputTime.getCircular();
        if (circular != null) {
            this.encodeBoolean(responseWriter, "circular", circular, autoCompleteFirst);
            autoCompleteFirst = false;
        }
        if ((filterType = inputTime.getFilterType()) != null) {
            this.encodeString(responseWriter, "resultFilters", filterType, autoCompleteFirst);
            autoCompleteFirst = false;
        }
        if ((height = inputTime.getHeight()) != null) {
            this.encodeString(responseWriter, "height", height, autoCompleteFirst);
            autoCompleteFirst = false;
        }
        if ((highlighterType = inputTime.getHighlighterType()) != null) {
            this.encodeString(responseWriter, "resultHighlighter", highlighterType, autoCompleteFirst);
            autoCompleteFirst = false;
        }
        if ((maxResults = inputTime.getMaxResults()) != null) {
            this.encodeString(responseWriter, "maxResults", maxResults, autoCompleteFirst);
            autoCompleteFirst = false;
        }
        if ((queryDelay = inputTime.getQueryDelay()) != null) {
            this.encodeString(responseWriter, "queryDelay", queryDelay, autoCompleteFirst);
            autoCompleteFirst = false;
        }
        if ((scrollIntoView = inputTime.getScrollIntoView()) != null) {
            this.encodeBoolean(responseWriter, "scrollIntoView", scrollIntoView, autoCompleteFirst);
            autoCompleteFirst = false;
        }
        String showOn = inputTime.getShowOn();
        boolean showOnButton = "button".equals(showOn);
        Map clientBehaviorMap = inputTime.getClientBehaviors();
        List valueChangeClientBehaviors = (List)clientBehaviorMap.get("valueChange");
        boolean bl = valueChangeClientBehaviorsNotEmpty = valueChangeClientBehaviors != null && !valueChangeClientBehaviors.isEmpty();
        if (showOnButton || valueChangeClientBehaviorsNotEmpty) {
            this.encodeNonEscapedObject(responseWriter, "after", "", autoCompleteFirst);
            responseWriter.write("{");
            this.encodeNonEscapedObject(responseWriter, "select", "", true);
            responseWriter.write("function(event){");
            String clientId = inputTime.getClientId(facesContext);
            String inputClientId = clientId.concat("_input");
            EscapedClientId escapedInputClientId = new EscapedClientId(inputClientId);
            boolean selectable = true;
            JavaScriptFragment time = null;
            if (showOnButton) {
                time = new JavaScriptFragment("event.result.text");
            }
            this.encodeFunctionCall(responseWriter, "LFAI.inputDateTimePickerSelect", new Object[]{Character.valueOf('A'), escapedInputClientId, selectable, time, valueChangeClientBehaviorsNotEmpty});
            responseWriter.append((CharSequence)";}");
            responseWriter.write("}");
            autoCompleteFirst = false;
        }
        responseWriter.write("}");
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, InputTime inputTime, boolean first) throws IOException {
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        if (!this.isNative(browserSniffer, inputTime)) {
            this.encodeAutocomplete(facesContext, responseWriter, inputTime, first);
            first = false;
            this.encodeHiddenAttributesInputDateTime(facesContext, responseWriter, inputTime, first);
            first = false;
        }
    }

    @Override
    protected void encodeMask(ResponseWriter responseWriter, InputTime inputTime, String timePattern, boolean first) throws IOException {
        String timePatternMask = InputTimeRenderer.getMaskFromTimePattern(timePattern);
        super.encodeMask(responseWriter, inputTime, timePatternMask, first);
    }

    @Override
    protected InputDateTimeResponseWriter getInputDateTimeResponseWriter(ResponseWriter responseWriter, String inputClientId, boolean nativeInputTime) {
        return new InputTimeResponseWriter(responseWriter, inputClientId, nativeInputTime);
    }
}

