/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputsourcecode.internal;

import com.liferay.faces.alloy.component.inputsourcecode.InputSourceCode;
import com.liferay.faces.alloy.component.inputsourcecode.internal.InputSourceCodeRendererBase;
import com.liferay.faces.util.component.ClientComponent;
import com.liferay.faces.util.component.ComponentUtil;
import com.liferay.faces.util.render.HiddenTextResponseWriter;
import java.io.IOException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Input", rendererType="com.liferay.faces.alloy.component.inputsourcecode.InputSourceCodeRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class InputSourceCodeRenderer
extends InputSourceCodeRendererBase {
    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        InputSourceCode inputSourceCode = (InputSourceCode)uiComponent;
        Boolean readOnly = inputSourceCode.getReadOnly();
        ClientComponent clientComponent = (ClientComponent)uiComponent;
        String clientVarName = this.getClientVarName(facesContext, clientComponent);
        String clientKey = clientComponent.getClientKey();
        if (clientKey == null) {
            clientKey = clientVarName;
        }
        this.encodeLiferayComponentVar(responseWriter, clientVarName, clientKey);
        if (readOnly == null || !readOnly.booleanValue()) {
            String hiddenInputClientId = this.getHiddenInputClientId(facesContext, uiComponent);
            String escapedHiddenInputClientId = "#" + ComponentUtil.escapeClientId((String)hiddenInputClientId);
            responseWriter.write(clientVarName);
            responseWriter.write(".getSession().on('change', function() {A.one('");
            responseWriter.write(escapedHiddenInputClientId);
            responseWriter.write("').set('value',");
            responseWriter.write(clientVarName);
            responseWriter.write(".getSession().getValue())});");
        }
        responseWriter.write(clientVarName);
        responseWriter.write(".editor.setOptions({ minLines: ");
        responseWriter.write(inputSourceCode.getMinLines().toString());
        responseWriter.write("});");
        responseWriter.write(clientVarName);
        responseWriter.write(".editor.setOptions({ maxLines: ");
        responseWriter.write(inputSourceCode.getMaxLines().toString());
        responseWriter.write("});");
    }

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        responseWriter.startElement("div", uiComponent);
        responseWriter.writeAttribute("id", (Object)clientId, "id");
        String defaultBoundingBoxClientId = this.getDefaultBoundingBoxClientId(facesContext, uiComponent);
        responseWriter.startElement("div", uiComponent);
        responseWriter.writeAttribute("id", (Object)defaultBoundingBoxClientId, "id");
        responseWriter.endElement("div");
        ResponseWriter delegationResponseWriter = this.getDelegationResponseWriter(facesContext, uiComponent);
        super.encodeMarkupBegin(facesContext, uiComponent, delegationResponseWriter);
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter delegationResponseWriter = this.getDelegationResponseWriter(facesContext, uiComponent);
        super.encodeMarkupEnd(facesContext, uiComponent, delegationResponseWriter);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
    }

    public ResponseWriter getDelegationResponseWriter(FacesContext facesContext, UIComponent uiComponent) {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String hiddenInputClientId = this.getHiddenInputClientId(facesContext, uiComponent);
        return new HiddenTextResponseWriter(responseWriter, hiddenInputClientId);
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, InputSourceCode inputSourceCode, boolean first) throws IOException {
        this.encodeWidgetRender(responseWriter, first);
        first = false;
        String boundingBox = this.getDefaultBoundingBoxClientId(facesContext, (UIComponent)inputSourceCode);
        this.encodeClientId(responseWriter, "boundingBox", boundingBox, first);
    }

    protected String getDefaultBoundingBoxClientId(FacesContext facesContext, UIComponent uiComponent) {
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)facesContext);
        return uiComponent.getClientId(facesContext) + separatorChar + "boundingBox";
    }

    protected String getHiddenInputClientId(FacesContext facesContext, UIComponent uiComponent) {
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)facesContext);
        return uiComponent.getClientId(facesContext) + separatorChar + "hidden";
    }
}

