/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputfile.internal;

import com.liferay.faces.alloy.component.inputfile.internal.InputFileDecoder;
import com.liferay.faces.alloy.component.inputfile.internal.InputFileDecoderPartImpl;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.config.ConfiguredServlet;
import com.liferay.faces.util.config.MultiPartConfig;
import com.liferay.faces.util.config.WebConfig;
import com.liferay.faces.util.config.WebConfigParam;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.UploadedFile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.webapp.FacesServlet;

public abstract class InputFileDecoderBase
implements InputFileDecoder {
    private static final Logger logger = LoggerFactory.getLogger(InputFileDecoderPartImpl.class);
    private static final String FACES_SERVLET_FQCN = FacesServlet.class.getName();

    @Override
    public abstract Map<String, List<UploadedFile>> decode(FacesContext var1, String var2);

    protected void addUploadedFile(Map<String, List<UploadedFile>> uploadedFileMap, String fieldName, UploadedFile uploadedFile) {
        List<UploadedFile> uploadedFiles = uploadedFileMap.get(fieldName);
        if (uploadedFiles == null) {
            uploadedFiles = new ArrayList<UploadedFile>();
            uploadedFileMap.put(fieldName, uploadedFiles);
        }
        uploadedFiles.add(uploadedFile);
    }

    protected MultiPartConfig getFacesServletMultiPartConfig(ExternalContext externalContext) {
        MultiPartConfig facesServletMultiPartConfig = null;
        String appConfigAttrName = ApplicationConfig.class.getName();
        Map applicationMap = externalContext.getApplicationMap();
        ApplicationConfig applicationConfig = (ApplicationConfig)applicationMap.get(appConfigAttrName);
        WebConfig webConfig = applicationConfig.getWebConfig();
        List configuredServlets = webConfig.getConfiguredServlets();
        for (ConfiguredServlet configuredServlet : configuredServlets) {
            if (!FACES_SERVLET_FQCN.equals(configuredServlet.getServletClass())) continue;
            facesServletMultiPartConfig = configuredServlet.getMultiPartConfig();
        }
        return facesServletMultiPartConfig;
    }

    protected String getSessionId(ExternalContext externalContext) {
        String sessionId = null;
        try {
            Object session = externalContext.getSession(true);
            Method getIdMethod = session.getClass().getMethod("getId", new Class[0]);
            sessionId = (String)getIdMethod.invoke(session, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return sessionId;
    }

    protected String getUploadedFilesFolder(ExternalContext externalContext, String location) {
        String uploadedFilesDir = null;
        if (location != null && location.length() > 0) {
            uploadedFilesDir = location;
        } else {
            MultiPartConfig facesServletMultiPartConfig = this.getFacesServletMultiPartConfig(externalContext);
            if (facesServletMultiPartConfig != null) {
                uploadedFilesDir = facesServletMultiPartConfig.getLocation();
            }
            if (uploadedFilesDir == null) {
                uploadedFilesDir = WebConfigParam.UploadedFilesDir.getStringValue(externalContext);
            }
        }
        return uploadedFilesDir;
    }

    protected String stripIllegalCharacters(String fileName) {
        String strippedFileName = fileName;
        if (fileName != null) {
            int pos = fileName.lastIndexOf(".");
            strippedFileName = fileName.replaceAll("[\\\\/\\[\\]:|<>+;=.?\"]", "-");
            if (pos > 0) {
                strippedFileName = strippedFileName.substring(0, pos) + "." + strippedFileName.substring(pos + 1);
            }
        }
        return strippedFileName;
    }
}

