/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputdatetime;

import com.liferay.faces.alloy.component.inputdatetime.InputDateTimeBase;
import com.liferay.faces.util.i18n.I18n;
import com.liferay.faces.util.i18n.I18nFactory;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;

public abstract class InputDateTime
extends InputDateTimeBase {
    public abstract String getPattern();

    public String getAutocomplete() {
        return (String)this.getStateHelper().eval((Serializable)HtmlInputText.PropertyKeys.autocomplete, (Object)this.getDefaultAutocomplete());
    }

    public Converter getConverter() {
        Converter converter = super.getConverter();
        if (converter == null) {
            DateTimeConverter dateTimeConverter = new DateTimeConverter();
            String pattern = this.getPattern();
            dateTimeConverter.setPattern(pattern);
            Object objectLocale = this.getLocale();
            Locale locale = this.getObjectAsLocale(objectLocale);
            dateTimeConverter.setLocale(locale);
            String timeZoneString = this.getTimeZone();
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
            dateTimeConverter.setTimeZone(timeZone);
            converter = dateTimeConverter;
        }
        return converter;
    }

    @Override
    public Object getLocale() {
        return this.getLocale(FacesContext.getCurrentInstance());
    }

    public Object getLocale(FacesContext facesContext) {
        Object locale = super.getLocale();
        if (locale == null) {
            UIViewRoot viewRoot = facesContext.getViewRoot();
            locale = viewRoot.getLocale();
        }
        return locale;
    }

    public final Date getObjectAsDate(Object dateAsObject, String datePattern, TimeZone timeZone) throws FacesException {
        Date date = null;
        if (dateAsObject != null) {
            if (dateAsObject instanceof Date) {
                date = (Date)dateAsObject;
            } else if (dateAsObject instanceof String) {
                String dateAsString = (String)dateAsObject;
                if (dateAsString.length() > 0) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(datePattern);
                        simpleDateFormat.setTimeZone(timeZone);
                        date = simpleDateFormat.parse(dateAsString);
                    }
                    catch (ParseException e) {
                        FacesException facesException = new FacesException((Throwable)e);
                        throw facesException;
                    }
                }
            } else {
                String message = "Unable to convert value to Date.";
                FacesException facesException = new FacesException(message);
                throw facesException;
            }
        }
        return date;
    }

    public final Locale getObjectAsLocale(Object localeAsObject) throws FacesException {
        Locale locale = null;
        if (localeAsObject != null) {
            if (localeAsObject instanceof Locale) {
                locale = (Locale)localeAsObject;
            } else if (localeAsObject instanceof String) {
                String localeAsString = (String)localeAsObject;
                if (localeAsString.length() > 0) {
                    String[] locales = localeAsString.split("-");
                    locale = locales.length > 1 ? new Locale(locales[0], locales[1]) : new Locale(locales[0]);
                }
            } else {
                String message = "Unable to convert value to locale.";
                FacesException facesException = new FacesException(message);
                throw facesException;
            }
        }
        return locale;
    }

    protected final void validateValue(FacesContext facesContext, Object newValue, Date minDate, Date maxDate, TimeZone timeZone) {
        String pattern = this.getPattern();
        Date submittedDate = this.getObjectAsDate(newValue, pattern, timeZone);
        try {
            if (submittedDate.before(minDate) || submittedDate.after(maxDate)) {
                FacesMessage facesMessage;
                this.setValid(false);
                String validatorMessage = this.getValidatorMessage();
                if (validatorMessage != null) {
                    facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage);
                } else {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                    simpleDateFormat.setTimeZone(timeZone);
                    String minDateString = simpleDateFormat.format(minDate);
                    String maxDateString = simpleDateFormat.format(maxDate);
                    Locale locale = this.getObjectAsLocale(this.getLocale(facesContext));
                    ExternalContext externalContext = facesContext.getExternalContext();
                    I18n i18n = I18nFactory.getI18nInstance((ExternalContext)externalContext);
                    String message = i18n.getMessage(facesContext, locale, "please-enter-a-value-between-x-and-x", new Object[]{minDateString, maxDateString});
                    facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message);
                }
                String clientId = this.getClientId(facesContext);
                facesContext.addMessage(clientId, facesMessage);
            } else {
                this.setValid(true);
            }
        }
        catch (FacesException e) {
            this.setValid(false);
            String message = e.getMessage();
            FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message);
            String clientId = this.getClientId(facesContext);
            facesContext.addMessage(clientId, facesMessage);
        }
    }

    private String getDefaultAutocomplete() {
        String autocomplete = null;
        String showOn = this.getShowOn();
        if ("focus".equalsIgnoreCase(showOn) || "both".equalsIgnoreCase(showOn)) {
            autocomplete = "off";
        }
        return autocomplete;
    }
}

