/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.datatable;

import com.liferay.faces.alloy.component.datatable.DataTableBase;
import com.liferay.faces.alloy.component.datatable.RowDeselectEvent;
import com.liferay.faces.alloy.component.datatable.RowDeselectRangeEvent;
import com.liferay.faces.alloy.component.datatable.RowSelectEvent;
import com.liferay.faces.alloy.component.datatable.RowSelectRangeEvent;
import com.liferay.faces.util.helper.IntegerHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;

@FacesComponent(value="com.liferay.faces.alloy.component.datatable.DataTable")
public class DataTable
extends DataTableBase
implements ClientBehaviorHolder {
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("rowSelect", "rowSelectRange", "rowDeselect", "rowDeselectRange"));

    public String getDefaultEventName() {
        return "rowSelect";
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public List<Object> getRowDataList(int[] rowIndexes) {
        ArrayList<Object> rowDataList = null;
        if (rowIndexes != null) {
            int originalRowIndex = this.getRowIndex();
            rowDataList = new ArrayList<Object>(rowIndexes.length);
            for (int rowIndex : rowIndexes) {
                this.setRowIndex(rowIndex);
                rowDataList.add(this.getRowData());
            }
            this.setRowIndex(originalRowIndex);
        }
        return rowDataList;
    }

    public void queueEvent(FacesEvent facesEvent) {
        if (facesEvent instanceof AjaxBehaviorEvent) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestParameterMap = externalContext.getRequestParameterMap();
            String eventName = (String)requestParameterMap.get("javax.faces.behavior.event");
            if ("rowSelect".equals(eventName) || "rowDeselect".equals(eventName)) {
                AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)facesEvent;
                Behavior behavior = behaviorEvent.getBehavior();
                String clientId = this.getClientId(facesContext);
                int originalRowIndex = this.getRowIndex();
                int selectedRowIndex = IntegerHelper.toInteger((String)((String)requestParameterMap.get(clientId + "_rowIndex")));
                this.setRowIndex(selectedRowIndex);
                Object rowData = this.getRowData();
                this.setRowIndex(originalRowIndex);
                facesEvent = "rowSelect".equals(eventName) ? new RowSelectEvent((UIComponent)this, behavior, selectedRowIndex, rowData) : new RowDeselectEvent((UIComponent)this, behavior, selectedRowIndex, rowData);
            } else if ("rowSelectRange".equals(eventName) || "rowDeselectRange".equals(eventName)) {
                AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)facesEvent;
                Behavior behavior = behaviorEvent.getBehavior();
                String clientId = this.getClientId(facesContext);
                String rowIndexRange = (String)requestParameterMap.get(clientId + "_rowIndexRange");
                int[] rowIndexArray = this.toIntArray(rowIndexRange);
                facesEvent = "rowSelectRange".equals(eventName) ? new RowSelectRangeEvent((UIComponent)this, behavior, rowIndexArray, this.getRowDataList(rowIndexArray)) : new RowDeselectRangeEvent((UIComponent)this, behavior, rowIndexArray, this.getRowDataList(rowIndexArray));
            }
        }
        super.queueEvent(facesEvent);
    }

    public void restoreState(FacesContext context, Object state) {
        super.restoreState(context, state);
        this.getAttributes().put("oldRows", this.getRows());
    }

    public void setValueExpression(String name, ValueExpression binding) {
        super.setValueExpression(name, binding);
    }

    public final int[] toIntArray(String commaDelimitedValue) {
        int[] intArray = null;
        if (commaDelimitedValue != null && commaDelimitedValue.length() > 0) {
            String[] stringArray = commaDelimitedValue.split(",");
            intArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    intArray[i] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new FacesException((Throwable)e);
                }
            }
        }
        return intArray;
    }
}

