/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.datalist.internal;

import com.liferay.faces.alloy.component.data.internal.DataEncoderBase;
import com.liferay.faces.alloy.component.dataitem.DataItem;
import com.liferay.faces.alloy.component.datalist.DataList;
import com.liferay.faces.alloy.component.datalist.internal.DataListRendererBase;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Data", rendererType="com.liferay.faces.alloy.component.datalist.DataListRenderer")
public class DataListRenderer
extends DataListRendererBase {
    private static final String DESCRIPTION = "description";
    private static final String ORDERED = "ordered";
    private static final String UNORDERED = "unordered";
    private static final Logger logger = LoggerFactory.getLogger(DataListRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataList dataList = (DataList)uiComponent;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        String type = dataList.getType();
        if (UNORDERED.equals(type)) {
            responseWriter.startElement("ul", uiComponent);
        } else if (ORDERED.equals(type)) {
            responseWriter.startElement("ol", uiComponent);
        } else if (DESCRIPTION.equals(type)) {
            responseWriter.startElement("dl", uiComponent);
        }
        responseWriter.writeAttribute("id", (Object)clientId, "id");
        RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)((Styleable)uiComponent), (String[])new String[0]);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataList dataList = (DataList)uiComponent;
        UIComponent facet = dataList.getFacet(DESCRIPTION);
        String itemTag = "li";
        String type = dataList.getType();
        if (DESCRIPTION.equals(type)) {
            itemTag = "dt";
        }
        DataEncoderDataItemImpl dataEncoder = new DataEncoderDataItemImpl(facet, itemTag);
        dataEncoder.encodeColumns(facesContext, dataList);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataList dataList = (DataList)uiComponent;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String type = dataList.getType();
        if (UNORDERED.equals(type)) {
            responseWriter.endElement("ul");
        } else if (ORDERED.equals(type)) {
            responseWriter.endElement("ol");
        } else if (DESCRIPTION.equals(type)) {
            responseWriter.endElement("dl");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    private static class DataEncoderDataItemImpl
    extends DataEncoderBase {
        private final UIComponent facet;
        private final String itemTag;

        public DataEncoderDataItemImpl(UIComponent facet, String itemTag) {
            this.facet = facet;
            this.itemTag = itemTag;
        }

        @Override
        protected void encodeColumn(FacesContext facesContext, UIData uiData, UIColumn currentUIColumn, int currentIndex) throws IOException {
            if (currentUIColumn.isRendered() && currentUIColumn instanceof DataItem) {
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                DataItem childDataItem = (DataItem)currentUIColumn;
                responseWriter.startElement(this.itemTag, (UIComponent)childDataItem);
                RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)childDataItem, (String[])new String[0]);
                childDataItem.encodeAll(facesContext);
                responseWriter.endElement(this.itemTag);
                if (this.facet != null) {
                    if (DataEncoderDataItemImpl.isIterateOverDataModel(uiData)) {
                        DataList dataList = (DataList)uiData;
                        String type = dataList.getType();
                        if (DataListRenderer.DESCRIPTION.equals(type)) {
                            responseWriter.startElement("dd", (UIComponent)uiData);
                            String styleClass = dataList.getStyleClass();
                            responseWriter.writeAttribute("class", (Object)(styleClass + "-" + DataListRenderer.DESCRIPTION), "class");
                            this.facet.encodeAll(facesContext);
                            responseWriter.endElement("dd");
                        } else {
                            logger.warn("Ignoring description facet since alloy:dataList type [{0}] is not \"description\".", new Object[]{type});
                        }
                    } else {
                        logger.warn("Ignoring description facet since the value and var attributes are not specified on alloy:dataList.");
                    }
                }
            }
        }

        @Override
        protected Class<? extends UIColumn> getColumnClass() {
            return DataItem.class;
        }
    }
}

