/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.data.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;

public abstract class DataEncoderBase {
    private static final Logger logger = LoggerFactory.getLogger(DataEncoderBase.class);

    public static boolean isIterateOverDataModel(UIData uiData) {
        Object value = uiData.getValue();
        String var = uiData.getVar();
        return value != null && var != null;
    }

    private static String getComponentName(UIComponent uiComponent) {
        return DataEncoderBase.getComponentName(uiComponent.getClass());
    }

    private static String getComponentName(Class clazz) {
        String simpleName = clazz.getSimpleName();
        simpleName = simpleName.length() > 1 ? simpleName.substring(0, 1).toLowerCase(Locale.ENGLISH) + simpleName.substring(1) : simpleName.toLowerCase(Locale.ENGLISH);
        return simpleName;
    }

    public void encodeColumns(FacesContext facesContext, UIData uiData) throws IOException {
        this.encodeColumns(facesContext, uiData, DataEncoderBase.isIterateOverDataModel(uiData));
    }

    public void encodeColumns(FacesContext facesContext, UIData uiData, boolean iterateOverDataModel) throws IOException {
        if (iterateOverDataModel) {
            int rowCount = uiData.getRowCount();
            UIColumn prototypeChild = this.getPrototypeColumnChild(uiData);
            if (prototypeChild != null) {
                for (int i = 0; i < rowCount; ++i) {
                    uiData.setRowIndex(i);
                    this.encodeColumn(facesContext, uiData, prototypeChild, i);
                }
            } else {
                String dataComponentName = DataEncoderBase.getComponentName((UIComponent)uiData);
                Class<? extends UIColumn> columnClass = this.getColumnClass();
                String columnComponentName = DataEncoderBase.getComponentName(columnClass);
                logger.warn("Unable to iterate because alloy:{0} does not have an alloy:{1} child element.", new Object[]{dataComponentName, columnComponentName});
            }
        } else {
            List children = uiData.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                UIComponent child = (UIComponent)children.get(i);
                Class<? extends UIColumn> columnClass = this.getColumnClass();
                if (columnClass.isInstance(child)) {
                    this.encodeColumn(facesContext, uiData, columnClass.cast(child), i);
                    continue;
                }
                String dataComponentName = DataEncoderBase.getComponentName((UIComponent)uiData);
                String columnComponentName = DataEncoderBase.getComponentName(columnClass);
                logger.warn("Unable to render child element of alloy:{0} since it is not alloy:{1}", new Object[]{dataComponentName, columnComponentName});
            }
        }
        uiData.setRowIndex(-1);
    }

    protected abstract Class<? extends UIColumn> getColumnClass();

    protected void encodeColumn(FacesContext facesContext, UIData uiData, UIColumn currentUIColumn, int currentIndex) throws IOException {
        if (currentUIColumn.isRendered()) {
            currentUIColumn.encodeAll(facesContext);
        }
    }

    private UIColumn getPrototypeColumnChild(UIData uiData) {
        UIColumn prototypeChild = null;
        int childCount = uiData.getChildCount();
        if (childCount > 0) {
            List children = uiData.getChildren();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                Class<? extends UIColumn> columnClass = this.getColumnClass();
                if (!columnClass.isInstance(child)) continue;
                prototypeChild = columnClass.cast(child);
            }
        }
        return prototypeChild;
    }
}

