/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.audio.internal;

import com.liferay.faces.alloy.component.audio.Audio;
import com.liferay.faces.alloy.component.audio.internal.AudioRendererBase;
import com.liferay.faces.alloy.component.media.Media;
import java.io.IOException;
import java.net.URLEncoder;
import javax.faces.application.Application;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="com.liferay.faces.alloy.component.media", rendererType="com.liferay.faces.alloy.component.audio.AudioRenderer")
public class AudioRenderer
extends AudioRendererBase {
    @Override
    protected void encodeCustomMediaAttributes(FacesContext facesContext, ResponseWriter responseWriter, Media media) throws IOException {
        Audio audio = (Audio)media;
        String volume = audio.getVolume();
        if (volume != null) {
            responseWriter.writeAttribute("volume", (Object)volume, "volume");
        }
    }

    @Override
    protected void encodeFlashPlayerChildren(FacesContext facesContext, ResponseWriter responseWriter, Media media, String mediaResourceURL, ResourceHandler resourceHandler, Application application, boolean defaultFlashPlayer) throws IOException {
        UIComponent uiComponent;
        if (defaultFlashPlayer) {
            responseWriter.startElement("param", null);
            responseWriter.writeAttribute("name", (Object)"flashVars", null);
            String encodedVideoResourceURL = URLEncoder.encode(mediaResourceURL, "UTF-8");
            String flashVarsValue = "mp3=".concat(encodedVideoResourceURL);
            responseWriter.writeAttribute("value", (Object)flashVarsValue, null);
            responseWriter.endElement("param");
        }
        if ((uiComponent = media.getFacet("flash")) != null) {
            uiComponent.encodeAll(facesContext);
        }
    }

    @Override
    protected String getDefaultFlashPlayerName() {
        return "aui/audio/player.swf";
    }

    @Override
    protected String getMediaType() {
        return "audio";
    }
}

