/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.taghandler;

import com.liferay.faces.util.jsp.JspTagConfig;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

public class LoadConstants
extends TagHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoadConstants.class);
    private static final Map<String, Map<String, Object>> CONSTANT_MAP_CACHE = new ConcurrentHashMap<String, Map<String, Object>>();
    private static final int CACHE_MAX_SIZE = 50;
    private boolean cacheable = true;
    private String classType;
    private String var;

    public LoadConstants() throws Exception {
        super((TagConfig)new JspTagConfig());
    }

    public LoadConstants(TagConfig config) throws Exception {
        super(config);
        TagAttribute typeAttr = this.getAttribute(PropertyKeys.classType.toString());
        if (typeAttr == null) {
            throw new NullPointerException("classType is required.");
        }
        this.classType = typeAttr.getValue();
        TagAttribute varAttr = this.getAttribute(PropertyKeys.var.toString());
        if (varAttr == null) {
            throw new NullPointerException("var is required.");
        }
        this.var = varAttr.getValue();
        TagAttribute cacheableAttr = this.getAttribute(PropertyKeys.cacheable.toString());
        if (cacheableAttr != null) {
            this.cacheable = Boolean.parseBoolean(cacheableAttr.getValue());
        }
    }

    public void apply(FaceletContext facesContext, UIComponent parentUIComponent) throws IOException {
        if (this.cacheable && CONSTANT_MAP_CACHE.containsKey(this.classType)) {
            facesContext.setAttribute(this.var, CONSTANT_MAP_CACHE.get(this.classType));
        } else {
            HashMap<String, Object> constantMap = new HashMap<String, Object>();
            try {
                Field[] fields;
                Class<?> clazz = Class.forName(this.classType);
                for (Field field : fields = clazz.getFields()) {
                    int modifiers = field.getModifiers();
                    if (!Modifier.isStatic(modifiers)) continue;
                    constantMap.put(field.getName(), field.get(null));
                }
                if (this.cacheable) {
                    if (CONSTANT_MAP_CACHE.size() + 1 > 50) {
                        CONSTANT_MAP_CACHE.clear();
                    }
                    CONSTANT_MAP_CACHE.put(this.classType, constantMap);
                }
                facesContext.setAttribute(this.var, constantMap);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Referenced class cannot be found.", e);
            }
            catch (IllegalAccessException e) {
                logger.error((Throwable)e);
            }
        }
    }

    protected static enum PropertyKeys {
        cacheable,
        classType,
        var;

    }
}

