/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.tagdecorator.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;

public class TagAttributesAlloyImpl
extends TagAttributes {
    private static final String ELEMENT_NAME = "elementName";
    private Map<String, TagAttribute> tagAttributeMap = new HashMap<String, TagAttribute>();

    public TagAttributesAlloyImpl(TagAttributes tagAttributes) {
        TagAttribute[] tagAttributesArray;
        for (TagAttribute tagAttribute : tagAttributesArray = tagAttributes.getAll()) {
            String localName = tagAttribute.getLocalName();
            if (ELEMENT_NAME.equals(localName)) continue;
            String namespace = tagAttribute.getNamespace();
            String mapKey = this.getMapKey(namespace, localName);
            this.tagAttributeMap.put(mapKey, tagAttribute);
        }
    }

    public TagAttribute get(String localName) {
        return this.tagAttributeMap.get(localName);
    }

    public TagAttribute get(String namespace, String localName) {
        String mapKey = this.getMapKey(namespace, localName);
        return this.tagAttributeMap.get(mapKey);
    }

    public TagAttribute[] getAll() {
        TagAttribute[] tagAttributeArray = new TagAttribute[this.tagAttributeMap.size()];
        Set<Map.Entry<String, TagAttribute>> entrySet = this.tagAttributeMap.entrySet();
        int i = 0;
        for (Map.Entry<String, TagAttribute> mapEntry : entrySet) {
            tagAttributeArray[i++] = mapEntry.getValue();
        }
        return tagAttributeArray;
    }

    public TagAttribute[] getAll(String namespace) {
        ArrayList<TagAttribute> tagAttributeList = new ArrayList<TagAttribute>();
        Set<Map.Entry<String, TagAttribute>> entrySet = this.tagAttributeMap.entrySet();
        for (Map.Entry<String, TagAttribute> mapEntry : entrySet) {
            TagAttribute tagAttribute = mapEntry.getValue();
            String tagAttributeNamespace = tagAttribute.getNamespace();
            if ((namespace != null || tagAttributeNamespace != null) && (namespace == null || !namespace.equals(tagAttributeNamespace))) continue;
            tagAttributeList.add(tagAttribute);
        }
        return tagAttributeList.toArray(new TagAttribute[tagAttributeList.size()]);
    }

    public String[] getNamespaces() {
        HashSet<String> namespaceSet = new HashSet<String>();
        Set<Map.Entry<String, TagAttribute>> entrySet = this.tagAttributeMap.entrySet();
        for (Map.Entry<String, TagAttribute> mapEntry : entrySet) {
            TagAttribute tagAttribute = mapEntry.getValue();
            namespaceSet.add(tagAttribute.getNamespace());
        }
        return namespaceSet.toArray(new String[namespaceSet.size()]);
    }

    private String getMapKey(String namespace, String localName) {
        String mapKey = namespace;
        if (mapKey == null) {
            mapKey = localName;
        } else if (localName != null) {
            mapKey = mapKey + localName;
        }
        return mapKey;
    }
}

