/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.render.internal;

import com.liferay.faces.alloy.render.internal.AlloyRenderer;
import com.liferay.faces.alloy.render.internal.AlloyRendererUtil;
import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.client.BrowserSnifferFactory;
import com.liferay.faces.util.client.Script;
import com.liferay.faces.util.component.ClientComponent;
import com.liferay.faces.util.render.BufferedScriptResponseWriter;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

class AlloyRendererCommon {
    AlloyRendererCommon() {
    }

    static void encodeEventCallback(ResponseWriter responseWriter, String varName, String methodName, String eventName, String callback) throws IOException {
        responseWriter.write(varName);
        responseWriter.write(".");
        responseWriter.write(methodName);
        responseWriter.write("('");
        responseWriter.write(eventName);
        responseWriter.write("',function(event){");
        responseWriter.write(callback);
        responseWriter.write("});");
    }

    static void encodeJavaScript(FacesContext facesContext, UIComponent uiComponent, AlloyRenderer alloyRenderer) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        BufferedScriptResponseWriter bufferedScriptResponseWriter = new BufferedScriptResponseWriter();
        facesContext.setResponseWriter((ResponseWriter)bufferedScriptResponseWriter);
        alloyRenderer.encodeJavaScriptBegin(facesContext, uiComponent);
        alloyRenderer.encodeJavaScriptMain(facesContext, uiComponent);
        alloyRenderer.encodeJavaScriptCustom(facesContext, uiComponent);
        alloyRenderer.encodeJavaScriptEnd(facesContext, uiComponent);
        String[] modules = null;
        if (!alloyRenderer.isSandboxed(facesContext, uiComponent)) {
            modules = alloyRenderer.getModules(facesContext, uiComponent);
        }
        alloyRenderer.renderScript(facesContext, bufferedScriptResponseWriter.toString(), modules, Script.ModulesType.ALLOY);
        facesContext.setResponseWriter(responseWriter);
    }

    static void encodeJavaScriptBegin(FacesContext facesContext, UIComponent uiComponent, AlloyRenderer alloyRenderer, String[] modules, boolean sandboxed) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (sandboxed) {
            String yuiConfig = alloyRenderer.getYUIConfig(facesContext, responseWriter, uiComponent);
            BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
            String alloyBeginScript = AlloyRendererUtil.getAlloyBeginScript(modules, yuiConfig, browserSniffer);
            responseWriter.write(alloyBeginScript);
        }
        if (facesContext.getPartialViewContext().isAjaxRequest() && uiComponent instanceof ClientComponent) {
            ClientComponent clientComponent = (ClientComponent)uiComponent;
            String clientVarName = alloyRenderer.getClientVarName(facesContext, clientComponent);
            String clientKey = clientComponent.getClientKey();
            if (clientKey == null) {
                clientKey = clientVarName;
            }
            AlloyRendererCommon.encodeLiferayComponentVar(responseWriter, clientVarName, clientKey);
            responseWriter.write("if(");
            responseWriter.write(clientVarName);
            responseWriter.write("){");
            responseWriter.write(clientVarName);
            responseWriter.write(".destroy();}");
        }
    }

    static void encodeJavaScriptEnd(FacesContext facesContext, UIComponent uiComponent, boolean sandboxed) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (sandboxed) {
            responseWriter.write("});");
        }
    }

    static void encodeJavaScriptMain(FacesContext facesContext, UIComponent uiComponent, String alloyClassName, AlloyRenderer alloyRenderer) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        ClientComponent clientComponent = (ClientComponent)uiComponent;
        String clientKey = clientComponent.getClientKey();
        if (clientKey == null) {
            clientKey = alloyRenderer.getClientVarName(facesContext, clientComponent);
        }
        responseWriter.write("Liferay.component('");
        String escapedClientKey = RendererUtil.escapeJavaScript((String)clientKey);
        responseWriter.write(escapedClientKey);
        responseWriter.write("',");
        responseWriter.write("new A.");
        responseWriter.write(alloyClassName);
        responseWriter.write("({");
        alloyRenderer.encodeAlloyAttributes(facesContext, responseWriter, uiComponent);
        responseWriter.write("})");
        responseWriter.write(");");
    }

    static void encodeLiferayComponentVar(ResponseWriter responseWriter, String clientVarName, String clientKey) throws IOException {
        responseWriter.write("var ");
        responseWriter.write(clientVarName);
        responseWriter.write("=");
        AlloyRendererCommon.encodeLiferayComponent(responseWriter, clientKey);
        responseWriter.write(";");
    }

    private static void encodeLiferayComponent(ResponseWriter responseWriter, String clientKey) throws IOException {
        responseWriter.write("Liferay.component('");
        String escapedClientKey = RendererUtil.escapeJavaScript((String)clientKey);
        responseWriter.write(escapedClientKey);
        responseWriter.write("')");
    }
}

