/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.tabview.internal;

import com.liferay.faces.alloy.component.tab.Tab;
import com.liferay.faces.alloy.component.tab.TabUtil;
import com.liferay.faces.alloy.component.tabview.TabView;
import com.liferay.faces.alloy.component.tabview.internal.TabViewRendererBase;
import com.liferay.faces.util.component.ComponentUtil;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Data", rendererType="com.liferay.faces.alloy.component.tabview.TabViewRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class TabViewRenderer
extends TabViewRendererBase {
    private static final String SELECTED_TAB_HEADER_CLASSES = "tab yui3-widget active tab-selected";
    private static final String UNSELECTED_TAB_HEADER_CLASSES = "tab yui3-widget";
    private static final Logger logger = LoggerFactory.getLogger(TabViewRenderer.class);

    public void decodeClientState(FacesContext facesContext, UIComponent uiComponent) {
        TabView tabView = (TabView)uiComponent;
        String hiddenFieldName = tabView.getClientId(facesContext) + "selectedIndex";
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String selectedIndex = (String)requestParameterMap.get(hiddenFieldName);
        if (selectedIndex != null) {
            tabView.setSelectedIndex(IntegerHelper.toInteger((String)selectedIndex, (int)-1));
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        int i;
        int rowCount;
        TabView tabView = (TabView)uiComponent;
        Integer selectedIndex = tabView.getSelectedIndex();
        Object value = tabView.getValue();
        String var = tabView.getVar();
        boolean iterateOverDataModel = value != null && var != null;
        Tab prototypeChildTab = TabUtil.getFirstChildTab(tabView);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("ul", (UIComponent)tabView);
        responseWriter.writeAttribute("class", (Object)"nav nav-tabs", null);
        if (iterateOverDataModel) {
            if (prototypeChildTab != null) {
                rowCount = tabView.getRowCount();
                for (i = 0; i < rowCount; ++i) {
                    tabView.setRowIndex(i);
                    if (!prototypeChildTab.isRendered()) continue;
                    boolean selected = selectedIndex != null && i == selectedIndex;
                    this.encodeTabListItem(facesContext, responseWriter, prototypeChildTab, selected);
                }
                tabView.setRowIndex(-1);
            } else {
                logger.warn("Unable to iterate because alloy:tabView does not have an alloy:tab child element.");
            }
        } else {
            List children = uiComponent.getChildren();
            int childCount = children.size();
            for (int i2 = 0; i2 < childCount; ++i2) {
                UIComponent child = (UIComponent)children.get(i2);
                if (child instanceof Tab && child.isRendered()) {
                    Tab childTab = (Tab)child;
                    boolean selected = selectedIndex != null && i2 == selectedIndex;
                    this.encodeTabListItem(facesContext, responseWriter, childTab, selected);
                    continue;
                }
                logger.warn("Unable to render child element of alloy:tabView since it is not alloy:tab");
            }
        }
        responseWriter.endElement("ul");
        responseWriter.startElement("div", uiComponent);
        responseWriter.writeAttribute("class", (Object)"tab-content", null);
        if (iterateOverDataModel && prototypeChildTab != null) {
            rowCount = tabView.getRowCount();
            for (i = 0; i < rowCount; ++i) {
                tabView.setRowIndex(i);
                prototypeChildTab.encodeAll(facesContext);
            }
        } else {
            List children = tabView.getChildren();
            for (i = 0; i < children.size(); ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (!child.isRendered()) continue;
                child.encodeAll(facesContext);
            }
        }
        tabView.setRowIndex(-1);
        responseWriter.endElement("div");
    }

    public void encodeClientState(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uiComponent) throws IOException {
        TabView tabView = (TabView)uiComponent;
        responseWriter.startElement("input", (UIComponent)tabView);
        String hiddenFieldName = tabView.getClientId(facesContext) + "selectedIndex";
        responseWriter.writeAttribute("id", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("name", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("value", (Object)tabView.getSelectedIndex(), null);
        responseWriter.endElement("input");
    }

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.write("A.one('");
        String clientId = uiComponent.getClientId(facesContext);
        String escapedClientId = "#" + ComponentUtil.escapeClientId((String)clientId);
        responseWriter.write(escapedClientId);
        responseWriter.write("')._node['style'].display='block';");
        TabView tabView = (TabView)uiComponent;
        String clientVarName = this.getClientVarName(facesContext, tabView);
        String clientKey = tabView.getClientKey();
        if (clientKey == null) {
            clientKey = clientVarName;
        }
        this.encodeLiferayComponentVar(responseWriter, clientVarName, clientKey);
        String hiddenFieldId = clientId + "selectedIndex";
        responseWriter.write(clientVarName);
        responseWriter.write(".after('");
        responseWriter.write("selectionChange");
        responseWriter.write("', function(event){ ");
        responseWriter.write("var hidden=document.getElementById('");
        responseWriter.write(hiddenFieldId);
        responseWriter.write("'");
        responseWriter.append((CharSequence)");");
        responseWriter.write("var prevTabIndex=hidden.value;if(event.newVal){hidden.value=event.newVal.get('index');}else if (prevTabIndex==event.newVal.get('index')){hidden.value='';};");
        Map clientBehaviorMap = tabView.getClientBehaviors();
        Collection<String> eventNames = tabView.getEventNames();
        for (String eventName : eventNames) {
            List clientBehaviorsForEvent = (List)clientBehaviorMap.get(eventName);
            if (clientBehaviorsForEvent == null) continue;
            for (ClientBehavior clientBehavior : clientBehaviorsForEvent) {
                ClientBehaviorContext clientBehaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)tabView, (String)eventName, (String)clientId, null);
                String clientBehaviorScript = clientBehavior.getScript(clientBehaviorContext);
                if (!"tabSelect".equals(eventName)) continue;
                responseWriter.write("if(event.newVal){");
                responseWriter.write(clientBehaviorScript);
                responseWriter.write("}");
            }
        }
        responseWriter.write("});");
        int tabIndex = 0;
        List children = tabView.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof Tab) || !child.isRendered()) continue;
            Tab childTab = (Tab)child;
            if (childTab.isDisabled()) {
                responseWriter.write(clientVarName);
                responseWriter.write(".disableTab(");
                responseWriter.write(Integer.toString(tabIndex));
                responseWriter.write(");");
            } else {
                responseWriter.write(clientVarName);
                responseWriter.write(".enableTab(");
                responseWriter.write(Integer.toString(tabIndex));
                responseWriter.write(");");
            }
            ++tabIndex;
        }
    }

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", uiComponent);
        responseWriter.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), "id");
        RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)((Styleable)uiComponent), (String[])new String[0]);
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, TabView tabView, boolean first) throws IOException {
        this.encodeWidgetRender(responseWriter, first);
        first = false;
        this.encodeClientId(responseWriter, "srcNode", tabView.getClientId(facesContext), first);
    }

    protected void encodeTabListItem(FacesContext facesContext, ResponseWriter responseWriter, Tab tab, boolean selected) throws IOException {
        String tabHeaderClass;
        responseWriter.startElement("li", (UIComponent)tab);
        String tabClasses = UNSELECTED_TAB_HEADER_CLASSES;
        if (selected) {
            tabClasses = SELECTED_TAB_HEADER_CLASSES;
        }
        if ((tabHeaderClass = tab.getHeaderClass()) != null) {
            tabClasses = tabClasses + " " + tabHeaderClass;
        }
        responseWriter.writeAttribute("class", (Object)tabClasses, "styleClass");
        responseWriter.startElement("a", (UIComponent)tab);
        if (tab.isDisabled()) {
            responseWriter.writeAttribute("disabled", (Object)"disabled", null);
        }
        responseWriter.writeAttribute("href", (Object)("#" + tab.getClientId(facesContext)), null);
        UIComponent headerFacet = tab.getFacet("header");
        if (headerFacet != null) {
            headerFacet.encodeAll(facesContext);
        } else {
            String headerText = tab.getHeaderText();
            if (headerText != null) {
                responseWriter.write(headerText);
            }
        }
        responseWriter.endElement("a");
        responseWriter.endElement("li");
    }
}

