/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.select.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

public class LabelSurroundingResponseWriter
extends ResponseWriterWrapper {
    private String cssClass;
    private Map<String, Object> inputAttributes = new HashMap<String, Object>();
    private boolean inputMovedInsideLabel = false;
    private boolean writingInput = false;
    private boolean writingLabel = false;
    private ResponseWriter wrappedResponseWriter;

    public LabelSurroundingResponseWriter(ResponseWriter responseWriter, String cssClass) {
        this.wrappedResponseWriter = responseWriter;
        this.cssClass = cssClass;
    }

    public void endElement(String name) throws IOException {
        if ("input".equals(name)) {
            this.writingInput = false;
        } else if ("label".equals(name)) {
            super.endElement(name);
            this.writingLabel = false;
        } else {
            super.endElement(name);
        }
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if ("input".equals(name)) {
            this.writingInput = true;
            this.inputMovedInsideLabel = false;
        } else if ("label".equals(name)) {
            this.writingLabel = true;
            super.startElement(name, component);
        } else {
            super.startElement(name, component);
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.writingInput) {
            this.inputAttributes.put(name, value);
        } else if (this.writingLabel && "class".equals(name)) {
            this.cssClass = this.cssClass + " " + value;
        } else {
            super.writeAttribute(name, value, property);
        }
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        if (this.writingLabel && !this.inputMovedInsideLabel) {
            super.writeAttribute("class", (Object)this.cssClass, null);
            super.startElement("input", component);
            String cssClasses = (String)this.inputAttributes.get("class");
            cssClasses = cssClasses == null ? "field" : cssClasses + " field";
            this.inputAttributes.put("class", cssClasses);
            for (Map.Entry<String, Object> attribute : this.inputAttributes.entrySet()) {
                super.writeAttribute(attribute.getKey(), attribute.getValue(), null);
            }
            this.inputAttributes.clear();
            super.endElement("input");
            this.inputMovedInsideLabel = true;
        }
        super.writeText(text, component, property);
    }
}

