/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.popover.internal;

import com.liferay.faces.alloy.component.button.Button;
import com.liferay.faces.alloy.component.popover.Popover;
import com.liferay.faces.alloy.component.popover.internal.PopoverRendererBase;
import com.liferay.faces.util.component.ClientComponent;
import com.liferay.faces.util.component.ComponentUtil;
import com.liferay.faces.util.helper.StringHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import javax.faces.application.ProjectStage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Panel", rendererType="com.liferay.faces.alloy.component.popover.PopoverRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy", name="alloy.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class PopoverRenderer
extends PopoverRendererBase {
    private static final Logger logger = LoggerFactory.getLogger(PopoverRenderer.class);
    private static final String ALIGN = "align";
    private static final String NODE = "node";

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Popover popover = (Popover)uiComponent;
        ClientComponent clientComponent = (ClientComponent)uiComponent;
        String clientVarName = this.getClientVarName(facesContext, clientComponent);
        String clientKey = clientComponent.getClientKey();
        if (clientKey == null) {
            clientKey = clientVarName;
        }
        if (popover.isHideIconRendered()) {
            responseWriter.write("Liferay.component('");
            responseWriter.write(clientKey);
            responseWriter.write("').addToolbar([{cssClass:'close',label:'\u00d7',on:{click:function(event){Liferay.component('");
            responseWriter.write(clientKey);
            responseWriter.write("').hide();}},render:true}],'header');");
        }
        String clientId = popover.getClientId(facesContext);
        String overlayBodyClientId = clientId.concat("_overlayBody");
        String escapedOverlayBodyClientId = ComponentUtil.escapeClientId((String)overlayBodyClientId);
        String contentBoxClientId = clientId.concat("_contentBox");
        String escapedContentBoxClientId = ComponentUtil.escapeClientId((String)contentBoxClientId);
        responseWriter.write("A.one('#");
        responseWriter.write(escapedOverlayBodyClientId);
        responseWriter.write("').appendTo(A.one('div#");
        responseWriter.write(escapedContentBoxClientId);
        responseWriter.write(">div.popover-content'));");
        if (popover.isDismissible()) {
            this.encodeOverlayDismissible(responseWriter, (UIComponent)popover, clientKey);
        }
        this.encodeOverlayJavaScriptCustom(responseWriter, facesContext, (UIComponent)popover, clientKey);
        if (popover.getFor() == null && facesContext.isProjectStage(ProjectStage.Development)) {
            logger.error("The 'for' attribute is required for alloy:popover");
        }
    }

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.encodeOverlayMarkupBegin(facesContext, uiComponent);
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.encodeOverlayMarkupEnd(facesContext, uiComponent);
    }

    @Override
    public String[] getModules(FacesContext facesContext, UIComponent uiComponent) {
        String[] modules = MODULES;
        Popover popover = (Popover)uiComponent;
        if (popover.isDismissible()) {
            modules = StringHelper.append((String[])modules, (String[])new String[]{"event-move"});
        }
        return modules;
    }

    protected void encodeAlign(ResponseWriter responseWriter, Popover popover, boolean first) throws IOException {
        Button button;
        this.encodeNonEscapedObject(responseWriter, ALIGN, "", first);
        responseWriter.write("{");
        String for_ = popover.getFor();
        this.encodeClientId(responseWriter, NODE, for_, (UIComponent)popover, true);
        responseWriter.write("}");
        UIComponent forComponent = popover.findComponent(for_);
        if (forComponent != null && forComponent instanceof Button && (button = (Button)forComponent).getOnclick() == null && button.getOnmouseover() == null) {
            logger.warn("Popover [{0}] is *for* button [{1}] but the button does not have an onclick or onmouseover attribute.", new Object[]{popover.getClientKey(), for_});
        }
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, Popover popover, boolean first) throws IOException {
        this.encodeAlign(responseWriter, popover, first);
        first = false;
        this.encodeOverlayHiddenAttributes(facesContext, responseWriter, (UIComponent)popover, first);
    }

    @Override
    protected void encodeZIndex(ResponseWriter responseWriter, Popover popover, Integer zIndex, boolean first) throws IOException {
        this.encodeOverlayZIndex(responseWriter, (UIComponent)popover, zIndex, "Liferay.zIndex.OVERLAY", first);
    }
}

