/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.overlay.internal;

import com.liferay.faces.alloy.render.internal.DelegatingAlloyRendererBase;
import com.liferay.faces.util.component.ComponentUtil;
import com.liferay.faces.util.render.IdResponseWriter;
import com.liferay.faces.util.render.JavaScriptFragment;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public abstract class OverlayRendererBase
extends DelegatingAlloyRendererBase
implements NamingContainer {
    protected static final String Z_INDEX = "zIndex";
    protected static final String CONTENT_BOX_SUFFIX = "_contentBox";
    protected static final String OVERLAY_BODY_SUFFIX = "_overlayBody";

    protected void encodeOverlayDismissible(ResponseWriter responseWriter, UIComponent overlay, String clientKey) throws IOException {
        JavaScriptFragment overlayClientVar = new JavaScriptFragment("Liferay.component('" + clientKey + "')");
        this.encodeFunctionCall(responseWriter, "LFAI.initOverlayDismissible", new Object[]{Character.valueOf('A'), overlayClientVar});
    }

    protected void encodeOverlayHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, UIComponent overlay, boolean first) throws IOException {
        String clientId = overlay.getClientId(facesContext);
        this.encodeClientId(responseWriter, "boundingBox", clientId, first);
        String contentBoxClientId = clientId.concat(CONTENT_BOX_SUFFIX);
        this.encodeClientId(responseWriter, "contentBox", contentBoxClientId, first);
        first = false;
        Map attributes = overlay.getAttributes();
        String headerText = (String)attributes.get("headerText");
        if (headerText != null) {
            headerText = "<span class=\"alloy-overlay-title\">" + headerText + "</span>";
            this.encodeString(responseWriter, "headerContent", headerText, first);
        }
        this.encodeString(responseWriter, "bodyContent", "", first);
        this.encodeWidgetRender(responseWriter, first);
        this.encodeBoolean(responseWriter, "visible", false, first);
    }

    protected void encodeOverlayJavaScriptCustom(ResponseWriter responseWriter, FacesContext facesContext, UIComponent overlay, String clientKey) throws IOException {
        responseWriter.write("A.one('#");
        String clientId = overlay.getClientId(facesContext);
        String escapedBoundingBoxClientId = ComponentUtil.escapeClientId((String)clientId);
        responseWriter.write(escapedBoundingBoxClientId);
        responseWriter.write("').setStyle('display',null);");
        Map attributes = overlay.getAttributes();
        boolean autoShow = (Boolean)attributes.get("autoShow");
        if (autoShow) {
            responseWriter.write("Liferay.component('");
            responseWriter.write(clientKey);
            responseWriter.write("').show();");
        }
    }

    protected void encodeOverlayMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.encodeOverlayMarkupBegin(facesContext, uiComponent, null);
    }

    protected void encodeOverlayMarkupBegin(FacesContext facesContext, UIComponent uiComponent, String contentBoxCSSClasses) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        IdResponseWriter idDelegationResponseWriter = new IdResponseWriter(responseWriter, "div", clientId);
        super.encodeMarkupBegin(facesContext, uiComponent, (ResponseWriter)idDelegationResponseWriter);
        String contentBoxClientId = clientId.concat(CONTENT_BOX_SUFFIX);
        responseWriter.startElement("div", null);
        responseWriter.writeAttribute("id", (Object)contentBoxClientId, null);
        if (contentBoxCSSClasses != null && !contentBoxCSSClasses.equals("")) {
            responseWriter.writeAttribute("class", (Object)contentBoxCSSClasses, null);
        }
        String overlayBodyClientId = clientId.concat(OVERLAY_BODY_SUFFIX);
        responseWriter.startElement("div", null);
        responseWriter.writeAttribute("id", (Object)overlayBodyClientId, null);
    }

    protected void encodeOverlayMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
        responseWriter.endElement("div");
        super.encodeMarkupEnd(facesContext, uiComponent);
    }

    protected void encodeOverlayZIndex(ResponseWriter responseWriter, UIComponent overlay, Integer zIndex, String defaultZIndex, boolean first) throws IOException {
        if (zIndex.equals(Integer.MIN_VALUE)) {
            this.encodeNonEscapedObject(responseWriter, Z_INDEX, defaultZIndex, first);
        } else {
            this.encodeInteger(responseWriter, Z_INDEX, zIndex, first);
        }
    }
}

