/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputfile.internal;

import com.liferay.faces.alloy.component.inputfile.FileUploadEvent;
import com.liferay.faces.alloy.component.inputfile.InputFile;
import com.liferay.faces.alloy.component.inputfile.internal.AjaxParameters;
import com.liferay.faces.alloy.component.inputfile.internal.InputFileDecoder;
import com.liferay.faces.alloy.component.inputfile.internal.InputFileDelegationResponseWriter;
import com.liferay.faces.alloy.component.inputfile.internal.InputFileRendererBase;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.context.map.MultiPartFormData;
import com.liferay.faces.util.factory.FactoryExtensionFinder;
import com.liferay.faces.util.i18n.I18n;
import com.liferay.faces.util.i18n.I18nFactory;
import com.liferay.faces.util.model.UploadedFile;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import com.liferay.faces.util.render.JavaScriptFragment;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.application.ViewHandler;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.event.FacesEvent;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Input", rendererType="com.liferay.faces.alloy.component.inputfile.InputFileRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy", name="alloy.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class InputFileRenderer
extends InputFileRendererBase {
    private static final boolean LIFERAY_FACES_BRIDGE_DETECTED = ProductFactory.getProduct((Product.Name)Product.Name.LIFERAY_FACES_BRIDGE).isDetected();

    @Override
    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String clientId;
        List<UploadedFile> uploadedFiles;
        InputFile inputFile = (InputFile)uiComponent;
        Map<String, List<UploadedFile>> uploadedFileMap = this.getUploadedFileMap(facesContext, inputFile.getLocation());
        if (uploadedFileMap != null && (uploadedFiles = uploadedFileMap.get(clientId = uiComponent.getClientId(facesContext))) != null && uploadedFiles.size() > 0) {
            inputFile.setSubmittedValue(uploadedFiles);
            for (UploadedFile uploadedFile : uploadedFiles) {
                FileUploadEvent fileUploadEvent = new FileUploadEvent(uiComponent, uploadedFile);
                uiComponent.queueEvent((FacesEvent)fileUploadEvent);
            }
        }
    }

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        InputFile inputFile = (InputFile)uiComponent;
        JavaScriptFragment alloyNamespace = new JavaScriptFragment("A");
        JavaScriptFragment contentTypes = new JavaScriptFragment("[]");
        String validContentTypes = inputFile.getContentTypes();
        if (validContentTypes != null) {
            contentTypes = this.toJavaScriptArray(validContentTypes.split(","));
        }
        String clientId = inputFile.getClientId(facesContext);
        Long maxFileSize = inputFile.getMaxFileSize();
        if (maxFileSize == null) {
            maxFileSize = Long.MAX_VALUE;
        }
        if (inputFile.isShowProgress()) {
            String clientVarName = this.getClientVarName(facesContext, inputFile);
            String clientKey = inputFile.getClientKey();
            if (clientKey == null) {
                clientKey = clientVarName;
            }
            UIViewRoot viewRoot = facesContext.getViewRoot();
            Locale locale = viewRoot.getLocale();
            String formClientId = this.getParentFormClientId((UIComponent)inputFile);
            Application application = facesContext.getApplication();
            ViewHandler viewHandler = application.getViewHandler();
            String actionURL = viewHandler.getActionURL(facesContext, viewRoot.getViewId());
            String partialActionURL = facesContext.getExternalContext().encodePartialActionURL(actionURL);
            String namingContainerId = "";
            if (viewRoot instanceof NamingContainer) {
                namingContainerId = viewRoot.getContainerClientId(facesContext);
            }
            AjaxParameters ajaxParameters = new AjaxParameters(inputFile, clientId, formClientId);
            String execute = ajaxParameters.getExecute();
            String render = ajaxParameters.getRender();
            I18n i18n = I18nFactory.getI18nInstance();
            String notStartedMessage = i18n.getMessage(facesContext, locale, "not-started");
            JavaScriptFragment clientComponent = new JavaScriptFragment("Liferay.component('" + clientKey + "')");
            this.encodeFunctionCall(responseWriter, "LFAI.initProgressUploader", new Object[]{alloyNamespace, clientComponent, contentTypes, clientId, formClientId, namingContainerId, inputFile.isAuto(), execute, render, partialActionURL, maxFileSize, notStartedMessage});
        } else if (inputFile.isShowPreview()) {
            this.encodeFunctionCall(responseWriter, "LFAI.initPreviewUploader", new Object[]{alloyNamespace, contentTypes, clientId, maxFileSize});
        }
    }

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        InputFile inputFile = (InputFile)uiComponent;
        if (inputFile.isShowPreview() || inputFile.isShowProgress()) {
            responseWriter.startElement("div", (UIComponent)inputFile);
            String clientId = inputFile.getClientId(facesContext);
            responseWriter.writeAttribute("id", (Object)clientId, "id");
            RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)inputFile, (String[])new String[0]);
            if (inputFile.isShowProgress()) {
                this.encodeProgress(facesContext, responseWriter, inputFile, clientId);
            } else {
                super.encodeMarkupBegin(facesContext, (UIComponent)inputFile);
            }
        } else {
            super.encodeMarkupBegin(facesContext, (UIComponent)inputFile);
        }
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        InputFile inputFile = (InputFile)uiComponent;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (inputFile.isShowProgress()) {
            responseWriter.endElement("div");
        } else if (inputFile.isShowPreview()) {
            this.encodePreview(facesContext, responseWriter, inputFile);
            responseWriter.endElement("div");
        } else {
            InputFileDelegationResponseWriter delegationResponseWriter = new InputFileDelegationResponseWriter(responseWriter, inputFile.isAuto());
            super.encodeMarkupEnd(facesContext, uiComponent, (ResponseWriter)delegationResponseWriter);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        return submittedValue;
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, InputFile inputFile, boolean first) throws IOException {
        this.encodeString(responseWriter, "fileFieldName", inputFile.getClientId(), first);
        first = false;
        String multiple = inputFile.getMultiple();
        boolean multipleFiles = "multiple".equalsIgnoreCase(multiple);
        this.encodeBoolean(responseWriter, "multipleFiles", multipleFiles, first);
        Locale locale = facesContext.getViewRoot().getLocale();
        I18n i18n = I18nFactory.getI18nInstance();
        String chooseFiles = i18n.getMessage(facesContext, locale, "choose-files");
        StringBuilder selectFilesButtonScript = new StringBuilder();
        selectFilesButtonScript.append("A.Node.create(\"<button type='button' class='alloy-button' role='button' aria-label='");
        selectFilesButtonScript.append(chooseFiles);
        selectFilesButtonScript.append("' tabindex='{tabIndex}'>");
        selectFilesButtonScript.append(chooseFiles);
        selectFilesButtonScript.append("</button>\")");
        this.encodeNonEscapedObject(responseWriter, "selectFilesButton", selectFilesButtonScript, first);
    }

    protected void encodePreview(FacesContext facesContext, ResponseWriter responseWriter, InputFile inputFile) throws IOException {
        InputFileDelegationResponseWriter delegationResponseWriter = new InputFileDelegationResponseWriter(responseWriter, inputFile.isAuto());
        super.encodeMarkupEnd(facesContext, (UIComponent)inputFile, (ResponseWriter)delegationResponseWriter);
        Locale locale = facesContext.getViewRoot().getLocale();
        String clientId = inputFile.getClientId(facesContext);
        responseWriter.startElement("div", (UIComponent)inputFile);
        responseWriter.startElement("table", (UIComponent)inputFile);
        responseWriter.writeAttribute("id", (Object)(clientId + "_table"), null);
        responseWriter.writeAttribute("class", (Object)"table table-bordered", null);
        responseWriter.startElement("thead", (UIComponent)inputFile);
        responseWriter.writeAttribute("class", (Object)"table-columns", null);
        responseWriter.startElement("tr", (UIComponent)inputFile);
        responseWriter.startElement("th", (UIComponent)inputFile);
        I18nFactory i18nFactory = (I18nFactory)FactoryExtensionFinder.getFactory(I18nFactory.class);
        I18n i18n = i18nFactory.getI18n();
        String i18nFileName = i18n.getMessage(facesContext, locale, "file-name");
        responseWriter.writeText((Object)i18nFileName, null);
        responseWriter.endElement("th");
        responseWriter.startElement("th", (UIComponent)inputFile);
        String i18nFileType = i18n.getMessage(facesContext, locale, "file-type");
        responseWriter.writeText((Object)i18nFileType, null);
        responseWriter.endElement("th");
        responseWriter.startElement("th", (UIComponent)inputFile);
        String i18nFileSize = i18n.getMessage(facesContext, locale, "file-size");
        responseWriter.writeText((Object)i18nFileSize, null);
        responseWriter.endElement("th");
        responseWriter.endElement("tr");
        responseWriter.endElement("thead");
        responseWriter.startElement("tfoot", (UIComponent)inputFile);
        responseWriter.startElement("tr", (UIComponent)inputFile);
        responseWriter.startElement("td", (UIComponent)inputFile);
        responseWriter.writeAttribute("colspan", (Object)"3", null);
        String i18nNoFilesSelected = i18n.getMessage(facesContext, locale, "no-files-selected");
        responseWriter.writeText((Object)i18nNoFilesSelected, null);
        responseWriter.endElement("td");
        responseWriter.endElement("tr");
        responseWriter.endElement("tfoot");
        responseWriter.startElement("tbody", (UIComponent)inputFile);
        responseWriter.startElement("tr", (UIComponent)inputFile);
        responseWriter.endElement("tr");
        responseWriter.endElement("tbody");
        responseWriter.endElement("table");
        responseWriter.endElement("div");
    }

    protected void encodeProgress(FacesContext facesContext, ResponseWriter responseWriter, InputFile inputFile, String clientId) throws IOException {
        Locale locale = facesContext.getViewRoot().getLocale();
        responseWriter.startElement("div", (UIComponent)inputFile);
        responseWriter.writeAttribute("id", (Object)(clientId + "_selectFilesBox"), null);
        responseWriter.writeAttribute("class", (Object)"select-files-box", null);
        responseWriter.endElement("div");
        I18nFactory i18nFactory = (I18nFactory)FactoryExtensionFinder.getFactory(I18nFactory.class);
        I18n i18n = i18nFactory.getI18n();
        if (!inputFile.isAuto()) {
            responseWriter.startElement("div", (UIComponent)inputFile);
            responseWriter.writeAttribute("id", (Object)(clientId + "_uploadFilesBox"), null);
            responseWriter.writeAttribute("class", (Object)"upload-files-box", null);
            responseWriter.startElement("button", (UIComponent)inputFile);
            responseWriter.writeAttribute("id", (Object)(clientId + "_uploadFilesButton"), null);
            responseWriter.writeAttribute("class", (Object)"alloy-button", null);
            String i18nUploadFiles = i18n.getMessage(facesContext, locale, "upload-files");
            responseWriter.writeText((Object)i18nUploadFiles, null);
            responseWriter.endElement("button");
            responseWriter.endElement("div");
        }
        responseWriter.startElement("div", (UIComponent)inputFile);
        responseWriter.startElement("table", (UIComponent)inputFile);
        responseWriter.writeAttribute("id", (Object)(clientId + "_table"), null);
        responseWriter.writeAttribute("class", (Object)"table table-bordered", null);
        responseWriter.startElement("thead", (UIComponent)inputFile);
        responseWriter.writeAttribute("class", (Object)"table-columns", null);
        responseWriter.startElement("tr", (UIComponent)inputFile);
        responseWriter.startElement("th", (UIComponent)inputFile);
        String i18nFileName = i18n.getMessage(facesContext, locale, "file-name");
        responseWriter.writeText((Object)i18nFileName, null);
        responseWriter.endElement("th");
        responseWriter.startElement("th", (UIComponent)inputFile);
        String i18nFileType = i18n.getMessage(facesContext, locale, "file-type");
        responseWriter.writeText((Object)i18nFileType, null);
        responseWriter.endElement("th");
        responseWriter.startElement("th", (UIComponent)inputFile);
        String i18nFileSize = i18n.getMessage(facesContext, locale, "file-size");
        responseWriter.writeText((Object)i18nFileSize, null);
        responseWriter.endElement("th");
        responseWriter.startElement("th", (UIComponent)inputFile);
        String i18nProgress = i18n.getMessage(facesContext, locale, "progress");
        responseWriter.writeText((Object)i18nProgress, null);
        responseWriter.endElement("th");
        responseWriter.endElement("tr");
        responseWriter.endElement("thead");
        responseWriter.startElement("tfoot", (UIComponent)inputFile);
        responseWriter.startElement("tr", (UIComponent)inputFile);
        responseWriter.startElement("td", (UIComponent)inputFile);
        responseWriter.writeAttribute("colspan", (Object)"4", null);
        String i18nNoFilesSelected = i18n.getMessage(facesContext, locale, "no-files-selected");
        responseWriter.writeText((Object)i18nNoFilesSelected, null);
        responseWriter.endElement("td");
        responseWriter.endElement("tr");
        responseWriter.endElement("tfoot");
        responseWriter.startElement("tbody", (UIComponent)inputFile);
        responseWriter.startElement("tr", (UIComponent)inputFile);
        responseWriter.endElement("tr");
        responseWriter.endElement("tbody");
        responseWriter.endElement("table");
        responseWriter.endElement("div");
    }

    protected String getParentFormClientId(UIComponent uiComponent) {
        String parentFormClientId = null;
        if (uiComponent != null) {
            parentFormClientId = uiComponent instanceof UIForm ? uiComponent.getClientId() : this.getParentFormClientId(uiComponent.getParent());
        }
        return parentFormClientId;
    }

    protected Map<String, List<UploadedFile>> getUploadedFileMap(FacesContext facesContext, String location) {
        Map uploadedFileMap = null;
        if (LIFERAY_FACES_BRIDGE_DETECTED) {
            Map requestAttributeMap = facesContext.getExternalContext().getRequestMap();
            MultiPartFormData multiPartFormData = (MultiPartFormData)requestAttributeMap.get(MultiPartFormData.class.getName());
            if (multiPartFormData != null) {
                uploadedFileMap = multiPartFormData.getUploadedFileMap();
            }
        } else {
            InputFileDecoder inputFileDecoder = this.getWebappInputFileDecoder(facesContext);
            uploadedFileMap = inputFileDecoder.decode(facesContext, location);
        }
        return uploadedFileMap;
    }

    protected JavaScriptFragment toJavaScriptArray(String[] items) {
        StringBuilder buf = new StringBuilder("[");
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("'");
                buf.append(items[i].trim());
                buf.append("'");
            }
        }
        buf.append("]");
        return new JavaScriptFragment(buf.toString());
    }
}

