/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputfile.internal;

import com.liferay.faces.alloy.component.inputfile.internal.InputFileDecoderBase;
import com.liferay.faces.util.factory.FactoryExtensionFinder;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.UploadedFile;
import com.liferay.faces.util.model.UploadedFileFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;

public class InputFileDecoderPartImpl
extends InputFileDecoderBase {
    private static final Logger logger = LoggerFactory.getLogger(InputFileDecoderPartImpl.class);

    @Override
    public Map<String, List<UploadedFile>> decode(FacesContext facesContext, String location) {
        HashMap<String, List<UploadedFile>> uploadedFileMap = null;
        ExternalContext externalContext = facesContext.getExternalContext();
        String uploadedFilesFolder = this.getUploadedFilesFolder(externalContext, location);
        String sessionId = this.getSessionId(externalContext);
        if (sessionId != null) {
            File uploadedFilesPath = new File(uploadedFilesFolder, sessionId = sessionId.replaceAll("[^A-Za-z0-9]", ""));
            if (!uploadedFilesPath.exists()) {
                uploadedFilesPath.mkdirs();
            }
            uploadedFileMap = new HashMap<String, List<UploadedFile>>();
            UploadedFileFactory uploadedFileFactory = (UploadedFileFactory)FactoryExtensionFinder.getFactory(UploadedFileFactory.class);
            try {
                HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
                Collection parts = httpServletRequest.getParts();
                int totalFiles = 0;
                for (Part part : parts) {
                    try {
                        String[] keyValuePairs;
                        ++totalFiles;
                        String fieldName = null;
                        String fileName = null;
                        String safeFileName = null;
                        String contentDispositionHeader = part.getHeader("Content-Disposition");
                        for (String keyValuePair : keyValuePairs = contentDispositionHeader.split(";")) {
                            int equalsPos;
                            String trimmedKeyValuePair = keyValuePair.trim();
                            if (trimmedKeyValuePair.startsWith("filename")) {
                                equalsPos = trimmedKeyValuePair.indexOf("=");
                                fileName = trimmedKeyValuePair.substring(equalsPos + 2, trimmedKeyValuePair.length() - 1);
                                safeFileName = this.stripIllegalCharacters(fileName);
                                continue;
                            }
                            if (!trimmedKeyValuePair.startsWith("name")) continue;
                            equalsPos = trimmedKeyValuePair.indexOf("=");
                            fieldName = trimmedKeyValuePair.substring(equalsPos + 2, trimmedKeyValuePair.length() - 1);
                        }
                        if (fileName == null || fileName.length() <= 0) continue;
                        try {
                            File copiedFile = new File(uploadedFilesPath, safeFileName);
                            String copiedFileAbsolutePath = copiedFile.getAbsolutePath();
                            part.write(copiedFileAbsolutePath);
                            HashMap headersMap = new HashMap();
                            Collection headerNames = part.getHeaderNames();
                            for (String headerName : headerNames) {
                                ArrayList headerValues = new ArrayList(part.getHeaders(headerName));
                                headersMap.put(headerName, headerValues);
                            }
                            String contentType = part.getContentType();
                            String charSet = null;
                            if (contentType != null) {
                                for (String keyValuePair : keyValuePairs = contentType.split(";")) {
                                    String trimmedKeyValuePair = keyValuePair.trim();
                                    if (!trimmedKeyValuePair.startsWith("charset")) continue;
                                    int equalsPos = trimmedKeyValuePair.indexOf("=");
                                    charSet = trimmedKeyValuePair.substring(equalsPos + 2, trimmedKeyValuePair.length() - 1);
                                }
                            }
                            HashMap attributeMap = new HashMap();
                            String id = Long.toString((long)this.hashCode() + System.currentTimeMillis());
                            String message = null;
                            UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(copiedFileAbsolutePath, attributeMap, charSet, contentType, headersMap, id, message, fileName, part.getSize(), UploadedFile.Status.FILE_SAVED);
                            this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                            logger.debug("Received uploaded file fieldName=[{0}] fileName=[{1}]", new Object[]{fieldName, fileName});
                            part.delete();
                        }
                        catch (IOException e) {
                            UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile((Exception)e);
                            this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
                        String fieldName = Integer.toString(totalFiles);
                        this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
                this.addUploadedFile(uploadedFileMap, "unknown", uploadedFile);
            }
        }
        return uploadedFileMap;
    }
}

