/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputfile.internal;

import com.liferay.faces.alloy.component.inputfile.internal.InputFileDecoderBase;
import com.liferay.faces.util.config.WebConfigParam;
import com.liferay.faces.util.factory.FactoryExtensionFinder;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.UploadedFile;
import com.liferay.faces.util.model.UploadedFileFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.InvalidFileNameException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileUtils;

public class InputFileDecoderCommonsImpl
extends InputFileDecoderBase {
    private static final Logger logger = LoggerFactory.getLogger(InputFileDecoderCommonsImpl.class);

    @Override
    public Map<String, List<UploadedFile>> decode(FacesContext facesContext, String location) {
        HashMap<String, List<UploadedFile>> uploadedFileMap;
        block13: {
            uploadedFileMap = null;
            ExternalContext externalContext = facesContext.getExternalContext();
            String uploadedFilesFolder = this.getUploadedFilesFolder(externalContext, location);
            String sessionId = this.getSessionId(externalContext);
            File uploadedFilesPath = new File(uploadedFilesFolder, sessionId = sessionId.replaceAll("[^A-Za-z0-9]", " "));
            if (!uploadedFilesPath.exists()) {
                uploadedFilesPath.mkdirs();
            }
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            diskFileItemFactory.setRepository(uploadedFilesPath);
            diskFileItemFactory.setFileCleaningTracker(null);
            diskFileItemFactory.setSizeThreshold(0);
            int uploadedFileMaxSize = WebConfigParam.UploadedFileMaxSize.getIntegerValue(externalContext);
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
            servletFileUpload.setFileSizeMax((long)uploadedFileMaxSize);
            uploadedFileMap = new HashMap<String, List<UploadedFile>>();
            UploadedFileFactory uploadedFileFactory = (UploadedFileFactory)FactoryExtensionFinder.getFactory(UploadedFileFactory.class);
            try {
                FileItemIterator fileItemIterator = null;
                HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
                fileItemIterator = servletFileUpload.getItemIterator(httpServletRequest);
                if (fileItemIterator == null) break block13;
                int totalFiles = 0;
                while (fileItemIterator.hasNext()) {
                    try {
                        ++totalFiles;
                        FileItemStream fieldStream = fileItemIterator.next();
                        String fieldName = fieldStream.getFieldName();
                        String contentType = fieldStream.getContentType();
                        boolean formField = fieldStream.isFormField();
                        String fileName = null;
                        try {
                            fileName = fieldStream.getName();
                        }
                        catch (InvalidFileNameException e) {
                            fileName = e.getName();
                        }
                        DiskFileItem diskFileItem = (DiskFileItem)diskFileItemFactory.createItem(fieldName, contentType, formField, fileName);
                        Streams.copy((InputStream)fieldStream.openStream(), (OutputStream)diskFileItem.getOutputStream(), (boolean)true);
                        if (diskFileItem.isFormField()) continue;
                        File tempFile = diskFileItem.getStoreLocation();
                        if (tempFile.exists()) {
                            Iterator headerNameItr;
                            String tempFileName = tempFile.getName();
                            String tempFileAbsolutePath = tempFile.getAbsolutePath();
                            String copiedFileName = this.stripIllegalCharacters(fileName);
                            String copiedFileAbsolutePath = tempFileAbsolutePath.replace(tempFileName, copiedFileName);
                            File copiedFile = new File(copiedFileAbsolutePath);
                            FileUtils.copyFile((File)tempFile, (File)copiedFile);
                            HashMap headersMap = new HashMap();
                            FileItemHeaders fileItemHeaders = fieldStream.getHeaders();
                            if (fileItemHeaders != null && (headerNameItr = fileItemHeaders.getHeaderNames()) != null) {
                                while (headerNameItr.hasNext()) {
                                    String headerName = (String)headerNameItr.next();
                                    Iterator headerValuesItr = fileItemHeaders.getHeaders(headerName);
                                    ArrayList<String> headerValues = new ArrayList<String>();
                                    if (headerValuesItr != null) {
                                        while (headerValuesItr.hasNext()) {
                                            String headerValue = (String)headerValuesItr.next();
                                            headerValues.add(headerValue);
                                        }
                                    }
                                    headersMap.put(headerName, headerValues);
                                }
                            }
                            HashMap attributeMap = new HashMap();
                            String id = Long.toString((long)this.hashCode() + System.currentTimeMillis());
                            String message = null;
                            UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(copiedFileAbsolutePath, attributeMap, diskFileItem.getCharSet(), diskFileItem.getContentType(), headersMap, id, message, fileName, diskFileItem.getSize(), UploadedFile.Status.FILE_SAVED);
                            this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                            logger.debug("Received uploaded file fieldName=[{0}] fileName=[{1}]", new Object[]{fieldName, fileName});
                            continue;
                        }
                        if (fileName == null || fileName.trim().length() <= 0) continue;
                        IOException e = new IOException("Failed to copy the stream of uploaded file=[" + fileName + "] to a temporary file (possibly a zero-length uploaded file)");
                        UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile((Exception)e);
                        this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
                        String fieldName = Integer.toString(totalFiles);
                        this.addUploadedFile(uploadedFileMap, fieldName, uploadedFile);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
                this.addUploadedFile(uploadedFileMap, "unknown", uploadedFile);
            }
        }
        return uploadedFileMap;
    }
}

