/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputfile.internal;

import com.liferay.faces.alloy.component.inputfile.InputFile;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;

public class AjaxParameters {
    private static final Logger logger = LoggerFactory.getLogger(AjaxParameters.class);
    private String execute;
    private String render;

    public AjaxParameters(InputFile inputFile, String clientId, String formClientId) {
        this.execute = clientId.concat(" ").concat(clientId);
        this.render = "";
        Map clientBehaviorMap = inputFile.getClientBehaviors();
        List clientBehaviors = (List)clientBehaviorMap.get(inputFile.getDefaultEventName());
        for (ClientBehavior clientBehavior : clientBehaviors) {
            Collection renderIds;
            if (!(clientBehavior instanceof AjaxBehavior)) continue;
            AjaxBehavior ajaxBehavior = (AjaxBehavior)clientBehavior;
            Collection executeIds = ajaxBehavior.getExecute();
            if (executeIds != null && executeIds.size() > 0) {
                boolean foundAllKeyword = false;
                boolean foundNoneKeyword = false;
                StringBuilder buf = new StringBuilder(clientId);
                for (String executeId : executeIds) {
                    if ("@all".equals(executeId)) {
                        foundAllKeyword = true;
                        break;
                    }
                    if ("@none".equals(executeId)) {
                        foundNoneKeyword = true;
                        this.execute = "";
                        break;
                    }
                    if (executeId.length() <= 0) continue;
                    buf.append(" ");
                    buf.append(executeId);
                }
                if (!foundNoneKeyword) {
                    if (foundAllKeyword) {
                        this.execute = "@all";
                    } else {
                        String[] executeIdArray;
                        this.execute = buf.toString();
                        this.execute = this.execute.replace("@form", formClientId);
                        this.execute = this.execute.replace("@this", clientId);
                        boolean foundClientId = false;
                        for (String executeId : executeIdArray = this.execute.split(" ")) {
                            if (!clientId.equals(executeId)) continue;
                            foundClientId = true;
                            break;
                        }
                        if (!foundClientId) {
                            this.execute = clientId.concat(" ").concat(this.execute);
                        }
                    }
                }
            }
            if ((renderIds = ajaxBehavior.getRender()) == null || renderIds.size() <= 0) continue;
            boolean first = true;
            boolean foundAllKeyword = false;
            boolean foundNoneKeyword = false;
            StringBuilder buf = new StringBuilder();
            for (String renderId : renderIds) {
                if ("@all".equals(renderId)) {
                    foundAllKeyword = true;
                    break;
                }
                if ("@none".equals(renderId)) {
                    foundNoneKeyword = true;
                    this.render = "";
                    break;
                }
                if (renderId.length() <= 0) continue;
                if (first) {
                    first = false;
                } else {
                    buf.append(" ");
                }
                if (renderId.startsWith("@")) {
                    buf.append(renderId);
                    continue;
                }
                UIComponent renderComponent = inputFile.findComponent(renderId);
                if (renderComponent != null) {
                    String renderComponentClientId = renderComponent.getClientId();
                    buf.append(renderComponentClientId);
                    continue;
                }
                logger.error("Unable to find component renderId=[{0}]", new Object[]{renderId});
            }
            if (foundNoneKeyword) continue;
            if (foundAllKeyword) {
                this.render = "@all";
                continue;
            }
            this.render = buf.toString();
            this.render = this.render.replace("@form", formClientId);
            this.render = this.render.replace("@this", clientId);
        }
    }

    public String getExecute() {
        return this.execute;
    }

    public String getRender() {
        return this.render;
    }
}

