/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputfile;

import com.liferay.faces.alloy.component.inputfile.FileUploadEvent;
import com.liferay.faces.alloy.component.inputfile.InputFileBase;
import com.liferay.faces.util.i18n.I18n;
import com.liferay.faces.util.i18n.I18nFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.UploadedFile;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.el.MethodExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.FacesComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;

@FacesComponent(value="com.liferay.faces.alloy.component.inputfile.InputFile")
public class InputFile
extends InputFileBase {
    private static final Logger logger = LoggerFactory.getLogger(InputFile.class);

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            MethodExpression methodExpression = this.getFileUploadListener();
            if (methodExpression != null && facesEvent instanceof FileUploadEvent) {
                methodExpression.invoke(facesContext.getELContext(), new Object[]{facesEvent});
            }
        }
        catch (Exception e) {
            throw new AbortProcessingException((Throwable)e);
        }
    }

    protected void validateValue(FacesContext facesContext, Object value) {
        this.setValid(true);
        Long maxFileSize = this.getMaxFileSize();
        String contentTypeSet = this.getContentTypes();
        if (maxFileSize != null || contentTypeSet != null) {
            Locale locale = facesContext.getViewRoot().getLocale();
            I18n i18n = I18nFactory.getI18nInstance();
            String clientId = this.getClientId(facesContext);
            List uploadedFiles = (List)value;
            for (UploadedFile uploadedFile : uploadedFiles) {
                String contentType;
                if (maxFileSize != null && maxFileSize >= 0L && uploadedFile.getSize() > maxFileSize) {
                    String errorMessage = i18n.getMessage(facesContext, locale, "file-x-is-y-bytes-but-may-not-exceed-z-bytes", new Object[]{uploadedFile.getName(), uploadedFile.getSize(), maxFileSize});
                    this.handleInvalidFile(facesContext, clientId, uploadedFile, errorMessage);
                }
                if ((contentType = uploadedFile.getContentType()) != null && (contentTypeSet == null || contentTypeSet.contains(contentType))) continue;
                String errorMessage = i18n.getMessage(facesContext, locale, "file-x-has-an-invalid-content-type-y", new Object[]{uploadedFile.getName(), contentType});
                this.handleInvalidFile(facesContext, clientId, uploadedFile, errorMessage);
            }
        }
    }

    private void handleInvalidFile(FacesContext facesContext, String clientId, UploadedFile uploadedFile, String errorMessage) {
        facesContext.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, errorMessage));
        this.setValid(false);
        try {
            uploadedFile.delete();
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }
}

