/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputdatetime.internal;

import com.liferay.faces.alloy.component.button.Button;
import com.liferay.faces.alloy.component.icon.Icon;
import com.liferay.faces.alloy.component.inputdatetime.InputDateTime;
import com.liferay.faces.alloy.component.inputdatetime.internal.InputDateTimeRendererBase;
import com.liferay.faces.alloy.component.inputdatetime.internal.InputDateTimeResponseWriter;
import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.client.BrowserSnifferFactory;
import com.liferay.faces.util.component.ClientComponent;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.helper.StringHelper;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public abstract class InputDateTimeRenderer
extends InputDateTimeRendererBase {
    protected static final String INPUT_SUFFIX = "_input";
    protected static final String NODE_EVENT_SIMULATE = "node-event-simulate";
    protected static final String VALUE_CHANGE = "valueChange";
    private static final String BOUNDING_BOX_SUFFIX = "_boundingBox";
    private static final String BUTTON_ON_CLICK_EVENT = "var input=document.getElementById('{0}');input.focus();input.click();";
    private static final String BUTTON_SUFFIX = "_button";
    private static final String CONTENT_BOX_SUFFIX = "_contentBox";

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        responseWriter.startElement("div", uiComponent);
        responseWriter.writeAttribute("id", (Object)clientId, "id");
        RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)((Styleable)uiComponent), (String[])new String[0]);
        String inputClientId = clientId.concat(INPUT_SUFFIX);
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        InputDateTime inputDateTime = (InputDateTime)uiComponent;
        InputDateTimeResponseWriter inputDateTimeResponseWriter = this.getInputDateTimeResponseWriter(responseWriter, inputClientId, this.isNative(browserSniffer, inputDateTime));
        super.encodeMarkupBegin(facesContext, uiComponent, (ResponseWriter)inputDateTimeResponseWriter);
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        String inputClientId = clientId.concat(INPUT_SUFFIX);
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        InputDateTime inputDateTime = (InputDateTime)uiComponent;
        InputDateTimeResponseWriter inputDateTimeResponseWriter = this.getInputDateTimeResponseWriter(responseWriter, inputClientId, this.isNative(browserSniffer, inputDateTime));
        super.encodeMarkupEnd(facesContext, uiComponent, (ResponseWriter)inputDateTimeResponseWriter);
        boolean disabled = inputDateTime.isDisabled();
        String showOn = inputDateTime.getShowOn();
        if (("both".equals(showOn) || "button".equals(showOn)) && !this.isNative(browserSniffer, inputDateTime)) {
            ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            Application application = applicationFactory.getApplication();
            Icon icon = (Icon)application.createComponent("com.liferay.faces.alloy.component.icon.Icon");
            String buttonIconName = this.getButtonIconName();
            icon.setName(buttonIconName);
            Button button = (Button)application.createComponent("com.liferay.faces.alloy.component.button.Button");
            List buttonChildren = button.getChildren();
            buttonChildren.add(icon);
            button.setDisabled(disabled);
            if (!disabled) {
                if ("button".equals(showOn)) {
                    String buttonClientId = this.getButtonClientId(facesContext, inputDateTime);
                    button.setId(buttonClientId);
                } else {
                    String onClick = BUTTON_ON_CLICK_EVENT.replace("{0}", inputClientId);
                    button.setOnclick(onClick);
                }
            }
            button.encodeAll(facesContext);
        }
        if (!disabled) {
            responseWriter.startElement("div", uiComponent);
            String boundingBoxClientId = clientId.concat(BOUNDING_BOX_SUFFIX);
            responseWriter.writeAttribute("id", (Object)boundingBoxClientId, null);
            responseWriter.startElement("div", uiComponent);
            String contentBoxClientId = clientId.concat(CONTENT_BOX_SUFFIX);
            responseWriter.writeAttribute("id", (Object)contentBoxClientId, null);
            responseWriter.endElement("div");
            responseWriter.endElement("div");
        }
        responseWriter.endElement("div");
    }

    @Override
    public String getYUIConfig(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uiComponent) throws IOException {
        InputDateTime inputDateTime = (InputDateTime)uiComponent;
        Locale locale = inputDateTime.getObjectAsLocale(inputDateTime.getLocale(facesContext));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{lang:");
        stringBuilder.append("'");
        String localeString = locale.toString().replaceAll("_", "-");
        stringBuilder.append(localeString);
        stringBuilder.append("'}");
        return stringBuilder.toString();
    }

    @Override
    public boolean isSandboxed(FacesContext facesContext, UIComponent uiComponent) {
        UIViewRoot viewRoot;
        Locale viewRootLocale;
        InputDateTime inputDateTime = (InputDateTime)uiComponent;
        Locale locale = inputDateTime.getObjectAsLocale(inputDateTime.getLocale(facesContext));
        return !locale.equals(viewRootLocale = (viewRoot = facesContext.getViewRoot()).getLocale());
    }

    protected abstract String getButtonIconName();

    protected abstract InputDateTimeResponseWriter getInputDateTimeResponseWriter(ResponseWriter var1, String var2, boolean var3);

    protected void encodeHiddenAttributesInputDateTime(FacesContext facesContext, ResponseWriter responseWriter, InputDateTime inputDateTime, boolean first) throws IOException {
        String triggerClientId;
        this.encodePopover(facesContext, responseWriter, inputDateTime, first);
        first = false;
        String showOn = inputDateTime.getShowOn();
        if ("button".equals(showOn)) {
            triggerClientId = this.getButtonClientId(facesContext, inputDateTime);
        } else {
            String clientId = inputDateTime.getClientId(facesContext);
            triggerClientId = clientId.concat(INPUT_SUFFIX);
        }
        this.encodeClientId(responseWriter, "trigger", triggerClientId, first);
        first = false;
    }

    protected void encodePopover(FacesContext facesContext, ResponseWriter responseWriter, InputDateTime inputDateTime, boolean first) throws IOException {
        this.encodeNonEscapedObject(responseWriter, "popover", "", first);
        responseWriter.write("{");
        Integer zIndex = inputDateTime.getzIndex();
        String zIndexString = zIndex != null ? zIndex.toString() : "Liferay.zIndex.TOOLTIP";
        boolean popoverFirst = true;
        this.encodeNonEscapedObject(responseWriter, "zIndex", zIndexString, popoverFirst);
        popoverFirst = false;
        String clientId = inputDateTime.getClientId(facesContext);
        String boundingBoxClientId = clientId.concat(BOUNDING_BOX_SUFFIX);
        this.encodeClientId(responseWriter, "boundingBox", boundingBoxClientId, popoverFirst);
        popoverFirst = false;
        String contentBoxClientId = clientId.concat(CONTENT_BOX_SUFFIX);
        this.encodeClientId(responseWriter, "contentBox", contentBoxClientId, popoverFirst);
        popoverFirst = false;
        responseWriter.write("}");
    }

    protected String getButtonClientId(FacesContext facesContext, ClientComponent clientComponent) {
        String inputDateClientVarName = this.getClientVarName(facesContext, clientComponent);
        return "_" + inputDateClientVarName + BUTTON_SUFFIX;
    }

    protected String[] getModules(String defaultModule, FacesContext facesContext, UIComponent uiComponent) {
        InputDateTime inputDateTime;
        String[] modules = new String[]{defaultModule};
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        if (this.isNative(browserSniffer, inputDateTime = (InputDateTime)uiComponent)) {
            modules[0] = defaultModule.concat("-native");
        } else {
            Map clientBehaviorMap = inputDateTime.getClientBehaviors();
            List valueChangeClientBehaviors = (List)clientBehaviorMap.get(VALUE_CHANGE);
            if (valueChangeClientBehaviors != null && !valueChangeClientBehaviors.isEmpty()) {
                modules = StringHelper.append((String[])modules, (String[])new String[]{NODE_EVENT_SIMULATE});
            }
        }
        return modules;
    }

    protected boolean isNative(BrowserSniffer browserSniffer, InputDateTime inputDateTime) {
        return browserSniffer.isMobile() && inputDateTime.isNativeWhenMobile();
    }
}

