/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputdate.internal;

import com.liferay.faces.alloy.component.inputdate.InputDate;
import com.liferay.faces.alloy.component.inputdate.internal.InputDateRendererBase;
import com.liferay.faces.alloy.component.inputdate.internal.InputDateResponseWriter;
import com.liferay.faces.alloy.component.inputdatetime.internal.InputDateTimeResponseWriter;
import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.client.BrowserSnifferFactory;
import com.liferay.faces.util.component.ComponentUtil;
import com.liferay.faces.util.helper.StringHelper;
import com.liferay.faces.util.render.JavaScriptFragment;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Input", rendererType="com.liferay.faces.alloy.component.inputdate.InputDateRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy", name="alloy.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class InputDateRenderer
extends InputDateRendererBase {
    private static final String REGEX_TOKEN = "\\{0\\}";

    protected static String getMaskFromDatePattern(String datePattern) {
        String mask = datePattern;
        mask = mask.replaceAll("%", "%%");
        mask = mask.replaceAll("\n", "%n");
        mask = mask.replaceAll("\t", "%t");
        mask = mask.replaceAll("yyyy", "%Y");
        mask = mask.replaceAll("yy", "%y");
        mask = mask.replaceAll("MMMMM", "%B");
        mask = mask.replaceAll("MMM", "%b");
        mask = mask.replaceAll("MM", "%m");
        mask = mask.replaceAll("M", "%m");
        mask = mask.replaceAll("dd", REGEX_TOKEN);
        mask = mask.replaceAll("d", "%e");
        mask = mask.replaceAll(REGEX_TOKEN, "%d");
        mask = mask.replaceAll("DDD", "%j");
        mask = mask.replaceAll("FF", "%u");
        mask = mask.replaceAll("EEEE", "%A");
        mask = mask.replaceAll("EEE", "%a");
        return mask;
    }

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        InputDate inputDate = (InputDate)uiComponent;
        String showOn = inputDate.getShowOn();
        if (this.isNative(browserSniffer, inputDate) || "button".equals(showOn)) {
            String clientVarName = this.getClientVarName(facesContext, inputDate);
            String clientKey = inputDate.getClientKey();
            if (clientKey == null) {
                clientKey = clientVarName;
            }
            JavaScriptFragment liferayComponent = new JavaScriptFragment("Liferay.component('" + clientKey + "')");
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            if (this.isNative(browserSniffer, inputDate)) {
                String clientId = uiComponent.getClientId(facesContext);
                String inputClientId = clientId.concat("_input");
                Object maxDateObject = inputDate.getMaxDate();
                Object minDateObject = inputDate.getMinDate();
                String maxDateString = null;
                String minDateString = null;
                if (maxDateObject != null || minDateObject != null) {
                    String datePattern = inputDate.getPattern();
                    String timeZoneString = inputDate.getTimeZone();
                    TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                    if (maxDateObject != null) {
                        Date maxDate = inputDate.getObjectAsDate(maxDateObject, datePattern, timeZone);
                        maxDateString = simpleDateFormat.format(maxDate);
                    }
                    if (maxDateObject != null) {
                        Date minDate = inputDate.getObjectAsDate(minDateObject, datePattern, timeZone);
                        minDateString = simpleDateFormat.format(minDate);
                    }
                }
                this.encodeFunctionCall(responseWriter, "LFAI.initDateTimePickerMobile", new Object[]{liferayComponent, inputClientId, maxDateString, minDateString});
            } else if ("button".equals(showOn)) {
                String clientId = inputDate.getClientId(facesContext);
                String inputClientId = clientId.concat("_input");
                String escapedInputClientId = ComponentUtil.escapeClientId((String)inputClientId);
                this.encodeFunctionCall(responseWriter, "LFAI.initDatePickerShowOnButton", new Object[]{Character.valueOf('A'), escapedInputClientId, liferayComponent});
            }
        }
    }

    @Override
    public String getAlloyClassName(FacesContext facesContext, UIComponent uiComponent) {
        InputDate inputDate;
        String alloyClassName = super.getAlloyClassName(facesContext, uiComponent);
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        if (this.isNative(browserSniffer, inputDate = (InputDate)uiComponent)) {
            alloyClassName = alloyClassName.concat("Native");
        }
        return alloyClassName;
    }

    @Override
    public String getButtonIconName() {
        return "calendar";
    }

    @Override
    public String[] getModules(FacesContext facesContext, UIComponent uiComponent) {
        String[] modules = this.getModules(MODULES[0], facesContext, uiComponent);
        InputDate inputDate = (InputDate)uiComponent;
        String showOn = inputDate.getShowOn();
        if ("button".equals(showOn)) {
            modules = StringHelper.append((String[])modules, (String[])new String[]{"aui-datatype-date-parse"});
        }
        return modules;
    }

    protected void encodeCalendar(FacesContext facesContext, ResponseWriter responseWriter, InputDate inputDate, boolean first) throws IOException {
        boolean valueChangeClientBehaviorsNotEmpty;
        Object minDateObject;
        boolean calendarFirst = true;
        this.encodeNonEscapedObject(responseWriter, "calendar", "", first);
        responseWriter.write("{");
        Object maxDateObject = inputDate.getMaxDate();
        if (maxDateObject != null) {
            this.encodeDate(responseWriter, inputDate, "maximumDate", maxDateObject, calendarFirst);
            calendarFirst = false;
        }
        if ((minDateObject = inputDate.getMinDate()) != null) {
            this.encodeDate(responseWriter, inputDate, "minimumDate", minDateObject, calendarFirst);
            calendarFirst = false;
        }
        String showOn = inputDate.getShowOn();
        boolean showOnButton = "button".equals(showOn);
        Map clientBehaviorMap = inputDate.getClientBehaviors();
        List valueChangeClientBehaviors = (List)clientBehaviorMap.get("valueChange");
        boolean bl = valueChangeClientBehaviorsNotEmpty = valueChangeClientBehaviors != null && !valueChangeClientBehaviors.isEmpty();
        if (showOnButton || valueChangeClientBehaviorsNotEmpty) {
            this.encodeNonEscapedObject(responseWriter, "on", "", calendarFirst);
            responseWriter.write("{");
            this.encodeNonEscapedObject(responseWriter, "dateClick", "", true);
            responseWriter.write("function(event){");
            String clientId = inputDate.getClientId(facesContext);
            String inputClientId = clientId.concat("_input");
            String escapedInputClientId = ComponentUtil.escapeClientId((String)inputClientId);
            JavaScriptFragment selectable = new JavaScriptFragment("this._canBeSelected(event.date)");
            JavaScriptFragment date = null;
            if (showOnButton) {
                String datePattern = inputDate.getPattern();
                String mask = InputDateRenderer.getMaskFromDatePattern(datePattern);
                String escapedMask = RendererUtil.escapeJavaScript((String)mask);
                date = new JavaScriptFragment("A.Date.format(event.date,{format:'".concat(escapedMask).concat("'})"));
            }
            this.encodeFunctionCall(responseWriter, "LFAI.inputDateTimePickerSelect", new Object[]{Character.valueOf('A'), escapedInputClientId, selectable, date, valueChangeClientBehaviorsNotEmpty});
            responseWriter.append((CharSequence)";}");
            responseWriter.write("}");
            calendarFirst = false;
        }
        responseWriter.write("}");
    }

    protected void encodeDate(ResponseWriter responseWriter, InputDate inputDate, String attributeName, Object dateObject, boolean first) throws IOException {
        String datePattern = inputDate.getPattern();
        String timeZoneString = inputDate.getTimeZone();
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        Date date = inputDate.getObjectAsDate(dateObject, datePattern, timeZone);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'new Date'(yyyy,M-1,d,0,0,0,0)");
        simpleDateFormat.setTimeZone(timeZone);
        String dateString = simpleDateFormat.format(date);
        this.encodeNonEscapedObject(responseWriter, attributeName, dateString, first);
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, InputDate inputDate, boolean first) throws IOException {
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        if (!this.isNative(browserSniffer, inputDate)) {
            this.encodeCalendar(facesContext, responseWriter, inputDate, first);
            first = false;
            this.encodeHiddenAttributesInputDateTime(facesContext, responseWriter, inputDate, first);
            first = false;
        }
    }

    @Override
    protected void encodeMask(ResponseWriter responseWriter, InputDate inputDate, String datePattern, boolean first) throws IOException {
        String datePatternMask = InputDateRenderer.getMaskFromDatePattern(datePattern);
        super.encodeMask(responseWriter, inputDate, datePatternMask, first);
    }

    @Override
    protected InputDateTimeResponseWriter getInputDateTimeResponseWriter(ResponseWriter responseWriter, String inputClientId, boolean nativeInputDate) {
        return new InputDateResponseWriter(responseWriter, inputClientId, nativeInputDate);
    }
}

