/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.inputdate;

import com.liferay.faces.alloy.component.inputdate.InputDateBase;
import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.client.BrowserSnifferFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.FacesComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

@FacesComponent(value="com.liferay.faces.alloy.component.inputdate.InputDate")
public class InputDate
extends InputDateBase {
    public static final String DEFAULT_HTML5_DATE_PATTERN = "yyyy-MM-dd";

    @Override
    public String getPattern() {
        String datePattern;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        BrowserSniffer browserSniffer = BrowserSnifferFactory.getBrowserSnifferInstance((ExternalContext)facesContext.getExternalContext());
        if (browserSniffer.isMobile() && this.isNativeWhenMobile()) {
            datePattern = DEFAULT_HTML5_DATE_PATTERN;
        } else {
            datePattern = super.getPattern();
            if (datePattern == null) {
                Object locale = this.getLocale();
                datePattern = this.getDefaultDatePattern(locale);
            }
        }
        return datePattern;
    }

    protected void validateValue(FacesContext facesContext, Object newValue) {
        super.validateValue(facesContext, newValue);
        if (this.isValid() && newValue != null) {
            String datePattern = this.getPattern();
            Object minDateObject = this.getMinDate();
            String timeZoneString = this.getTimeZone();
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
            Date minDate = this.getObjectAsDate(minDateObject, datePattern, timeZone);
            Object maxDateObject = this.getMaxDate();
            Date maxDate = this.getObjectAsDate(maxDateObject, datePattern, timeZone);
            if (minDate == null && maxDate == null) {
                this.setValid(true);
            } else {
                if (minDate == null) {
                    minDate = new Date(Long.MIN_VALUE);
                } else if (maxDate == null) {
                    maxDate = new Date(Long.MAX_VALUE);
                }
                minDate = this.getDateAtMidnight(minDate, timeZone);
                maxDate = this.getDateAtMidnight(maxDate, timeZone);
                super.validateValue(facesContext, newValue, minDate, maxDate, timeZone);
            }
        }
    }

    private Date getDateAtMidnight(Date date, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private String getDefaultDatePattern(Object componentLocale) {
        Locale locale = this.getObjectAsLocale(componentLocale);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(2, locale);
        return simpleDateFormat.toPattern();
    }
}

