/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.datalist.internal;

import com.liferay.faces.alloy.component.dataitem.DataItem;
import com.liferay.faces.alloy.component.datalist.DataList;
import com.liferay.faces.alloy.component.datalist.internal.DataListRendererBase;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Data", rendererType="com.liferay.faces.alloy.component.datalist.DataListRenderer")
public class DataListRenderer
extends DataListRendererBase {
    private static final String ITEM = "item";
    private static final String DESCRIPTION = "description";
    private static final String ORDERED = "ordered";
    private static final String UNORDERED = "unordered";
    private static final Logger logger = LoggerFactory.getLogger(DataListRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataList dataList = (DataList)uiComponent;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        String type = dataList.getType();
        if (UNORDERED.equals(type)) {
            responseWriter.startElement("ul", uiComponent);
        } else if (ORDERED.equals(type)) {
            responseWriter.startElement("ol", uiComponent);
        } else if (DESCRIPTION.equals(type)) {
            responseWriter.startElement("dl", uiComponent);
        }
        responseWriter.writeAttribute("id", (Object)clientId, "id");
        RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)((Styleable)uiComponent), (String[])new String[0]);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataList dataList = (DataList)uiComponent;
        String type = dataList.getType();
        UIComponent facet = dataList.getFacet(DESCRIPTION);
        String styleClass = dataList.getStyleClass();
        Object value = dataList.getValue();
        String var = dataList.getVar();
        boolean iterateOverDataModel = value != null && var != null;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String itemTag = "li";
        if (DESCRIPTION.equals(type)) {
            itemTag = "dt";
        }
        if (iterateOverDataModel) {
            DataItem prototypeChildDataItem = this.getFirstChildDataItem(dataList);
            if (prototypeChildDataItem == null) {
                logger.warn("Unable to iterate because alloy:dataList does not have an alloy:dataItem child element.");
            } else {
                int rowCount = dataList.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    dataList.setRowIndex(i);
                    responseWriter.startElement(itemTag, (UIComponent)prototypeChildDataItem);
                    RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)prototypeChildDataItem, (String[])new String[0]);
                    prototypeChildDataItem.encodeAll(facesContext);
                    responseWriter.endElement(itemTag);
                    if (facet == null) continue;
                    responseWriter.startElement("dd", uiComponent);
                    responseWriter.writeAttribute("class", (Object)(styleClass + "-" + DESCRIPTION), "class");
                    facet.encodeAll(facesContext);
                    responseWriter.endElement("dd");
                }
                dataList.setRowIndex(-1);
            }
        } else {
            List children = uiComponent.getChildren();
            int childCount = children.size();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (child.isRendered() && child instanceof DataItem) {
                    DataItem childDataItem = (DataItem)child;
                    responseWriter.startElement(itemTag, (UIComponent)childDataItem);
                    RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)childDataItem, (String[])new String[0]);
                    childDataItem.encodeAll(facesContext);
                    responseWriter.endElement(itemTag);
                    continue;
                }
                logger.warn("Unable to render child element of alloy:dataList since it is not alloy:dataItem");
            }
        }
        dataList.setRowIndex(-1);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DataList dataList = (DataList)uiComponent;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String type = dataList.getType();
        if (UNORDERED.equals(type)) {
            responseWriter.endElement("ul");
        } else if (ORDERED.equals(type)) {
            responseWriter.endElement("ol");
        } else if (DESCRIPTION.equals(type)) {
            responseWriter.endElement("dl");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected List<DataItem> getChildDataItems(UIData uiData) {
        ArrayList<DataItem> childDataItems = new ArrayList<DataItem>();
        List children = uiData.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof DataItem)) continue;
            childDataItems.add((DataItem)child);
        }
        return childDataItems;
    }

    protected DataItem getFirstChildDataItem(UIData uiData) {
        DataItem prototypeChildType = null;
        List<DataItem> childDataItems = this.getChildDataItems(uiData);
        if (childDataItems.size() > 0) {
            prototypeChildType = childDataItems.get(0);
        }
        return prototypeChildType;
    }
}

