/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.button.internal;

import com.liferay.faces.alloy.component.button.Button;
import com.liferay.faces.alloy.component.button.SplitButton;
import com.liferay.faces.alloy.component.button.internal.ButtonRendererBase;
import com.liferay.faces.alloy.component.button.internal.ButtonResponseWriter;
import com.liferay.faces.alloy.component.commandbutton.CommandButton;
import com.liferay.faces.alloy.component.commandbutton.SplitCommandButton;
import com.liferay.faces.alloy.component.menu.Menu;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutcomeTargetButton;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;

public abstract class AbstractButtonRenderer
extends ButtonRendererBase {
    private static final String BUTTON = "button";
    private static final String DEFAULT_ONBLUR = "this.className=this.className.replace(' btn-focus','');";
    private static final String DEFAULT_ONFOCUS = "this.className+=' btn-focus';";
    private static final String DEFAULT_BUTTON_CSS_CLASSES = "btn yui3-widget yui3-btn yui3-btn-content";
    private static final String DISABLED_BUTTON_CSS_CLASSES = "btn-disabled disabled";
    private static final String FACES_RUNTIME_SRC = "facesRuntimeSrc";
    private static final String IMAGE = "image";
    private static final String RETURN_FALSE = "return false;";
    static final String ONFOCUS = "onfocus";
    static final String ONBLUR = "onblur";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        if (this.hasMenu(uiComponent)) {
            UIComponent nodeMenuNav = NodeMenuNavFactory.getNodeMenuNav(uiComponent);
            RenderKit renderKit = facesContext.getRenderKit();
            Renderer nodeMenuNavRenderer = renderKit.getRenderer(nodeMenuNav.getFamily(), nodeMenuNav.getRendererType());
            nodeMenuNavRenderer.decode(facesContext, nodeMenuNav);
        } else {
            super.decode(facesContext, uiComponent);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (this.hasMenu(uiComponent)) {
            UIComponent nodeMenuNav = NodeMenuNavFactory.getNodeMenuNav(uiComponent);
            RenderKit renderKit = facesContext.getRenderKit();
            Renderer nodeMenuNavRenderer = renderKit.getRenderer(nodeMenuNav.getFamily(), nodeMenuNav.getRendererType());
            nodeMenuNavRenderer.encodeBegin(facesContext, nodeMenuNav);
        } else {
            String onfocus;
            HtmlOutcomeTargetButton htmlOutcomeTargetButton;
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.startElement(BUTTON, uiComponent);
            Map attributes = uiComponent.getAttributes();
            Boolean autofocus = (Boolean)attributes.get("autofocus");
            if (autofocus != null) {
                responseWriter.writeAttribute("autofocus", (Object)autofocus, "autofocus");
            }
            StringBuilder classNames = new StringBuilder();
            classNames.append(DEFAULT_BUTTON_CSS_CLASSES);
            boolean disabled = (Boolean)attributes.get("disabled");
            if (disabled) {
                classNames.append(" ");
                classNames.append(DISABLED_BUTTON_CSS_CLASSES);
            }
            RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)((Styleable)uiComponent), (String[])new String[]{classNames.toString()});
            responseWriter.writeAttribute("disabled", (Object)disabled, "disabled");
            String type = (String)attributes.get("type");
            responseWriter.writeAttribute("type", (Object)type, "type");
            Boolean delegateOnclick = Boolean.TRUE;
            if (uiComponent instanceof HtmlOutcomeTargetButton && (htmlOutcomeTargetButton = (HtmlOutcomeTargetButton)uiComponent).getOutcome() == null) {
                delegateOnclick = Boolean.FALSE;
                String onclick = htmlOutcomeTargetButton.getOnclick();
                if (onclick != null) {
                    responseWriter.writeAttribute("onclick", (Object)onclick, "onclick");
                }
            }
            if ((onfocus = (String)attributes.get(ONFOCUS)) == null) {
                onfocus = RETURN_FALSE;
            }
            StringBuilder onfocusBuilder = new StringBuilder();
            onfocusBuilder.append(DEFAULT_ONFOCUS);
            onfocusBuilder.append(onfocus);
            responseWriter.writeAttribute(ONFOCUS, (Object)onfocusBuilder.toString(), ONFOCUS);
            String onblur = (String)attributes.get(ONBLUR);
            if (onblur == null) {
                onblur = RETURN_FALSE;
            }
            StringBuilder onblurBuilder = new StringBuilder();
            onblurBuilder.append(DEFAULT_ONBLUR);
            onblurBuilder.append(onblur);
            responseWriter.writeAttribute(ONBLUR, (Object)onblurBuilder.toString(), ONBLUR);
            Object value = attributes.get("value");
            if (value != null) {
                responseWriter.writeAttribute("value", (Object)value.toString(), "value");
            }
            ButtonResponseWriter buttonResponseWriter = new ButtonResponseWriter(responseWriter, delegateOnclick);
            super.encodeBegin(facesContext, uiComponent, (ResponseWriter)buttonResponseWriter);
            facesContext.getAttributes().put(FACES_RUNTIME_SRC, buttonResponseWriter.getSrc());
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (this.hasMenu(uiComponent)) {
            UIComponent nodeMenuNav = NodeMenuNavFactory.getNodeMenuNav(uiComponent);
            RenderKit renderKit = facesContext.getRenderKit();
            Renderer nodeMenuNavRenderer = renderKit.getRenderer(nodeMenuNav.getFamily(), nodeMenuNav.getRendererType());
            nodeMenuNavRenderer.encodeChildren(facesContext, nodeMenuNav);
        } else {
            String value;
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            Map attributes = uiComponent.getAttributes();
            String image = (String)attributes.get(IMAGE);
            if (image != null) {
                String src = (String)facesContext.getAttributes().remove(FACES_RUNTIME_SRC);
                if (src != null) {
                    responseWriter.startElement("img", uiComponent);
                    responseWriter.writeAttribute("src", (Object)src, IMAGE);
                    responseWriter.endElement("img");
                }
            } else if (this.getVisualChildCount(uiComponent) == 0 && (value = (String)attributes.get("value")) != null) {
                responseWriter.writeText((Object)value.toString(), "value");
            }
            super.encodeChildren(facesContext, uiComponent);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (this.hasMenu(uiComponent)) {
            UIComponent nodeMenuNav = NodeMenuNavFactory.getNodeMenuNav(uiComponent);
            RenderKit renderKit = facesContext.getRenderKit();
            Renderer nodeMenuNavRenderer = renderKit.getRenderer(nodeMenuNav.getFamily(), nodeMenuNav.getRendererType());
            nodeMenuNavRenderer.encodeEnd(facesContext, nodeMenuNav);
        } else {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.endElement(BUTTON);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        if (this.hasMenu(uiComponent)) {
            UIComponent nodeMenuNav = NodeMenuNavFactory.getNodeMenuNav(uiComponent);
            RenderKit renderKit = facesContext.getRenderKit();
            Renderer nodeMenuNavRenderer = renderKit.getRenderer(nodeMenuNav.getFamily(), nodeMenuNav.getRendererType());
            return nodeMenuNavRenderer.getConvertedValue(facesContext, nodeMenuNav, submittedValue);
        }
        return super.getConvertedValue(facesContext, uiComponent, submittedValue);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected int getVisualChildCount(UIComponent uiComponent) {
        int uiChildCount = 0;
        List children = uiComponent.getChildren();
        for (UIComponent child : children) {
            if (!this.isVisualComponent(child)) continue;
            ++uiChildCount;
        }
        return uiChildCount;
    }

    protected boolean hasMenu(UIComponent uiComponent) {
        boolean hasMenu = false;
        List children = uiComponent.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof Menu)) continue;
            hasMenu = true;
            break;
        }
        return hasMenu;
    }

    private static final class NodeMenuNavFactory {
        private NodeMenuNavFactory() {
        }

        private static UIComponent getNodeMenuNav(UIComponent uiComponent) {
            String componentName = uiComponent.getClass().getName();
            if (componentName.endsWith("CommandButton")) {
                return new SplitCommandButton((CommandButton)uiComponent);
            }
            return new SplitButton((Button)uiComponent);
        }
    }
}

