/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.autocomplete.internal;

import com.liferay.faces.alloy.component.autocomplete.AutoComplete;
import com.liferay.faces.alloy.component.autocomplete.internal.AutoCompleteFilter;
import com.liferay.faces.alloy.component.autocomplete.internal.AutoCompleteFilterFactoryImpl;
import com.liferay.faces.alloy.component.autocomplete.internal.AutoCompleteInputResponseWriter;
import com.liferay.faces.alloy.component.autocomplete.internal.AutoCompleteRendererBase;
import com.liferay.faces.util.client.Script;
import com.liferay.faces.util.component.ClientComponent;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.helper.StringHelper;
import com.liferay.faces.util.render.BufferedScriptResponseWriter;
import com.liferay.faces.util.render.JavaScriptFragment;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Input", rendererType="com.liferay.faces.alloy.component.autocomplete.AutoCompleteRenderer")
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="liferay-faces-alloy", name="alloy.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class AutoCompleteRenderer
extends AutoCompleteRendererBase {
    private static final String ALLOW_BROWSER_AUTOCOMPLETE = "allowBrowserAutocomplete";
    private static final String AUTOCOMPLETE_FILTERS = "autocomplete-filters";
    private static final String AUTOCOMPLETE_HIGHLIGHTERS = "autocomplete-highlighters";
    private static final String CONTENT_BOX_SUFFIX = "_contentBox";
    private static final String HIDDEN_SUFFIX = "_hidden";
    private static final String INPUT_NODE = "inputNode";
    private static final String INPUT_SUFFIX = "_input";
    private static final String NODE_EVENT_SIMULATE = "node-event-simulate";
    private static final String SOURCE = "source";
    private static final String VALUE_CHANGE = "valueChange";
    private static final String VALUE_CHANGE_SCRIPT = "{select: function(event) {this.get('inputNode').simulate('change');}}";

    @Override
    public void encodeJavaScript(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AutoComplete autoComplete = (AutoComplete)uiComponent;
        if (this.isServerFilteringEnabled(autoComplete) && facesContext.getPartialViewContext().isAjaxRequest()) {
            String clientId;
            String hiddenClientId;
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestParameterMap = externalContext.getRequestParameterMap();
            String query = (String)requestParameterMap.get(hiddenClientId = (clientId = uiComponent.getClientId(facesContext)) + HIDDEN_SUFFIX);
            if (query != null && query.length() > 0) {
                List<String> items = autoComplete.getAllItems(facesContext);
                MethodExpression serverCustomFilter = autoComplete.getServerCustomFilter();
                if (serverCustomFilter != null) {
                    items = this.invokeServerCustomFilter(facesContext.getELContext(), serverCustomFilter, query, items);
                } else {
                    String serverFilterType = autoComplete.getServerFilterType();
                    if (serverFilterType != null) {
                        Locale locale = facesContext.getViewRoot().getLocale();
                        AutoCompleteFilterFactoryImpl autoCompleteFilterFactory = new AutoCompleteFilterFactoryImpl();
                        AutoCompleteFilter autoCompleteFilter = autoCompleteFilterFactory.getAutoCompleteFilter(serverFilterType);
                        if (autoCompleteFilter != null) {
                            boolean caseSensitive = serverFilterType.contains("Case");
                            items = autoCompleteFilter.doFilter(query, items, caseSensitive, locale);
                        } else {
                            throw new IOException(serverFilterType + " is not a valid serverFilterType.");
                        }
                    }
                }
                ClientComponent clientComponent = (ClientComponent)uiComponent;
                String clientVarName = this.getClientVarName(facesContext, clientComponent);
                String clientKey = clientComponent.getClientKey();
                if (clientKey == null) {
                    clientKey = clientVarName;
                }
                JavaScriptFragment liferayComponentJavaScriptFragment = new JavaScriptFragment("Liferay.component('" + clientKey + "')");
                StringBuilder resultArrayStringBuilder = new StringBuilder();
                resultArrayStringBuilder.append("[");
                for (int i = 0; i < items.size(); ++i) {
                    if (i > 0) {
                        resultArrayStringBuilder.append(",");
                    }
                    resultArrayStringBuilder.append("'");
                    resultArrayStringBuilder.append(items.get(i));
                    resultArrayStringBuilder.append("'");
                }
                resultArrayStringBuilder.append("]");
                BufferedScriptResponseWriter bufferedScriptResponseWriter = new BufferedScriptResponseWriter();
                this.encodeFunctionCall((ResponseWriter)bufferedScriptResponseWriter, "LFAI.setAutoCompleteServerResults", new Object[]{liferayComponentJavaScriptFragment, resultArrayStringBuilder, hiddenClientId});
                String[] modules = this.getModules(facesContext, uiComponent);
                this.renderScript(facesContext, bufferedScriptResponseWriter.toString(), modules, Script.ModulesType.ALLOY);
            } else {
                super.encodeJavaScript(facesContext, uiComponent);
            }
        } else {
            super.encodeJavaScript(facesContext, uiComponent);
        }
    }

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (this.isServerFilteringEnabled(uiComponent)) {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            ClientComponent clientComponent = (ClientComponent)uiComponent;
            String clientVarName = this.getClientVarName(facesContext, clientComponent);
            String clientKey = clientComponent.getClientKey();
            if (clientKey == null) {
                clientKey = clientVarName;
            }
            this.encodeLiferayComponentVar(responseWriter, clientVarName, clientKey);
            JavaScriptFragment clientVarNameJSFragment = new JavaScriptFragment(clientVarName);
            String clientId = uiComponent.getClientId(facesContext);
            String hiddenClientId = clientId + HIDDEN_SUFFIX;
            String namingContainerId = null;
            UIViewRoot viewRoot = facesContext.getViewRoot();
            if (viewRoot instanceof NamingContainer) {
                namingContainerId = viewRoot.getContainerClientId(facesContext);
            }
            this.encodeFunctionCall(responseWriter, "LFAI.initAutoCompleteServerMode", new Object[]{clientVarNameJSFragment, hiddenClientId, clientId, namingContainerId});
        }
    }

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (!this.isAjaxFiltering(facesContext, uiComponent)) {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.startElement("div", uiComponent);
            String clientId = uiComponent.getClientId(facesContext);
            responseWriter.writeAttribute("id", (Object)clientId, "id");
            Styleable styleable = (Styleable)uiComponent;
            RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)styleable, (String[])new String[0]);
            AutoCompleteInputResponseWriter autoCompleteInputResponseWriter = new AutoCompleteInputResponseWriter(responseWriter, "input", clientId + INPUT_SUFFIX);
            super.encodeAll(facesContext, uiComponent, (ResponseWriter)autoCompleteInputResponseWriter);
            responseWriter.startElement("div", uiComponent);
            responseWriter.writeAttribute("id", (Object)(clientId + CONTENT_BOX_SUFFIX), null);
            responseWriter.endElement("div");
            if (this.isServerFilteringEnabled(uiComponent)) {
                responseWriter.startElement("input", uiComponent);
                responseWriter.writeAttribute("id", (Object)(clientId + HIDDEN_SUFFIX), null);
                responseWriter.writeAttribute("name", (Object)(clientId + HIDDEN_SUFFIX), null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("value", (Object)"", null);
                responseWriter.endElement("input");
            }
        }
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (!this.isAjaxFiltering(facesContext, uiComponent)) {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.endElement("div");
        }
    }

    @Override
    public String[] getModules(FacesContext facesContext, UIComponent uiComponent) {
        Map clientBehaviorMap;
        List valueChangeClientBehaviors;
        String highlighterType;
        String[] modules = MODULES;
        AutoComplete autoComplete = (AutoComplete)uiComponent;
        String clientFilterType = autoComplete.getClientFilterType();
        String clientCustomFilter = autoComplete.getClientCustomFilter();
        if (!this.isServerFilteringEnabled(autoComplete) && clientFilterType != null && clientFilterType.length() > 0 && clientCustomFilter == null) {
            modules = StringHelper.append((String[])modules, (String[])new String[]{AUTOCOMPLETE_FILTERS});
        }
        if ((highlighterType = autoComplete.getHighlighterType()) != null) {
            modules = StringHelper.append((String[])modules, (String[])new String[]{AUTOCOMPLETE_HIGHLIGHTERS});
        }
        if ((valueChangeClientBehaviors = (List)(clientBehaviorMap = autoComplete.getClientBehaviors()).get(VALUE_CHANGE)) != null && !valueChangeClientBehaviors.isEmpty()) {
            modules = StringHelper.append((String[])modules, (String[])new String[]{NODE_EVENT_SIMULATE});
        }
        return modules;
    }

    @Override
    protected void encodeClientFilterType(ResponseWriter responseWriter, AutoComplete autoComplete, String clientFilterType, boolean first) throws IOException {
        String clientCustomFilter = autoComplete.getClientCustomFilter();
        if (!this.isServerFilteringEnabled(autoComplete) && clientCustomFilter == null) {
            super.encodeResultFilters(responseWriter, autoComplete, clientFilterType, first);
        }
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, AutoComplete autoComplete, boolean first) throws IOException {
        Map clientBehaviorMap;
        List valueChangeClientBehaviors;
        this.encodeWidgetRender(responseWriter, first);
        first = false;
        this.encodeHiddenAttributeSource(facesContext, responseWriter, autoComplete, first);
        first = false;
        String contentBoxClientId = autoComplete.getClientId() + CONTENT_BOX_SUFFIX;
        this.encodeClientId(responseWriter, "contentBox", contentBoxClientId, first);
        first = false;
        String inputClientId = autoComplete.getClientId() + INPUT_SUFFIX;
        this.encodeClientId(responseWriter, INPUT_NODE, inputClientId, first);
        first = false;
        String autocompleteAttr = autoComplete.getAutocomplete();
        if ("on".equals(autocompleteAttr)) {
            this.encodeBoolean(responseWriter, ALLOW_BROWSER_AUTOCOMPLETE, true, first);
            first = false;
        }
        if ((valueChangeClientBehaviors = (List)(clientBehaviorMap = autoComplete.getClientBehaviors()).get(VALUE_CHANGE)) != null && !valueChangeClientBehaviors.isEmpty()) {
            this.encodeNonEscapedObject(responseWriter, "after", VALUE_CHANGE_SCRIPT, first);
            first = false;
        }
    }

    protected void encodeHiddenAttributeSource(FacesContext facesContext, ResponseWriter responseWriter, AutoComplete autoComplete, boolean first) throws IOException {
        if (!this.isServerFilteringEnabled(autoComplete)) {
            this.encodeNonEscapedObject(responseWriter, SOURCE, "", first);
            ArrayList<String> results = new ArrayList<String>();
            results.addAll(autoComplete.getAllItems(facesContext));
            responseWriter.write("[");
            for (int i = 0; i < results.size(); ++i) {
                if (i > 0) {
                    responseWriter.write(",");
                }
                responseWriter.write("'");
                responseWriter.write((String)results.get(i));
                responseWriter.write("'");
            }
            responseWriter.write("]");
        }
    }

    @Override
    protected void encodeQueryDelimiter(ResponseWriter responseWriter, AutoComplete autoComplete, String delimiter, boolean first) throws IOException {
        if (!autoComplete.isListItemRequired()) {
            super.encodeQueryDelimiter(responseWriter, autoComplete, delimiter, first);
        }
    }

    @Override
    protected void encodeResultFilters(ResponseWriter responseWriter, AutoComplete autoComplete, String clientCustomFilter, boolean first) throws IOException {
        if (!this.isServerFilteringEnabled(autoComplete)) {
            this.encodeNonEscapedObject(responseWriter, "resultFilters", clientCustomFilter, first);
        }
    }

    protected List<String> invokeServerCustomFilter(ELContext elContext, MethodExpression methodExpression, String query, List<String> items) {
        Object[] params = new Object[]{query, items};
        return (List)methodExpression.invoke(elContext, params);
    }

    protected boolean isAjaxFiltering(FacesContext facesContext, UIComponent uiComponent) {
        boolean querying = false;
        if (this.isServerFilteringEnabled(uiComponent) || facesContext.getPartialViewContext().isAjaxRequest()) {
            String hiddenClientId;
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestParameterMap = externalContext.getRequestParameterMap();
            String query = (String)requestParameterMap.get(hiddenClientId = uiComponent.getClientId(facesContext) + HIDDEN_SUFFIX);
            querying = query != null && query.length() != 0;
        }
        return querying;
    }

    protected boolean isServerFilteringEnabled(AutoComplete autoComplete) {
        MethodExpression serverCustomFilter = autoComplete.getServerCustomFilter();
        String serverFilterType = autoComplete.getServerFilterType();
        String clientCustomFitler = autoComplete.getClientCustomFilter();
        String clientFilterType = autoComplete.getClientFilterType();
        return serverCustomFilter != null || serverFilterType != null || clientCustomFitler == null && clientFilterType == null;
    }

    protected boolean isServerFilteringEnabled(UIComponent uiComponent) {
        AutoComplete autoComplete = (AutoComplete)uiComponent;
        return this.isServerFilteringEnabled(autoComplete);
    }
}

