/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.autocomplete.internal;

import com.liferay.faces.alloy.component.autocomplete.internal.AutoCompleteFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;

abstract class AutoCompleteFilterWordMatchBaseImpl
implements AutoCompleteFilter {
    private static final Map<PATTERN_KEYS, Pattern> patterns = new EnumMap<PATTERN_KEYS, Pattern>(PATTERN_KEYS.class);
    private static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile("'");
    private static final Pattern WHITESPACE = Pattern.compile("\\s");

    AutoCompleteFilterWordMatchBaseImpl() {
    }

    private static boolean matches(String character, PATTERN_KEYS patternKey) {
        return patterns.get((Object)patternKey).matcher(character).matches();
    }

    protected List<String> getWords(String words) {
        ArrayList<String> wordList = new ArrayList<String>();
        if (words != null && words.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < words.length(); ++i) {
                String character = Character.toString(words.charAt(i));
                if (i + 1 == words.length()) {
                    stringBuilder.append(character);
                    wordList.add(stringBuilder.toString());
                    continue;
                }
                String nextCharacter = Character.toString(words.charAt(i + 1));
                String nextNextCharacter = null;
                if (i + 1 + 1 < words.length()) {
                    nextNextCharacter = Character.toString(words.charAt(i + 1 + 1));
                }
                String prevCharacter = null;
                if (i - 1 >= 0) {
                    prevCharacter = Character.toString(words.charAt(i - 1));
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.CR) && AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.LF)) {
                    stringBuilder.append(character);
                    continue;
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.CR) || AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.LF) || AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.NEWLINE)) {
                    stringBuilder.append(character);
                    wordList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.CR) || AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.LF) || AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.NEWLINE)) {
                    stringBuilder.append(character);
                    wordList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.EXTEND) || AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.FORMAT)) continue;
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.ALETTER) && AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.ALETTER)) {
                    stringBuilder.append(character);
                    continue;
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.ALETTER) && (AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.MIDLETTER) || AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.MIDNUMLET) || SINGLE_QUOTE_PATTERN.matcher(nextCharacter).matches()) && nextNextCharacter != null && AutoCompleteFilterWordMatchBaseImpl.matches(nextNextCharacter, PATTERN_KEYS.ALETTER)) {
                    stringBuilder.append(character);
                    continue;
                }
                if (prevCharacter != null && AutoCompleteFilterWordMatchBaseImpl.matches(prevCharacter, PATTERN_KEYS.ALETTER) && (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.MIDLETTER) || AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.MIDNUMLET) || SINGLE_QUOTE_PATTERN.matcher(character).matches()) && AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.ALETTER)) {
                    stringBuilder.append(character);
                    continue;
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.NUMERIC) && AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.NUMERIC)) {
                    stringBuilder.append(character);
                    continue;
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.ALETTER) && AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.NUMERIC)) {
                    stringBuilder.append(character);
                    continue;
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.NUMERIC) && AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.ALETTER)) {
                    stringBuilder.append(character);
                    continue;
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.NUMERIC) && (AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.MIDNUM) || AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.MIDNUMLET) || SINGLE_QUOTE_PATTERN.matcher(nextCharacter).matches()) && nextNextCharacter != null && AutoCompleteFilterWordMatchBaseImpl.matches(nextNextCharacter, PATTERN_KEYS.NUMERIC)) {
                    stringBuilder.append(character);
                    continue;
                }
                if (prevCharacter != null && AutoCompleteFilterWordMatchBaseImpl.matches(prevCharacter, PATTERN_KEYS.NUMERIC) && (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.MIDNUM) || AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.MIDNUMLET) || SINGLE_QUOTE_PATTERN.matcher(character).matches()) && AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.NUMERIC)) {
                    stringBuilder.append(character);
                    continue;
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.KATAKANA) && AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.KATAKANA)) {
                    stringBuilder.append(character);
                    continue;
                }
                if ((AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.ALETTER) || AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.NUMERIC) || AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.KATAKANA) || AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.EXTENDEDNUMLET)) && AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.EXTENDEDNUMLET)) {
                    stringBuilder.append(character);
                    continue;
                }
                if (AutoCompleteFilterWordMatchBaseImpl.matches(character, PATTERN_KEYS.EXTENDEDNUMLET) && (AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.ALETTER) || AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.NUMERIC) || AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.KATAKANA) || AutoCompleteFilterWordMatchBaseImpl.matches(nextCharacter, PATTERN_KEYS.EXTENDEDNUMLET))) {
                    stringBuilder.append(character);
                    continue;
                }
                stringBuilder.append(character);
                wordList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
        Iterator iterator = wordList.iterator();
        while (iterator.hasNext()) {
            String word = (String)iterator.next();
            if (!WHITESPACE.matcher(word).matches() && !AutoCompleteFilterWordMatchBaseImpl.matches(word, PATTERN_KEYS.PUNCTUATION)) continue;
            iterator.remove();
        }
        return wordList;
    }

    static {
        String path = "META-INF/resources/liferay-faces-alloy/yui/autocomplete/text-data-wordbreak.js";
        InputStream inputStream = AutoCompleteFilterWordMatchBaseImpl.class.getClassLoader().getResourceAsStream(path);
        Scanner scanner = new Scanner(inputStream);
        Pattern beginLinePattern = Pattern.compile("^\\s*[a-z][a-z]*\\s*:\\s[\"']");
        Pattern endLinePattern = Pattern.compile("[\"'],?$");
        int i = 0;
        while (scanner.hasNextLine()) {
            String nextLine = scanner.nextLine();
            if (!beginLinePattern.matcher(nextLine).find()) continue;
            String regex = beginLinePattern.matcher(nextLine).replaceFirst("");
            regex = endLinePattern.matcher(regex).replaceFirst("");
            Pattern pattern = PATTERN_KEYS.PUNCTUATION == PATTERN_KEYS.values()[i] ? Pattern.compile("^" + regex + "$") : Pattern.compile(regex);
            patterns.put(PATTERN_KEYS.values()[i], pattern);
            ++i;
        }
        scanner.close();
    }

    private static enum PATTERN_KEYS {
        ALETTER,
        MIDNUMLET,
        MIDLETTER,
        MIDNUM,
        NUMERIC,
        CR,
        LF,
        NEWLINE,
        EXTEND,
        FORMAT,
        KATAKANA,
        EXTENDEDNUMLET,
        PUNCTUATION;

    }
}

