/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.autocomplete;

import com.liferay.faces.alloy.component.autocomplete.AutoCompleteBase;
import com.liferay.faces.util.i18n.I18n;
import com.liferay.faces.util.i18n.I18nFactory;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

@FacesComponent(value="com.liferay.faces.alloy.component.autocomplete.AutoComplete")
public class AutoComplete
extends AutoCompleteBase
implements ClientBehaviorHolder {
    public final List<String> getAllItems(FacesContext facesContext) {
        ArrayList<String> allItems = new ArrayList<String>();
        List children = this.getChildren();
        for (UIComponent child : children) {
            String item;
            UISelectItems uiSelectItems;
            Object value;
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                Object itemValue = uiSelectItem.getItemValue();
                if (itemValue == null) continue;
                allItems.add(itemValue.toString());
                continue;
            }
            if (!(child instanceof UISelectItems) || (value = (uiSelectItems = (UISelectItems)child).getValue()) == null) continue;
            if (value instanceof SelectItem) {
                SelectItem selectItem = (SelectItem)value;
                Object item2 = selectItem.getValue();
                if (item2 == null) continue;
                allItems.add(item2.toString());
                continue;
            }
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    Object itemValue = Array.get(value, i);
                    item = this.getItemValue(facesContext, uiSelectItems, itemValue);
                    if (item == null) continue;
                    allItems.add(item);
                }
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Iterator<Object> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String item3 = this.getItemValue(facesContext, uiSelectItems, iterator.next());
                    if (item3 == null) continue;
                    allItems.add(item3);
                }
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Object key : map.keySet()) {
                    item = this.getItemValue(facesContext, uiSelectItems, map.get(key));
                    if (item == null) continue;
                    allItems.add(item);
                }
                continue;
            }
            throw new IllegalArgumentException();
        }
        return Collections.unmodifiableList(allItems);
    }

    public String getAutocomplete() {
        return (String)this.getStateHelper().eval((Serializable)HtmlInputText.PropertyKeys.autocomplete, (Object)"off");
    }

    protected void validateValue(FacesContext facesContext, Object newValue) {
        String newValueAsString;
        List<String> unfilteredResults;
        super.validateValue(facesContext, newValue);
        if (this.isListItemRequired() && this.isValid() && !(unfilteredResults = this.getAllItems(facesContext)).contains(newValueAsString = (String)newValue)) {
            FacesMessage facesMessage;
            this.setValid(false);
            String validatorMessage = this.getValidatorMessage();
            if (validatorMessage != null) {
                facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage);
            } else {
                UIViewRoot viewRoot;
                Locale locale;
                I18n i18n = I18nFactory.getI18nInstance();
                String message = i18n.getMessage(facesContext, locale = (viewRoot = facesContext.getViewRoot()).getLocale(), "javax.faces.component.UISelectOne.INVALID");
                if (message != null) {
                    message = MessageFormat.format(message, this.getLabel());
                }
                facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message);
            }
            String clientId = this.getClientId(facesContext);
            facesContext.addMessage(clientId, facesMessage);
        }
    }

    private String getItemValue(FacesContext facesContext, UISelectItems uiSelectItems, Object item) {
        String value = null;
        if (item != null) {
            if (item instanceof SelectItem) {
                SelectItem selectItem = (SelectItem)item;
                Object selectItemValue = selectItem.getValue();
                if (selectItemValue != null) {
                    value = selectItemValue.toString();
                }
            } else {
                Map attributes = uiSelectItems.getAttributes();
                String var = (String)attributes.get("var");
                if (var != null) {
                    ExternalContext externalContext = facesContext.getExternalContext();
                    Map requestMap = externalContext.getRequestMap();
                    requestMap.put(var, item);
                    value = (String)attributes.get("itemValue");
                    requestMap.remove(var);
                } else {
                    value = (String)attributes.get("itemValue");
                }
            }
        }
        return value;
    }
}

