/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.accordion.internal;

import com.liferay.faces.alloy.component.accordion.Accordion;
import com.liferay.faces.alloy.component.accordion.internal.AccordionRendererBase;
import com.liferay.faces.alloy.component.tab.Tab;
import com.liferay.faces.alloy.component.tab.TabUtil;
import com.liferay.faces.util.component.ComponentUtil;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Data", rendererType="com.liferay.faces.alloy.component.accordion.AccordionRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class AccordionRenderer
extends AccordionRendererBase {
    private static final String ANIMATED = "animated";
    private static final String CONTAINER = "container";
    private static final String CONTENT_COLLAPSED_CLASSES = "content toggler-content toggler-content-collapsed";
    private static final String CONTENT_EXPANDED_CLASSES = "content toggler-content toggler-content-expanded";
    private static final String DOT_CONTENT = ".content";
    private static final String DOT_HEADER = ".header";
    private static final String HEADER_COLLAPSED_CLASSES = "header toggler-header toggler-header-collapsed";
    private static final String HEADER_EXPANDED_CLASSES = "header toggler-header toggler-header-expanded";
    private static final String EXPANDED = "expanded";
    private static final String EXPANDED_CHANGE = "expandedChange";
    private static final Logger logger = LoggerFactory.getLogger(AccordionRenderer.class);

    public void decodeClientState(FacesContext facesContext, UIComponent uiComponent) {
        Accordion accordion = (Accordion)uiComponent;
        String hiddenFieldName = accordion.getClientId(facesContext) + "selectedIndex";
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String selectedIndex = (String)requestParameterMap.get(hiddenFieldName);
        if (selectedIndex != null) {
            accordion.setSelectedIndex(IntegerHelper.toInteger((String)selectedIndex, (int)-1));
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Accordion accordion = (Accordion)uiComponent;
        Integer selectedIndex = accordion.getSelectedIndex();
        Object value = accordion.getValue();
        String var = accordion.getVar();
        boolean iterateOverDataModel = value != null && var != null;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (iterateOverDataModel) {
            Tab prototypeChildTab = TabUtil.getFirstChildTab(accordion);
            if (prototypeChildTab != null) {
                int rowCount = accordion.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    accordion.setRowIndex(i);
                    if (!prototypeChildTab.isRendered()) continue;
                    boolean selected = selectedIndex != null && i == selectedIndex;
                    this.encodeHeader(facesContext, responseWriter, uiComponent, prototypeChildTab, selected);
                    this.encodeContent(facesContext, responseWriter, uiComponent, prototypeChildTab, selected);
                }
                accordion.setRowIndex(-1);
            } else {
                logger.warn("Unable to iterate because alloy:accordion does not have an alloy:tab child element.");
            }
        } else {
            List children = uiComponent.getChildren();
            int childCount = children.size();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (child instanceof Tab && child.isRendered()) {
                    Tab childTab = (Tab)child;
                    boolean selected = selectedIndex != null && i == selectedIndex;
                    this.encodeHeader(facesContext, responseWriter, uiComponent, childTab, selected);
                    this.encodeContent(facesContext, responseWriter, uiComponent, childTab, selected);
                    continue;
                }
                logger.warn("Unable to render child element of alloy:accordion since it is not alloy:tab");
            }
        }
        accordion.setRowIndex(-1);
    }

    public void encodeClientState(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uiComponent) throws IOException {
        Accordion accordion = (Accordion)uiComponent;
        responseWriter.startElement("input", (UIComponent)accordion);
        String hiddenFieldName = accordion.getClientId(facesContext) + "selectedIndex";
        responseWriter.writeAttribute("id", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("name", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("value", (Object)accordion.getSelectedIndex(), null);
        responseWriter.endElement("input");
    }

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.write("A.one('");
        String clientId = uiComponent.getClientId(facesContext);
        String escapedClientId = "#" + ComponentUtil.escapeClientId((String)clientId);
        responseWriter.write(escapedClientId);
        responseWriter.write("')._node['style'].display='block';");
        Accordion accordion = (Accordion)uiComponent;
        String clientVarName = this.getClientVarName(facesContext, accordion);
        String clientKey = accordion.getClientKey();
        if (clientKey == null) {
            clientKey = clientVarName;
        }
        this.encodeLiferayComponentVar(responseWriter, clientVarName, clientKey);
        responseWriter.write("var togglers=");
        responseWriter.write(clientVarName);
        responseWriter.write(".items;");
        responseWriter.write("var totalTogglers=togglers.length;");
        responseWriter.write("for(var i=0;i<totalTogglers;i++){");
        StringBuilder behaviorCallback = new StringBuilder();
        behaviorCallback.append("var eventTabIndex=0,togglers=");
        behaviorCallback.append(clientVarName);
        behaviorCallback.append(".items,total=togglers.length,i=0;for(i=0;i<total;i++){if(togglers[i]==event.target){eventTabIndex=i;}};");
        String hiddenFieldId = clientId + "selectedIndex";
        behaviorCallback.append("var hidden=document.getElementById('");
        behaviorCallback.append(hiddenFieldId);
        behaviorCallback.append("');");
        behaviorCallback.append("var prevTabIndex=hidden.value;");
        behaviorCallback.append("if(event.newVal){hidden.value=eventTabIndex;}else if (prevTabIndex==eventTabIndex){hidden.value='';};");
        Map clientBehaviorMap = accordion.getClientBehaviors();
        Collection<String> eventNames = accordion.getEventNames();
        for (String eventName : eventNames) {
            List clientBehaviorsForEvent = (List)clientBehaviorMap.get(eventName);
            if (clientBehaviorsForEvent == null) continue;
            for (ClientBehavior clientBehavior : clientBehaviorsForEvent) {
                ClientBehaviorContext clientBehaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)accordion, (String)eventName, (String)clientId, null);
                String clientBehaviorScript = clientBehavior.getScript(clientBehaviorContext);
                if ("tabExpand".equals(eventName)) {
                    behaviorCallback.append("if(event.newVal){");
                    behaviorCallback.append(clientBehaviorScript);
                    behaviorCallback.append("}");
                    continue;
                }
                if (!"tabCollapse".equals(eventName)) continue;
                behaviorCallback.append("if((!event.newVal)&&(prevTabIndex==eventTabIndex)){");
                behaviorCallback.append(clientBehaviorScript);
                behaviorCallback.append("}");
            }
        }
        this.encodeEventCallback(responseWriter, "togglers[i]", "after", EXPANDED_CHANGE, behaviorCallback.toString());
        responseWriter.write("}");
    }

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", uiComponent);
        responseWriter.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), "id");
        RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)((Styleable)uiComponent), (String[])new String[0]);
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeContent(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uiComponent, Tab tab, boolean selected) throws IOException {
        String tabContentClass;
        responseWriter.startElement("div", (UIComponent)tab);
        String contentClass = CONTENT_COLLAPSED_CLASSES;
        if (selected) {
            contentClass = CONTENT_EXPANDED_CLASSES;
        }
        if ((tabContentClass = tab.getContentClass()) != null) {
            contentClass = contentClass + " " + tabContentClass;
        }
        responseWriter.writeAttribute("class", (Object)contentClass, "styleClass");
        tab.encodeAll(facesContext);
        responseWriter.endElement("div");
    }

    protected void encodeHeader(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uiComponent, Tab tab, boolean selected) throws IOException {
        String tabHeaderClass;
        responseWriter.startElement("div", (UIComponent)tab);
        String headerClass = HEADER_COLLAPSED_CLASSES;
        if (selected) {
            headerClass = HEADER_EXPANDED_CLASSES;
        }
        if ((tabHeaderClass = tab.getHeaderClass()) != null) {
            headerClass = headerClass + " " + tabHeaderClass;
        }
        responseWriter.writeAttribute("class", (Object)headerClass, "styleClass");
        UIComponent headerFacet = tab.getFacet("header");
        if (headerFacet != null) {
            headerFacet.encodeAll(facesContext);
        } else {
            String headerText = tab.getHeaderText();
            if (headerText != null) {
                responseWriter.write(headerText);
            }
        }
        responseWriter.endElement("div");
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, Accordion accordion, boolean first) throws IOException {
        this.encodeWidgetRender(responseWriter, first);
        first = false;
        this.encodeClientId(responseWriter, CONTAINER, accordion.getClientId(facesContext), first);
        this.encodeBoolean(responseWriter, ANIMATED, true, first);
        boolean multiple = accordion.isMultiple();
        this.encodeBoolean(responseWriter, "closeAllOnExpand", !multiple, first);
        this.encodeString(responseWriter, "content", DOT_CONTENT, first);
        this.encodeString(responseWriter, "header", DOT_HEADER, first);
        this.encodeBoolean(responseWriter, EXPANDED, false, first);
    }
}

