/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.client.resource.v2_0;

import com.liferay.headless.commerce.admin.pricing.client.dto.v2_0.PriceListOrderType;
import com.liferay.headless.commerce.admin.pricing.client.http.HttpInvoker;
import com.liferay.headless.commerce.admin.pricing.client.pagination.Page;
import com.liferay.headless.commerce.admin.pricing.client.pagination.Pagination;
import com.liferay.headless.commerce.admin.pricing.client.problem.Problem;
import com.liferay.headless.commerce.admin.pricing.client.serdes.v2_0.PriceListOrderTypeSerDes;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface PriceListOrderTypeResource {
    public static Builder builder() {
        return new Builder();
    }

    public void deletePriceListOrderType(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deletePriceListOrderTypeHttpResponse(Long var1) throws Exception;

    public void deletePriceListOrderTypeBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse deletePriceListOrderTypeBatchHttpResponse(String var1, Object var2) throws Exception;

    public Page<PriceListOrderType> getPriceListByExternalReferenceCodePriceListOrderTypesPage(String var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getPriceListByExternalReferenceCodePriceListOrderTypesPageHttpResponse(String var1, Pagination var2) throws Exception;

    public PriceListOrderType postPriceListByExternalReferenceCodePriceListOrderType(String var1, PriceListOrderType var2) throws Exception;

    public HttpInvoker.HttpResponse postPriceListByExternalReferenceCodePriceListOrderTypeHttpResponse(String var1, PriceListOrderType var2) throws Exception;

    public Page<PriceListOrderType> getPriceListIdPriceListOrderTypesPage(Long var1, String var2, Pagination var3) throws Exception;

    public HttpInvoker.HttpResponse getPriceListIdPriceListOrderTypesPageHttpResponse(Long var1, String var2, Pagination var3) throws Exception;

    public PriceListOrderType postPriceListIdPriceListOrderType(Long var1, PriceListOrderType var2) throws Exception;

    public HttpInvoker.HttpResponse postPriceListIdPriceListOrderTypeHttpResponse(Long var1, PriceListOrderType var2) throws Exception;

    public void postPriceListIdPriceListOrderTypeBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse postPriceListIdPriceListOrderTypeBatchHttpResponse(String var1, Object var2) throws Exception;

    public static class PriceListOrderTypeResourceImpl
    implements PriceListOrderTypeResource {
        private static final Logger _logger = Logger.getLogger(PriceListOrderTypeResource.class.getName());
        private Builder _builder;

        @Override
        public void deletePriceListOrderType(Long priceListOrderTypeId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deletePriceListOrderTypeHttpResponse(priceListOrderTypeId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deletePriceListOrderTypeHttpResponse(Long priceListOrderTypeId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-pricing/v2.0/price-list-order-types/{priceListOrderTypeId}");
            httpInvoker.path("priceListOrderTypeId", priceListOrderTypeId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deletePriceListOrderTypeBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deletePriceListOrderTypeBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deletePriceListOrderTypeBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-pricing/v2.0/price-list-order-types/batch");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Page<PriceListOrderType> getPriceListByExternalReferenceCodePriceListOrderTypesPage(String externalReferenceCode, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getPriceListByExternalReferenceCodePriceListOrderTypesPageHttpResponse(externalReferenceCode, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, PriceListOrderTypeSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getPriceListByExternalReferenceCodePriceListOrderTypesPageHttpResponse(String externalReferenceCode, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-pricing/v2.0/price-lists/by-externalReferenceCode/{externalReferenceCode}/price-list-order-types");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public PriceListOrderType postPriceListByExternalReferenceCodePriceListOrderType(String externalReferenceCode, PriceListOrderType priceListOrderType) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postPriceListByExternalReferenceCodePriceListOrderTypeHttpResponse(externalReferenceCode, priceListOrderType);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return PriceListOrderTypeSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postPriceListByExternalReferenceCodePriceListOrderTypeHttpResponse(String externalReferenceCode, PriceListOrderType priceListOrderType) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(priceListOrderType.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-pricing/v2.0/price-lists/by-externalReferenceCode/{externalReferenceCode}/price-list-order-types");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Page<PriceListOrderType> getPriceListIdPriceListOrderTypesPage(Long id, String search, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getPriceListIdPriceListOrderTypesPageHttpResponse(id, search, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, PriceListOrderTypeSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getPriceListIdPriceListOrderTypesPageHttpResponse(Long id, String search, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (search != null) {
                httpInvoker.parameter("search", String.valueOf(search));
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-pricing/v2.0/price-lists/{id}/price-list-order-types");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public PriceListOrderType postPriceListIdPriceListOrderType(Long id, PriceListOrderType priceListOrderType) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postPriceListIdPriceListOrderTypeHttpResponse(id, priceListOrderType);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return PriceListOrderTypeSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postPriceListIdPriceListOrderTypeHttpResponse(Long id, PriceListOrderType priceListOrderType) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(priceListOrderType.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-pricing/v2.0/price-lists/{id}/price-list-order-types");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postPriceListIdPriceListOrderTypeBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postPriceListIdPriceListOrderTypeBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postPriceListIdPriceListOrderTypeBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-pricing/v2.0/price-lists/price-list-order-types/batch");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private PriceListOrderTypeResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public PriceListOrderTypeResource build() {
            return new PriceListOrderTypeResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder endpoint(URL url) {
            return this.endpoint(url.getHost(), url.getPort(), url.getProtocol());
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }
}

