/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.client.serdes.v2_0;

import com.liferay.headless.commerce.admin.pricing.client.dto.v2_0.Product;
import com.liferay.headless.commerce.admin.pricing.client.json.BaseJSONParser;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class ProductSerDes {
    public static Product toDTO(String json) {
        ProductJSONParser productJSONParser = new ProductJSONParser();
        return (Product)productJSONParser.parseToDTO(json);
    }

    public static Product[] toDTOs(String json) {
        ProductJSONParser productJSONParser = new ProductJSONParser();
        return (Product[])productJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Product product) {
        if (product == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (product.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(product.getId());
        }
        if (product.getName() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append(ProductSerDes._toJSON(product.getName()));
        }
        if (product.getSku() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sku\": ");
            sb.append("\"");
            sb.append(ProductSerDes._escape(product.getSku()));
            sb.append("\"");
        }
        if (product.getThumbnail() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"thumbnail\": ");
            sb.append("\"");
            sb.append(ProductSerDes._escape(product.getThumbnail()));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        ProductJSONParser productJSONParser = new ProductJSONParser();
        return productJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Product product) {
        if (product == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (product.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(product.getId()));
        }
        if (product.getName() == null) {
            map.put("name", null);
        } else {
            map.put("name", String.valueOf(product.getName()));
        }
        if (product.getSku() == null) {
            map.put("sku", null);
        } else {
            map.put("sku", String.valueOf(product.getSku()));
        }
        if (product.getThumbnail() == null) {
            map.put("thumbnail", null);
        } else {
            map.put("thumbnail", String.valueOf(product.getThumbnail()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(ProductSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(ProductSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(ProductSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class ProductJSONParser
    extends BaseJSONParser<Product> {
        @Override
        protected Product createDTO() {
            return new Product();
        }

        protected Product[] createDTOArray(int size) {
            return new Product[size];
        }

        @Override
        protected void setField(Product product, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    product.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "name")) {
                if (jsonParserFieldValue != null) {
                    product.setName(ProductSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "sku")) {
                if (jsonParserFieldValue != null) {
                    product.setSku((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "thumbnail")) {
                if (jsonParserFieldValue != null) {
                    product.setThumbnail((String)jsonParserFieldValue);
                }
            } else if (jsonParserFieldName.equals("status")) {
                throw new IllegalArgumentException();
            }
        }
    }
}

