/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.account.exception.NoSuchEntryException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.AccountEntryOrganizationRelService;
import com.liferay.account.service.AccountEntryService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountOrganizationResourceImpl;
import com.liferay.headless.commerce.admin.account.internal.util.v1_0.AccountOrganizationUtil;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountOrganizationResource;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Deprecated
@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-organization.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={AccountOrganizationResource.class})
public class AccountOrganizationResourceImpl
extends BaseAccountOrganizationResourceImpl {
    @Reference
    private AccountEntryOrganizationRelService _accountEntryOrganizationRelService;
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountOrganizationDTOConverter)")
    private DTOConverter<AccountEntryOrganizationRel, AccountOrganization> _accountOrganizationDTOConverter;
    @Reference
    private OrganizationLocalService _organizationLocalService;

    @Override
    public Response deleteAccountByExternalReferenceCodeAccountOrganization(String externalReferenceCode, Long organizationId) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        this._accountEntryOrganizationRelService.deleteAccountEntryOrganizationRel(accountEntry.getAccountEntryId(), organizationId.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountIdAccountOrganization(Long id, Long organizationId) throws Exception {
        this._accountEntryOrganizationRelService.deleteAccountEntryOrganizationRel(id.longValue(), organizationId.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public AccountOrganization getAccountByExternalReferenceCodeAccountOrganization(String externalReferenceCode, Long organizationId) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        AccountEntryOrganizationRel accountEntryOrganizationRel = this._accountEntryOrganizationRelService.getAccountEntryOrganizationRel(accountEntry.getAccountEntryId(), organizationId.longValue());
        return (AccountOrganization)this._accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntryOrganizationRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Page<AccountOrganization> getAccountByExternalReferenceCodeAccountOrganizationsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        List accountEntryOrganizationRels = this._accountEntryOrganizationRelService.getAccountEntryOrganizationRels(accountEntry.getAccountEntryId(), pagination.getStartPosition(), pagination.getEndPosition());
        long totalItems = this._accountEntryOrganizationRelService.getAccountEntryOrganizationRelsCount(accountEntry.getAccountEntryId());
        return Page.of(this._toAccountOrganizations(accountEntryOrganizationRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public AccountOrganization getAccountIdAccountOrganization(Long id, Long organizationId) throws Exception {
        AccountEntryOrganizationRel accountEntryOrganizationRel = this._accountEntryOrganizationRelService.getAccountEntryOrganizationRel(id.longValue(), organizationId.longValue());
        return (AccountOrganization)this._accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntryOrganizationRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=Account.class, value="organizations")
    public Page<AccountOrganization> getAccountIdAccountOrganizationsPage(Long id, Pagination pagination) throws Exception {
        List accountEntryOrganizationRels = this._accountEntryOrganizationRelService.getAccountEntryOrganizationRels(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        long totalItems = this._accountEntryOrganizationRelService.getAccountEntryOrganizationRelsCount(id.longValue());
        return Page.of(this._toAccountOrganizations(accountEntryOrganizationRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public AccountOrganization postAccountByExternalReferenceCodeAccountOrganization(String externalReferenceCode, AccountOrganization accountOrganization) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        AccountEntryOrganizationRel accountOrganizationRel = this._accountEntryOrganizationRelService.addAccountEntryOrganizationRel(accountEntry.getAccountEntryId(), AccountOrganizationUtil.getOrganizationId(this._organizationLocalService, accountOrganization, this.contextCompany.getCompanyId()));
        return (AccountOrganization)this._accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountOrganizationRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public AccountOrganization postAccountIdAccountOrganization(Long id, AccountOrganization accountOrganization) throws Exception {
        AccountEntryOrganizationRel accountOrganizationRel = this._accountEntryOrganizationRelService.addAccountEntryOrganizationRel(id.longValue(), AccountOrganizationUtil.getOrganizationId(this._organizationLocalService, accountOrganization, this.contextCompany.getCompanyId()));
        return (AccountOrganization)this._accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountOrganizationRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<AccountOrganization> _toAccountOrganizations(List<AccountEntryOrganizationRel> accountEntryOrganizationRels) throws Exception {
        return this.transform(accountEntryOrganizationRels, accountEntryOrganizationRel -> (AccountOrganization)this._accountOrganizationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)accountEntryOrganizationRel.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale())));
    }
}

