/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CommerceAddress"}, service={DTOConverter.class})
public class AccountAddressDTOConverter
implements DTOConverter<CommerceAddress, AccountAddress> {
    @Reference
    private CommerceAddressService _commerceAddressService;

    public String getContentType() {
        return AccountAddress.class.getSimpleName();
    }

    public AccountAddress toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(((Long)dtoConverterContext.getId()).longValue());
        return new AccountAddress(){
            {
                this.setCity(() -> ((CommerceAddress)commerceAddress).getCity());
                this.setCountryISOCode(() -> {
                    Country country = commerceAddress.getCountry();
                    return country.getA2();
                });
                this.setDefaultBilling(() -> ((CommerceAddress)commerceAddress).isDefaultBilling());
                this.setDefaultShipping(() -> ((CommerceAddress)commerceAddress).isDefaultShipping());
                this.setDescription(() -> ((CommerceAddress)commerceAddress).getDescription());
                this.setExternalReferenceCode(() -> ((CommerceAddress)commerceAddress).getExternalReferenceCode());
                this.setId(() -> ((CommerceAddress)commerceAddress).getCommerceAddressId());
                this.setLatitude(() -> ((CommerceAddress)commerceAddress).getLatitude());
                this.setLongitude(() -> ((CommerceAddress)commerceAddress).getLongitude());
                this.setName(() -> ((CommerceAddress)commerceAddress).getName());
                this.setPhoneNumber(() -> ((CommerceAddress)commerceAddress).getPhoneNumber());
                this.setRegionISOCode(() -> AccountAddressDTOConverter.this._getRegionISOCode(commerceAddress));
                this.setStreet1(() -> ((CommerceAddress)commerceAddress).getStreet1());
                this.setStreet2(() -> ((CommerceAddress)commerceAddress).getStreet2());
                this.setStreet3(() -> ((CommerceAddress)commerceAddress).getStreet3());
                this.setType(() -> ((CommerceAddress)commerceAddress).getType());
                this.setZip(() -> ((CommerceAddress)commerceAddress).getZip());
            }
        };
    }

    private String _getRegionISOCode(CommerceAddress commerceAddress) throws Exception {
        Region region = commerceAddress.getRegion();
        if (region == null) {
            return "";
        }
        return region.getRegionCode();
    }
}

