/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.account.exception.NoSuchEntryException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.exception.DuplicateCommerceShippingOptionAccountEntryRelException;
import com.liferay.commerce.exception.NoSuchShippingMethodException;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel;
import com.liferay.commerce.product.exception.NoSuchChannelException;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.service.CommerceShippingOptionAccountEntryRelService;
import com.liferay.commerce.shipping.engine.fixed.exception.NoSuchShippingFixedOptionException;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionLocalService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountChannelShippingOption;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountChannelShippingOptionResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountChannelShippingOptionResource;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-channel-shipping-option.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountChannelShippingOptionResource.class})
public class AccountChannelShippingOptionResourceImpl
extends BaseAccountChannelShippingOptionResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountChannelShippingOptionDTOConverter)")
    private DTOConverter<CommerceShippingOptionAccountEntryRel, AccountChannelShippingOption> _accountChannelShippingOptionDTOConverter;
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceShippingFixedOptionLocalService _commerceShippingFixedOptionLocalService;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel)")
    private volatile ModelResourcePermission<CommerceShippingOptionAccountEntryRel> _commerceShippingOptionAccountEntryRelModelResourcePermission;
    @Reference
    private CommerceShippingOptionAccountEntryRelService _commerceShippingOptionAccountEntryRelService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    @Override
    public void deleteAccountChannelShippingOption(Long id) throws Exception {
        this._commerceShippingOptionAccountEntryRelService.deleteCommerceShippingOptionAccountEntryRel(id.longValue());
    }

    @Override
    public Page<AccountChannelShippingOption> getAccountByExternalReferenceCodeAccountChannelShippingOptionPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), HashMapBuilder.put((Object)"create", this._addExternalReferenceCodeAction("UPDATE", "postAccountByExternalReferenceCodeAccountChannelShippingOption", accountEntry)).put((Object)"get", this._addExternalReferenceCodeAction("VIEW", "getAccountByExternalReferenceCodeAccountChannelShippingOptionPage", accountEntry)).build(), pagination);
    }

    @Override
    public AccountChannelShippingOption getAccountChannelShippingOption(Long id) throws Exception {
        return this._toAccountChannelShippingOption(this._commerceShippingOptionAccountEntryRelService.getCommerceShippingOptionAccountEntryRel(id.longValue()));
    }

    @Override
    public Page<AccountChannelShippingOption> getAccountIdAccountChannelShippingOptionPage(Long id, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(id.longValue());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this._getPage(accountEntry.getAccountEntryId(), HashMapBuilder.put((Object)"create", this.addAction("UPDATE", accountEntry.getAccountEntryId(), "postAccountIdAccountChannelShippingOption", this._accountEntryModelResourcePermission)).put((Object)"get", this.addAction("VIEW", accountEntry.getAccountEntryId(), "getAccountIdAccountChannelShippingOptionPage", this._accountEntryModelResourcePermission)).build(), pagination);
    }

    @Override
    public AccountChannelShippingOption patchAccountChannelShippingOption(Long id, AccountChannelShippingOption accountChannelShippingOption) throws Exception {
        CommerceShippingFixedOption commerceShippingFixedOption;
        CommerceShippingOptionAccountEntryRel commerceShippingOptionAccountEntryRel = this._commerceShippingOptionAccountEntryRelService.getCommerceShippingOptionAccountEntryRel(id.longValue());
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(commerceShippingOptionAccountEntryRel.getCommerceChannelId());
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodLocalService.fetchCommerceShippingMethod(commerceChannel.getGroupId(), accountChannelShippingOption.getShippingMethodKey());
        if (commerceShippingMethod == null || !commerceShippingMethod.isActive()) {
            commerceShippingMethod = this._commerceShippingMethodLocalService.fetchCommerceShippingMethod(GetterUtil.getLong((Object)accountChannelShippingOption.getShippingMethodId()));
            if (commerceShippingMethod == null || !commerceShippingMethod.isActive()) {
                throw new NoSuchShippingMethodException();
            }
            accountChannelShippingOption.setShippingMethodKey(() -> ((CommerceShippingMethod)commerceShippingMethod).getEngineKey());
        }
        if ((commerceShippingFixedOption = this._commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(this.contextCompany.getCompanyId(), accountChannelShippingOption.getShippingOptionKey())) == null) {
            commerceShippingFixedOption = this._commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(GetterUtil.getLong((Object)accountChannelShippingOption.getShippingOptionId()));
            if (commerceShippingFixedOption == null) {
                throw new NoSuchShippingFixedOptionException();
            }
            accountChannelShippingOption.setShippingOptionKey(() -> ((CommerceShippingFixedOption)commerceShippingFixedOption).getKey());
        }
        if (commerceShippingMethod.getCommerceShippingMethodId() != commerceShippingFixedOption.getCommerceShippingMethodId()) {
            throw new NoSuchShippingFixedOptionException();
        }
        return this._toAccountChannelShippingOption(this._commerceShippingOptionAccountEntryRelService.updateCommerceShippingOptionAccountEntryRel(commerceShippingOptionAccountEntryRel.getCommerceShippingOptionAccountEntryRelId(), accountChannelShippingOption.getShippingMethodKey(), accountChannelShippingOption.getShippingOptionKey()));
    }

    @Override
    public AccountChannelShippingOption postAccountByExternalReferenceCodeAccountChannelShippingOption(String externalReferenceCode, AccountChannelShippingOption accountChannelShippingOption) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        return this.postAccountIdAccountChannelShippingOption(accountEntry.getAccountEntryId(), accountChannelShippingOption);
    }

    @Override
    public AccountChannelShippingOption postAccountIdAccountChannelShippingOption(Long id, AccountChannelShippingOption accountChannelShippingOption) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(id.longValue());
        if (accountEntry == null) {
            throw new NoSuchEntryException();
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(this._getCommerceChannelId(accountChannelShippingOption));
        if (commerceChannel == null) {
            throw new NoSuchChannelException();
        }
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodLocalService.fetchCommerceShippingMethod(commerceChannel.getGroupId(), accountChannelShippingOption.getShippingMethodKey());
        if (!(commerceShippingMethod != null && commerceShippingMethod.isActive() || (commerceShippingMethod = this._commerceShippingMethodLocalService.fetchCommerceShippingMethod(GetterUtil.getLong((Object)accountChannelShippingOption.getShippingMethodId()))) != null && commerceShippingMethod.isActive())) {
            throw new NoSuchShippingMethodException();
        }
        CommerceShippingFixedOption commerceShippingFixedOption = this._commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(this.contextCompany.getCompanyId(), accountChannelShippingOption.getShippingOptionKey());
        if (commerceShippingFixedOption == null && (commerceShippingFixedOption = this._commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(GetterUtil.getLong((Object)accountChannelShippingOption.getShippingOptionId()))) == null) {
            throw new NoSuchShippingFixedOptionException();
        }
        if (commerceShippingMethod.getCommerceShippingMethodId() != commerceShippingFixedOption.getCommerceShippingMethodId()) {
            throw new NoSuchShippingFixedOptionException();
        }
        CommerceShippingOptionAccountEntryRel commerceShippingOptionAccountEntryRel = this._commerceShippingOptionAccountEntryRelService.fetchCommerceShippingOptionAccountEntryRel(accountEntry.getAccountEntryId(), commerceChannel.getCommerceChannelId());
        if (commerceShippingOptionAccountEntryRel != null) {
            throw new DuplicateCommerceShippingOptionAccountEntryRelException();
        }
        return this._toAccountChannelShippingOption(this._commerceShippingOptionAccountEntryRelService.addCommerceShippingOptionAccountEntryRel(accountEntry.getAccountEntryId(), commerceChannel.getCommerceChannelId(), commerceShippingMethod.getEngineKey(), commerceShippingFixedOption.getKey()));
    }

    private Map<String, String> _addExternalReferenceCodeAction(String actionKey, String methodName, AccountEntry accountEntry) throws Exception {
        Map<String, String> action = this.addAction(actionKey, accountEntry.getAccountEntryId(), methodName, this._accountEntryModelResourcePermission);
        if (action == null) {
            return action;
        }
        action.put("href", StringUtil.replace((String)action.get("href"), (String)("by-externalReferenceCode/" + String.valueOf(accountEntry.getAccountEntryId())), (String)("by-externalReferenceCode/" + accountEntry.getExternalReferenceCode())));
        return action;
    }

    private long _getCommerceChannelId(AccountChannelShippingOption accountChannelShippingOption) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchByExternalReferenceCode(GetterUtil.getString((String)accountChannelShippingOption.getChannelExternalReferenceCode()), this.contextCompany.getCompanyId());
        if (commerceChannel == null) {
            commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(GetterUtil.getLong((Object)accountChannelShippingOption.getChannelId()));
        }
        if (commerceChannel == null) {
            throw new NoSuchChannelException();
        }
        return commerceChannel.getCommerceChannelId();
    }

    private Page<AccountChannelShippingOption> _getPage(Long accountEntryId, Map<String, Map<String, String>> actions, Pagination pagination) throws Exception {
        return Page.of(actions, this.transform(this._commerceShippingOptionAccountEntryRelService.getCommerceShippingOptionAccountEntryRels(accountEntryId.longValue()), commerceShippingOptionAccountEntryRel -> this._toAccountChannelShippingOption((CommerceShippingOptionAccountEntryRel)commerceShippingOptionAccountEntryRel)), (Pagination)pagination, (long)this._commerceShippingOptionAccountEntryRelService.getCommerceShippingOptionAccountEntryRelsCount(accountEntryId.longValue()));
    }

    private AccountChannelShippingOption _toAccountChannelShippingOption(CommerceShippingOptionAccountEntryRel commerceShippingOptionAccountEntryRel) throws Exception {
        return (AccountChannelShippingOption)this._accountChannelShippingOptionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceShippingOptionAccountEntryRel.getCommerceShippingOptionAccountEntryRelId(), "deleteAccountChannelShippingOption", this._commerceShippingOptionAccountEntryRelModelResourcePermission)).put((Object)"get", this.addAction("VIEW", commerceShippingOptionAccountEntryRel.getCommerceShippingOptionAccountEntryRelId(), "getAccountChannelShippingOption", this._commerceShippingOptionAccountEntryRelModelResourcePermission)).put((Object)"patch", this.addAction("UPDATE", commerceShippingOptionAccountEntryRel.getCommerceShippingOptionAccountEntryRelId(), "patchAccountChannelShippingOption", this._commerceShippingOptionAccountEntryRelModelResourcePermission)).build(), this._dtoConverterRegistry, (Object)commerceShippingOptionAccountEntryRel.getCommerceShippingOptionAccountEntryRelId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), (Object)commerceShippingOptionAccountEntryRel);
    }
}

