/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.resource.v1_0;

import com.liferay.account.exception.NoSuchEntryException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryService;
import com.liferay.commerce.exception.NoSuchAddressException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.headless.commerce.admin.account.internal.resource.v1_0.BaseAccountAddressResourceImpl;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AccountAddressResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-address.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={AccountAddressResource.class})
public class AccountAddressResourceImpl
extends BaseAccountAddressResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter.AccountAddressDTOConverter)")
    private DTOConverter<CommerceAddress, AccountAddress> _accountAddressDTOConverter;
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CountryLocalService _countryService;
    @Reference
    private RegionLocalService _regionLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteAccountAddress(Long id) throws Exception {
        this._commerceAddressService.deleteCommerceAddress(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAccountAddressByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceAddress == null) {
            throw new NoSuchAddressException("Unable to find account address with external reference code " + externalReferenceCode);
        }
        this._commerceAddressService.deleteCommerceAddress(commerceAddress.getCommerceAddressId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public AccountAddress getAccountAddress(Long id) throws Exception {
        return this._toAccountAddress(this._commerceAddressService.getCommerceAddress(id.longValue()));
    }

    @Override
    public AccountAddress getAccountAddressByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceAddress == null) {
            throw new NoSuchAddressException("Unable to find account address with external reference code " + externalReferenceCode);
        }
        return this._toAccountAddress(commerceAddress);
    }

    @Override
    public Page<AccountAddress> getAccountByExternalReferenceCodeAccountAddressesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        return this._getAccountAddressesPage(accountEntry, pagination);
    }

    @Override
    @NestedField(parentClass=Account.class, value="accountAddresses")
    public Page<AccountAddress> getAccountIdAccountAddressesPage(Long id, Pagination pagination) throws Exception {
        return this._getAccountAddressesPage(this._accountEntryLocalService.getAccountEntry(id.longValue()), pagination);
    }

    @Override
    public AccountAddress patchAccountAddress(Long id, AccountAddress accountAddress) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(id.longValue());
        Country country = this._countryService.getCountryByA2(commerceAddress.getCompanyId(), accountAddress.getCountryISOCode());
        commerceAddress = this._commerceAddressService.updateCommerceAddress(commerceAddress.getCommerceAddressId(), GetterUtil.getString((String)accountAddress.getName(), (String)commerceAddress.getName()), GetterUtil.getString((String)accountAddress.getDescription(), (String)commerceAddress.getDescription()), GetterUtil.getString((String)accountAddress.getStreet1(), (String)commerceAddress.getStreet1()), GetterUtil.getString((String)accountAddress.getStreet2(), (String)commerceAddress.getStreet2()), GetterUtil.getString((String)accountAddress.getStreet3(), (String)commerceAddress.getStreet3()), GetterUtil.getString((String)accountAddress.getCity(), (String)commerceAddress.getCity()), GetterUtil.getString((String)accountAddress.getZip(), (String)commerceAddress.getZip()), GetterUtil.getLong((Object)this._getRegionId(country, accountAddress), (long)commerceAddress.getRegionId()), GetterUtil.getLong((Object)this._getCountryId(country), (long)commerceAddress.getCountryId()), GetterUtil.getString((String)accountAddress.getPhoneNumber(), (String)commerceAddress.getPhoneNumber()), GetterUtil.getInteger((Object)accountAddress.getType(), (int)commerceAddress.getType()), this._serviceContextHelper.getServiceContext());
        this._updateDefaultBillingShippingAddressId(commerceAddress.getClassPK(), accountAddress, commerceAddress);
        return this._toAccountAddress(commerceAddress);
    }

    @Override
    public Response patchAccountAddressByExternalReferenceCode(String externalReferenceCode, AccountAddress accountAddress) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceAddress == null) {
            throw new NoSuchAddressException("Unable to find account address with external reference code " + externalReferenceCode);
        }
        Country country = this._countryService.getCountryByA2(commerceAddress.getCompanyId(), accountAddress.getCountryISOCode());
        this._commerceAddressService.updateCommerceAddress(commerceAddress.getCommerceAddressId(), GetterUtil.getString((String)accountAddress.getName(), (String)commerceAddress.getName()), GetterUtil.getString((String)accountAddress.getDescription(), (String)commerceAddress.getDescription()), GetterUtil.getString((String)accountAddress.getStreet1(), (String)commerceAddress.getStreet1()), GetterUtil.getString((String)accountAddress.getStreet2(), (String)commerceAddress.getStreet2()), GetterUtil.getString((String)accountAddress.getStreet3(), (String)commerceAddress.getStreet3()), GetterUtil.getString((String)accountAddress.getCity(), (String)commerceAddress.getCity()), GetterUtil.getString((String)accountAddress.getZip(), (String)commerceAddress.getZip()), GetterUtil.getLong((Object)this._getRegionId(country, accountAddress), (long)commerceAddress.getRegionId()), GetterUtil.getLong((Object)this._getCountryId(country), (long)commerceAddress.getCountryId()), GetterUtil.getString((String)accountAddress.getPhoneNumber(), (String)commerceAddress.getPhoneNumber()), GetterUtil.getInteger((Object)accountAddress.getType(), (int)commerceAddress.getType()), this._serviceContextHelper.getServiceContext());
        this._updateDefaultBillingShippingAddressId(commerceAddress.getClassPK(), accountAddress, commerceAddress);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public AccountAddress postAccountByExternalReferenceCodeAccountAddress(String externalReferenceCode, AccountAddress accountAddress) throws Exception {
        AccountEntry accountEntry = this._accountEntryService.fetchAccountEntryByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (accountEntry == null) {
            throw new NoSuchEntryException("Unable to find account with external reference code " + externalReferenceCode);
        }
        CommerceAddress commerceAddress = null;
        if (accountAddress.getId() != null) {
            commerceAddress = this._commerceAddressService.fetchCommerceAddress(accountAddress.getId().longValue());
        } else if (accountAddress.getExternalReferenceCode() != null) {
            commerceAddress = this._commerceAddressService.fetchByExternalReferenceCode(accountAddress.getExternalReferenceCode(), this.contextCompany.getCompanyId());
        }
        if (commerceAddress != null) {
            Country country = this._countryService.getCountryByA2(commerceAddress.getCompanyId(), accountAddress.getCountryISOCode());
            return this._toAccountAddress(this._commerceAddressService.updateCommerceAddress(commerceAddress.getCommerceAddressId(), GetterUtil.getString((String)accountAddress.getName(), null), GetterUtil.getString((String)accountAddress.getDescription(), null), GetterUtil.getString((String)accountAddress.getStreet1(), null), GetterUtil.getString((String)accountAddress.getStreet2(), null), GetterUtil.getString((String)accountAddress.getStreet3(), null), GetterUtil.getString((String)accountAddress.getCity(), null), GetterUtil.getString((String)accountAddress.getZip(), null), GetterUtil.getLong((Object)this._getRegionId(country, accountAddress), (long)commerceAddress.getRegionId()), GetterUtil.getLong((Object)this._getCountryId(country), (long)commerceAddress.getCountryId()), GetterUtil.getString((String)accountAddress.getPhoneNumber(), null), GetterUtil.getInteger((Object)accountAddress.getType(), (int)commerceAddress.getType()), this._serviceContextHelper.getServiceContext()));
        }
        return this._addAccountAddress(accountEntry, accountAddress);
    }

    @Override
    public AccountAddress postAccountIdAccountAddress(Long id, AccountAddress accountAddress) throws Exception {
        return this._addAccountAddress(this._accountEntryLocalService.getAccountEntry(id.longValue()), accountAddress);
    }

    @Override
    public AccountAddress putAccountAddress(Long id, AccountAddress accountAddress) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(id.longValue());
        Country country = this._countryService.getCountryByA2(commerceAddress.getCompanyId(), accountAddress.getCountryISOCode());
        commerceAddress = this._commerceAddressService.updateCommerceAddress(commerceAddress.getCommerceAddressId(), GetterUtil.getString((String)accountAddress.getName()), GetterUtil.getString((String)accountAddress.getDescription()), GetterUtil.getString((String)accountAddress.getStreet1()), GetterUtil.getString((String)accountAddress.getStreet2()), GetterUtil.getString((String)accountAddress.getStreet3()), GetterUtil.getString((String)accountAddress.getCity()), GetterUtil.getString((String)accountAddress.getZip()), GetterUtil.getLong((Object)this._getRegionId(country, accountAddress), (long)commerceAddress.getRegionId()), GetterUtil.getLong((Object)this._getCountryId(country), (long)commerceAddress.getCountryId()), GetterUtil.getString((String)accountAddress.getPhoneNumber()), GetterUtil.getInteger((Object)accountAddress.getType()), this._serviceContextHelper.getServiceContext());
        return this._toAccountAddress(commerceAddress);
    }

    private AccountAddress _addAccountAddress(AccountEntry accountEntry, AccountAddress accountAddress) throws Exception {
        Country country = this._countryService.getCountryByA2(accountEntry.getCompanyId(), accountAddress.getCountryISOCode());
        CommerceAddress commerceAddress = this._commerceAddressService.addCommerceAddress(GetterUtil.getString((String)accountAddress.getExternalReferenceCode(), null), AccountEntry.class.getName(), accountEntry.getAccountEntryId(), accountAddress.getName(), accountAddress.getDescription(), accountAddress.getStreet1(), accountAddress.getStreet2(), accountAddress.getStreet3(), accountAddress.getCity(), accountAddress.getZip(), this._getRegionId(country, accountAddress), country.getCountryId(), accountAddress.getPhoneNumber(), GetterUtil.getInteger((Object)accountAddress.getType(), (int)2), this._serviceContextHelper.getServiceContext());
        this._updateDefaultBillingShippingAddressId(accountEntry.getAccountEntryId(), accountAddress, commerceAddress);
        return (AccountAddress)this._accountAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private Page<AccountAddress> _getAccountAddressesPage(AccountEntry accountEntry, Pagination pagination) throws Exception {
        List commerceAddresses = this._commerceAddressService.getCommerceAddresses(AccountEntry.class.getName(), accountEntry.getAccountEntryId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceAddressService.getCommerceAddressesCount(AccountEntry.class.getName(), accountEntry.getAccountEntryId());
        return Page.of(this._toAccountAddresses(commerceAddresses), (Pagination)pagination, (long)totalItems);
    }

    private long _getCountryId(Country country) {
        if (country == null) {
            return 0L;
        }
        return country.getCountryId();
    }

    private long _getRegionId(Country country, AccountAddress accountAddress) throws Exception {
        if (Validator.isNull((String)accountAddress.getRegionISOCode()) || country == null) {
            return 0L;
        }
        Region region = this._regionLocalService.getRegion(country.getCountryId(), accountAddress.getRegionISOCode());
        return region.getRegionId();
    }

    private AccountAddress _toAccountAddress(CommerceAddress commerceAddress) throws Exception {
        return (AccountAddress)this._accountAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<AccountAddress> _toAccountAddresses(List<CommerceAddress> commerceAddresses) throws Exception {
        ArrayList<AccountAddress> accountAddresses = new ArrayList<AccountAddress>();
        for (CommerceAddress commerceAddress : commerceAddresses) {
            accountAddresses.add((AccountAddress)this._accountAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return accountAddresses;
    }

    private void _updateDefaultBillingShippingAddressId(long accountEntryId, AccountAddress accountAddress, CommerceAddress commerceAddress) throws Exception {
        if (Boolean.TRUE.equals(accountAddress.getDefaultBilling())) {
            this._accountEntryLocalService.updateDefaultBillingAddressId(accountEntryId, commerceAddress.getCommerceAddressId());
            commerceAddress.setDefaultBilling(true);
        }
        if (Boolean.TRUE.equals(accountAddress.getDefaultShipping())) {
            this._accountEntryLocalService.updateDefaultShippingAddressId(accountEntryId, commerceAddress.getCommerceAddressId());
            commerceAddress.setDefaultShipping(true);
        }
    }
}

