/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.internal.dto.v1_0.converter;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.account.dto.v1_0.Account;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.webserver.WebServerServletToken;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.account.model.AccountEntry"}, service={DTOConverter.class})
public class AccountDTOConverter
implements DTOConverter<AccountEntry, Account> {
    private static final int _ACCOUNT_TYPE_BUSINESS = 2;
    private static final int _ACCOUNT_TYPE_GUEST = 0;
    private static final int _ACCOUNT_TYPE_PERSONAL = 1;
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WebServerServletToken _webServerServletToken;

    public String getContentType() {
        return Account.class.getSimpleName();
    }

    public Account toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        AccountEntry accountEntry;
        if ((Long)dtoConverterContext.getId() == -1L) {
            User user = dtoConverterContext.getUser();
            if (user == null) {
                user = this._userLocalService.getUserById(PrincipalThreadLocal.getUserId());
            }
            accountEntry = this._accountEntryLocalService.getGuestAccountEntry(user.getCompanyId());
        } else {
            accountEntry = this._accountEntryLocalService.getAccountEntry(((Long)dtoConverterContext.getId()).longValue());
        }
        final ExpandoBridge expandoBridge = accountEntry.getExpandoBridge();
        return new Account(){
            {
                this.active = AccountDTOConverter.this._toCommerceAccountActive(accountEntry.getStatus());
                this.customFields = expandoBridge.getAttributes();
                this.dateCreated = accountEntry.getCreateDate();
                this.dateModified = accountEntry.getModifiedDate();
                this.defaultBillingAccountAddressId = accountEntry.getDefaultBillingAddressId();
                this.defaultShippingAccountAddressId = accountEntry.getDefaultShippingAddressId();
                this.emailAddresses = new String[]{accountEntry.getEmailAddress()};
                this.externalReferenceCode = accountEntry.getExternalReferenceCode();
                this.id = accountEntry.getAccountEntryId();
                this.logoId = accountEntry.getLogoId();
                this.logoURL = StringBundler.concat((Object[])new Object[]{"/image/organization_logo?img_id=", accountEntry.getLogoId(), "&t=", AccountDTOConverter.this._webServerServletToken.getToken(accountEntry.getLogoId())});
                this.name = accountEntry.getName();
                this.root = accountEntry.getParentAccountEntryId() == 0L;
                this.taxId = accountEntry.getTaxIdNumber();
                this.type = AccountDTOConverter.this._toCommerceAccountType(accountEntry.getType());
            }
        };
    }

    private boolean _toCommerceAccountActive(int accountEntryStatus) {
        return accountEntryStatus == 0;
    }

    private Integer _toCommerceAccountType(String accountEntryType) {
        if (Objects.equals(accountEntryType, "business")) {
            return 2;
        }
        if (Objects.equals(accountEntryType, "guest")) {
            return 0;
        }
        if (Objects.equals(accountEntryType, "person")) {
            return 1;
        }
        return 0;
    }
}

